/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide;

import android.content.Context;
import android.os.Build;
import com.thirdparty.bumptech.glide.Glide;
import com.thirdparty.bumptech.glide.GlideBuilder$1;
import com.thirdparty.bumptech.glide.load.DecodeFormat;
import com.thirdparty.bumptech.glide.load.engine.Engine;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.BitmapPoolAdapter;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.LruBitmapPool;
import com.thirdparty.bumptech.glide.load.engine.cache.DiskCache;
import com.thirdparty.bumptech.glide.load.engine.cache.DiskCache$Factory;
import com.thirdparty.bumptech.glide.load.engine.cache.InternalCacheDiskCacheFactory;
import com.thirdparty.bumptech.glide.load.engine.cache.LruResourceCache;
import com.thirdparty.bumptech.glide.load.engine.cache.MemoryCache;
import com.thirdparty.bumptech.glide.load.engine.cache.MemorySizeCalculator;
import com.thirdparty.bumptech.glide.load.engine.executor.FifoPriorityThreadPoolExecutor;
import java.util.concurrent.ExecutorService;

public class GlideBuilder {
    private final Context context;
    private Engine engine;
    private BitmapPool bitmapPool;
    private MemoryCache memoryCache;
    private ExecutorService sourceService;
    private ExecutorService diskCacheService;
    private DecodeFormat decodeFormat;
    private DiskCache$Factory diskCacheFactory;

    /*
     * WARNING - void declaration
     */
    public GlideBuilder(Context context) {
        void var1_1;
        this.context = var1_1.getApplicationContext();
    }

    /*
     * WARNING - void declaration
     */
    public GlideBuilder setBitmapPool(BitmapPool bitmapPool) {
        void var1_1;
        this.bitmapPool = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GlideBuilder setMemoryCache(MemoryCache memoryCache) {
        void var1_1;
        this.memoryCache = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public GlideBuilder setDiskCache(DiskCache diskCache) {
        void var1_1;
        return this.setDiskCache(new GlideBuilder$1(this, (DiskCache)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public GlideBuilder setDiskCache(DiskCache$Factory diskCacheFactory) {
        void var1_1;
        this.diskCacheFactory = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GlideBuilder setResizeService(ExecutorService service) {
        void var1_1;
        this.sourceService = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GlideBuilder setDiskCacheService(ExecutorService service) {
        void var1_1;
        this.diskCacheService = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GlideBuilder setDecodeFormat(DecodeFormat decodeFormat) {
        void var1_1;
        this.decodeFormat = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    GlideBuilder setEngine(Engine engine) {
        void var1_1;
        this.engine = var1_1;
        return this;
    }

    Glide createGlide() {
        if (this.sourceService == null) {
            int n2 = Math.max(1, Runtime.getRuntime().availableProcessors());
            this.sourceService = new FifoPriorityThreadPoolExecutor(n2);
        }
        if (this.diskCacheService == null) {
            this.diskCacheService = new FifoPriorityThreadPoolExecutor(1);
        }
        MemorySizeCalculator memorySizeCalculator = new MemorySizeCalculator(this.context);
        if (this.bitmapPool == null) {
            if (Build.VERSION.SDK_INT >= 11) {
                int n3 = memorySizeCalculator.getBitmapPoolSize();
                this.bitmapPool = new LruBitmapPool(n3);
            } else {
                this.bitmapPool = new BitmapPoolAdapter();
            }
        }
        if (this.memoryCache == null) {
            this.memoryCache = new LruResourceCache(memorySizeCalculator.getMemoryCacheSize());
        }
        if (this.diskCacheFactory == null) {
            this.diskCacheFactory = new InternalCacheDiskCacheFactory(this.context);
        }
        if (this.engine == null) {
            this.engine = new Engine(this.memoryCache, this.diskCacheFactory, this.diskCacheService, this.sourceService);
        }
        if (this.decodeFormat == null) {
            this.decodeFormat = DecodeFormat.DEFAULT;
        }
        return new Glide(this.engine, this.memoryCache, this.bitmapPool, this.context, this.decodeFormat);
    }
}

