/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import com.thirdparty.bumptech.glide.Glide$ClearTarget;
import com.thirdparty.bumptech.glide.GlideBuilder;
import com.thirdparty.bumptech.glide.MemoryCategory;
import com.thirdparty.bumptech.glide.RequestManager;
import com.thirdparty.bumptech.glide.load.DecodeFormat;
import com.thirdparty.bumptech.glide.load.engine.Engine;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.thirdparty.bumptech.glide.load.engine.cache.MemoryCache;
import com.thirdparty.bumptech.glide.load.engine.prefill.BitmapPreFiller;
import com.thirdparty.bumptech.glide.load.engine.prefill.PreFillType;
import com.thirdparty.bumptech.glide.load.model.GenericLoaderFactory;
import com.thirdparty.bumptech.glide.load.model.GlideUrl;
import com.thirdparty.bumptech.glide.load.model.ImageVideoWrapper;
import com.thirdparty.bumptech.glide.load.model.ModelLoader;
import com.thirdparty.bumptech.glide.load.model.ModelLoaderFactory;
import com.thirdparty.bumptech.glide.load.model.file_descriptor.FileDescriptorFileLoader$Factory;
import com.thirdparty.bumptech.glide.load.model.file_descriptor.FileDescriptorResourceLoader$Factory;
import com.thirdparty.bumptech.glide.load.model.file_descriptor.FileDescriptorStringLoader$Factory;
import com.thirdparty.bumptech.glide.load.model.file_descriptor.FileDescriptorUriLoader$Factory;
import com.thirdparty.bumptech.glide.load.model.stream.HttpUrlGlideUrlLoader$Factory;
import com.thirdparty.bumptech.glide.load.model.stream.StreamByteArrayLoader$Factory;
import com.thirdparty.bumptech.glide.load.model.stream.StreamFileLoader$Factory;
import com.thirdparty.bumptech.glide.load.model.stream.StreamResourceLoader$Factory;
import com.thirdparty.bumptech.glide.load.model.stream.StreamStringLoader$Factory;
import com.thirdparty.bumptech.glide.load.model.stream.StreamUriLoader$Factory;
import com.thirdparty.bumptech.glide.load.model.stream.StreamUrlLoader$Factory;
import com.thirdparty.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.thirdparty.bumptech.glide.load.resource.bitmap.FileDescriptorBitmapDataLoadProvider;
import com.thirdparty.bumptech.glide.load.resource.bitmap.FitCenter;
import com.thirdparty.bumptech.glide.load.resource.bitmap.GlideBitmapDrawable;
import com.thirdparty.bumptech.glide.load.resource.bitmap.ImageVideoDataLoadProvider;
import com.thirdparty.bumptech.glide.load.resource.bitmap.StreamBitmapDataLoadProvider;
import com.thirdparty.bumptech.glide.load.resource.drawable.GlideDrawable;
import com.thirdparty.bumptech.glide.load.resource.file.StreamFileDataLoadProvider;
import com.thirdparty.bumptech.glide.load.resource.gif.GifDrawable;
import com.thirdparty.bumptech.glide.load.resource.gif.GifDrawableLoadProvider;
import com.thirdparty.bumptech.glide.load.resource.gifbitmap.GifBitmapWrapper;
import com.thirdparty.bumptech.glide.load.resource.gifbitmap.GifBitmapWrapperTransformation;
import com.thirdparty.bumptech.glide.load.resource.gifbitmap.ImageVideoGifDrawableLoadProvider;
import com.thirdparty.bumptech.glide.load.resource.transcode.GifBitmapWrapperDrawableTranscoder;
import com.thirdparty.bumptech.glide.load.resource.transcode.GlideBitmapDrawableTranscoder;
import com.thirdparty.bumptech.glide.load.resource.transcode.ResourceTranscoder;
import com.thirdparty.bumptech.glide.load.resource.transcode.TranscoderRegistry;
import com.thirdparty.bumptech.glide.manager.RequestManagerRetriever;
import com.thirdparty.bumptech.glide.module.GlideModule;
import com.thirdparty.bumptech.glide.module.ManifestParser;
import com.thirdparty.bumptech.glide.provider.DataLoadProvider;
import com.thirdparty.bumptech.glide.provider.DataLoadProviderRegistry;
import com.thirdparty.bumptech.glide.request.FutureTarget;
import com.thirdparty.bumptech.glide.request.Request;
import com.thirdparty.bumptech.glide.request.target.ImageViewTargetFactory;
import com.thirdparty.bumptech.glide.request.target.Target;
import com.thirdparty.bumptech.glide.util.Util;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;

public class Glide {
    private static final String TAG = "Glide";
    private static volatile Glide glide;
    private final GenericLoaderFactory loaderFactory;
    private final Engine engine;
    private final BitmapPool bitmapPool;
    private final MemoryCache memoryCache;
    private final DecodeFormat decodeFormat;
    private final ImageViewTargetFactory imageViewTargetFactory = new ImageViewTargetFactory();
    private final TranscoderRegistry transcoderRegistry = new TranscoderRegistry();
    private final DataLoadProviderRegistry dataLoadProviderRegistry;
    private final CenterCrop bitmapCenterCrop;
    private final GifBitmapWrapperTransformation drawableCenterCrop;
    private final FitCenter bitmapFitCenter;
    private final GifBitmapWrapperTransformation drawableFitCenter;
    private final Handler mainHandler;
    private final BitmapPreFiller bitmapPreFiller;

    public static File getPhotoCacheDir(Context context) {
        return Glide.getPhotoCacheDir(context, "image_manager_disk_cache");
    }

    /*
     * WARNING - void declaration
     */
    public static File getPhotoCacheDir(Context context, String cacheName) {
        Object object = context.getCacheDir();
        if (object != null) {
            void var1_1;
            if (!(((File)(object = new File((File)object, (String)var1_1))).mkdirs() || ((File)object).exists() && ((File)object).isDirectory())) {
                return null;
            }
            return object;
        }
        if (Log.isLoggable((String)TAG, (int)6)) {
            Log.e((String)TAG, (String)"default disk cache dir is null");
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Glide get(Context context) {
        if (glide != null) return glide;
        Class<Glide> clazz = Glide.class;
        synchronized (Glide.class) {
            Context context2;
            if (glide != null) return glide;
            context2 = context2.getApplicationContext();
            List<GlideModule> list = new ManifestParser(context2).parse();
            GlideBuilder glideBuilder = new GlideBuilder(context2);
            Iterator<GlideModule> iterator = list.iterator();
            while (iterator.hasNext()) {
                iterator.next().applyOptions(context2, glideBuilder);
            }
            glide = glideBuilder.createGlide();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                iterator.next().registerComponents(context2, glide);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return glide;
        }
    }

    @Deprecated
    public static boolean isSetup() {
        return glide != null;
    }

    @Deprecated
    public static void setup(GlideBuilder builder) {
        GlideBuilder glideBuilder;
        if (Glide.isSetup()) {
            throw new IllegalArgumentException("Glide is already setup, check with isSetup() first");
        }
        glide = glideBuilder.createGlide();
    }

    static void tearDown() {
        glide = null;
    }

    /*
     * WARNING - void declaration
     */
    Glide(Engine engine, MemoryCache memoryCache, BitmapPool bitmapPool, Context context, DecodeFormat decodeFormat) {
        void var3_3;
        DataLoadProvider<ParcelFileDescriptor, Bitmap> dataLoadProvider;
        DataLoadProvider<InputStream, Bitmap> dataLoadProvider2;
        this.engine = dataLoadProvider2;
        this.bitmapPool = bitmapPool;
        this.memoryCache = memoryCache;
        this.decodeFormat = decodeFormat;
        this.loaderFactory = new GenericLoaderFactory(context);
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.bitmapPreFiller = new BitmapPreFiller((MemoryCache)((Object)dataLoadProvider), bitmapPool, decodeFormat);
        this.dataLoadProviderRegistry = new DataLoadProviderRegistry();
        dataLoadProvider2 = new StreamBitmapDataLoadProvider(bitmapPool, decodeFormat);
        this.dataLoadProviderRegistry.register(InputStream.class, Bitmap.class, dataLoadProvider2);
        dataLoadProvider = new FileDescriptorBitmapDataLoadProvider(bitmapPool, decodeFormat);
        this.dataLoadProviderRegistry.register(ParcelFileDescriptor.class, Bitmap.class, dataLoadProvider);
        dataLoadProvider2 = new ImageVideoDataLoadProvider(dataLoadProvider2, dataLoadProvider);
        this.dataLoadProviderRegistry.register(ImageVideoWrapper.class, Bitmap.class, dataLoadProvider2);
        dataLoadProvider = new GifDrawableLoadProvider(context, bitmapPool);
        this.dataLoadProviderRegistry.register(InputStream.class, GifDrawable.class, dataLoadProvider);
        this.dataLoadProviderRegistry.register(ImageVideoWrapper.class, GifBitmapWrapper.class, new ImageVideoGifDrawableLoadProvider(dataLoadProvider2, dataLoadProvider, bitmapPool));
        this.dataLoadProviderRegistry.register(InputStream.class, File.class, new StreamFileDataLoadProvider());
        this.register(File.class, ParcelFileDescriptor.class, new FileDescriptorFileLoader$Factory());
        this.register(File.class, InputStream.class, new StreamFileLoader$Factory());
        this.register(Integer.TYPE, ParcelFileDescriptor.class, new FileDescriptorResourceLoader$Factory());
        this.register(Integer.TYPE, InputStream.class, new StreamResourceLoader$Factory());
        this.register(Integer.class, ParcelFileDescriptor.class, new FileDescriptorResourceLoader$Factory());
        this.register(Integer.class, InputStream.class, new StreamResourceLoader$Factory());
        this.register(String.class, ParcelFileDescriptor.class, new FileDescriptorStringLoader$Factory());
        this.register(String.class, InputStream.class, new StreamStringLoader$Factory());
        this.register(Uri.class, ParcelFileDescriptor.class, new FileDescriptorUriLoader$Factory());
        this.register(Uri.class, InputStream.class, new StreamUriLoader$Factory());
        this.register(URL.class, InputStream.class, new StreamUrlLoader$Factory());
        this.register(GlideUrl.class, InputStream.class, new HttpUrlGlideUrlLoader$Factory());
        this.register(byte[].class, InputStream.class, new StreamByteArrayLoader$Factory());
        this.transcoderRegistry.register(Bitmap.class, GlideBitmapDrawable.class, new GlideBitmapDrawableTranscoder(context.getResources(), bitmapPool));
        this.transcoderRegistry.register(GifBitmapWrapper.class, GlideDrawable.class, new GifBitmapWrapperDrawableTranscoder(new GlideBitmapDrawableTranscoder(context.getResources(), bitmapPool)));
        this.bitmapCenterCrop = new CenterCrop(bitmapPool);
        this.drawableCenterCrop = new GifBitmapWrapperTransformation(bitmapPool, this.bitmapCenterCrop);
        this.bitmapFitCenter = new FitCenter(bitmapPool);
        this.drawableFitCenter = new GifBitmapWrapperTransformation((BitmapPool)var3_3, this.bitmapFitCenter);
    }

    public BitmapPool getBitmapPool() {
        return this.bitmapPool;
    }

    /*
     * WARNING - void declaration
     */
    <Z, R> ResourceTranscoder<Z, R> buildTranscoder(Class<Z> decodedClass, Class<R> transcodedClass) {
        void var2_2;
        void var1_1;
        return this.transcoderRegistry.get(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    <T, Z> DataLoadProvider<T, Z> buildDataProvider(Class<T> dataClass, Class<Z> decodedClass) {
        void var2_2;
        void var1_1;
        return this.dataLoadProviderRegistry.get(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    <R> Target<R> buildImageViewTarget(ImageView imageView, Class<R> transcodedClass) {
        void var2_2;
        void var1_1;
        return this.imageViewTargetFactory.buildTarget((ImageView)var1_1, var2_2);
    }

    Engine getEngine() {
        return this.engine;
    }

    CenterCrop getBitmapCenterCrop() {
        return this.bitmapCenterCrop;
    }

    FitCenter getBitmapFitCenter() {
        return this.bitmapFitCenter;
    }

    GifBitmapWrapperTransformation getDrawableCenterCrop() {
        return this.drawableCenterCrop;
    }

    GifBitmapWrapperTransformation getDrawableFitCenter() {
        return this.drawableFitCenter;
    }

    Handler getMainHandler() {
        return this.mainHandler;
    }

    DecodeFormat getDecodeFormat() {
        return this.decodeFormat;
    }

    private GenericLoaderFactory getLoaderFactory() {
        return this.loaderFactory;
    }

    /*
     * WARNING - void declaration
     */
    public void preFillBitmapPool(PreFillType.Builder ... bitmapAttributeBuilders) {
        void var1_1;
        this.bitmapPreFiller.preFill((PreFillType.Builder[])var1_1);
    }

    public void clearMemory() {
        this.bitmapPool.clearMemory();
        this.memoryCache.clearMemory();
    }

    /*
     * WARNING - void declaration
     */
    public void trimMemory(int level) {
        void var1_1;
        this.bitmapPool.trimMemory(level);
        this.memoryCache.trimMemory((int)var1_1);
    }

    public void clearDiskCache() {
        Util.assertBackgroundThread();
        this.getEngine().clearDiskCache();
    }

    /*
     * WARNING - void declaration
     */
    public void setMemoryCategory(MemoryCategory memoryCategory) {
        void var1_1;
        this.memoryCache.setSizeMultiplier(memoryCategory.getMultiplier());
        this.bitmapPool.setSizeMultiplier(var1_1.getMultiplier());
    }

    public static void clear(Target<?> target) {
        Util.assertMainThread();
        Request request = target.getRequest();
        if (request != null) {
            Target<?> target2;
            request.clear();
            target2.setRequest(null);
        }
    }

    public static void clear(FutureTarget<?> target) {
        target.clear();
    }

    public static void clear(View view) {
        View view2;
        Glide.clear(new Glide$ClearTarget(view2));
    }

    /*
     * WARNING - void declaration
     */
    public <T, Y> void register(Class<T> modelClass, Class<Y> resourceClass, ModelLoaderFactory<T, Y> factory) {
        void var3_3;
        void var2_2;
        ModelLoaderFactory modelLoaderFactory;
        if ((modelLoaderFactory = this.loaderFactory.register(modelLoaderFactory, var2_2, var3_3)) != null) {
            modelLoaderFactory.teardown();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public <T, Y> void unregister(Class<T> modelClass, Class<Y> resourceClass) {
        void var2_2;
        ModelLoaderFactory modelLoaderFactory;
        if ((modelLoaderFactory = this.loaderFactory.unregister(modelLoaderFactory, var2_2)) != null) {
            modelLoaderFactory.teardown();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T, Y> ModelLoader<T, Y> buildModelLoader(Class<T> modelClass, Class<Y> resourceClass, Context context) {
        void var1_1;
        Class<T> clazz;
        void var2_2;
        if (modelClass == null) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Unable to load null model, setting placeholder only");
            }
            return null;
        }
        return Glide.get((Context)var2_2).getLoaderFactory().buildModelLoader(clazz, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T, Y> ModelLoader<T, Y> buildModelLoader(T model, Class<Y> resourceClass, Context context) {
        void var2_2;
        void var1_1;
        T t2;
        return Glide.buildModelLoader(model != null ? t2.getClass() : null, var1_1, (Context)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> ModelLoader<T, InputStream> buildStreamModelLoader(Class<T> modelClass, Context context) {
        void var1_1;
        return Glide.buildModelLoader(modelClass, InputStream.class, (Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> ModelLoader<T, InputStream> buildStreamModelLoader(T model, Context context) {
        void var1_1;
        return Glide.buildModelLoader(model, InputStream.class, (Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> ModelLoader<T, ParcelFileDescriptor> buildFileDescriptorModelLoader(Class<T> modelClass, Context context) {
        void var1_1;
        return Glide.buildModelLoader(modelClass, ParcelFileDescriptor.class, (Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> ModelLoader<T, ParcelFileDescriptor> buildFileDescriptorModelLoader(T model, Context context) {
        void var1_1;
        return Glide.buildModelLoader(model, ParcelFileDescriptor.class, (Context)var1_1);
    }

    public static RequestManager with(Context context) {
        Context context2;
        return RequestManagerRetriever.get().get(context2);
    }

    public static RequestManager with(Activity activity) {
        Activity activity2;
        return RequestManagerRetriever.get().get(activity2);
    }

    public static RequestManager with(FragmentActivity activity) {
        FragmentActivity fragmentActivity;
        return RequestManagerRetriever.get().get(fragmentActivity);
    }

    @TargetApi(value=11)
    public static RequestManager with(Fragment fragment) {
        Fragment fragment2;
        return RequestManagerRetriever.get().get(fragment2);
    }

    public static RequestManager with(android.support.v4.app.Fragment fragment) {
        android.support.v4.app.Fragment fragment2;
        return RequestManagerRetriever.get().get(fragment2);
    }
}

