/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.animation.Animation;
import android.widget.ImageView;
import com.thirdparty.bumptech.glide.GenericRequestBuilder$1;
import com.thirdparty.bumptech.glide.Glide;
import com.thirdparty.bumptech.glide.Priority;
import com.thirdparty.bumptech.glide.load.Encoder;
import com.thirdparty.bumptech.glide.load.Key;
import com.thirdparty.bumptech.glide.load.MultiTransformation;
import com.thirdparty.bumptech.glide.load.ResourceDecoder;
import com.thirdparty.bumptech.glide.load.ResourceEncoder;
import com.thirdparty.bumptech.glide.load.Transformation;
import com.thirdparty.bumptech.glide.load.engine.DiskCacheStrategy;
import com.thirdparty.bumptech.glide.load.resource.UnitTransformation;
import com.thirdparty.bumptech.glide.load.resource.transcode.ResourceTranscoder;
import com.thirdparty.bumptech.glide.manager.Lifecycle;
import com.thirdparty.bumptech.glide.manager.RequestTracker;
import com.thirdparty.bumptech.glide.provider.ChildLoadProvider;
import com.thirdparty.bumptech.glide.provider.LoadProvider;
import com.thirdparty.bumptech.glide.request.FutureTarget;
import com.thirdparty.bumptech.glide.request.GenericRequest;
import com.thirdparty.bumptech.glide.request.Request;
import com.thirdparty.bumptech.glide.request.RequestCoordinator;
import com.thirdparty.bumptech.glide.request.RequestFutureTarget;
import com.thirdparty.bumptech.glide.request.RequestListener;
import com.thirdparty.bumptech.glide.request.ThumbnailRequestCoordinator;
import com.thirdparty.bumptech.glide.request.animation.GlideAnimationFactory;
import com.thirdparty.bumptech.glide.request.animation.NoAnimation;
import com.thirdparty.bumptech.glide.request.animation.ViewAnimationFactory;
import com.thirdparty.bumptech.glide.request.animation.ViewPropertyAnimation$Animator;
import com.thirdparty.bumptech.glide.request.animation.ViewPropertyAnimationFactory;
import com.thirdparty.bumptech.glide.request.target.PreloadTarget;
import com.thirdparty.bumptech.glide.request.target.Target;
import com.thirdparty.bumptech.glide.signature.EmptySignature;
import com.thirdparty.bumptech.glide.util.Util;
import java.io.File;

public class GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType>
implements Cloneable {
    protected final Class<ModelType> modelClass;
    protected final Context context;
    protected final Glide glide;
    protected final Class<TranscodeType> transcodeClass;
    protected final RequestTracker requestTracker;
    protected final Lifecycle lifecycle;
    private ChildLoadProvider<ModelType, DataType, ResourceType, TranscodeType> loadProvider;
    private ModelType model;
    private Key signature = EmptySignature.obtain();
    private boolean isModelSet;
    private int placeholderId;
    private int errorId;
    private RequestListener<? super ModelType, TranscodeType> requestListener;
    private Float thumbSizeMultiplier;
    private GenericRequestBuilder<?, ?, ?, TranscodeType> thumbnailRequestBuilder;
    private Float sizeMultiplier = Float.valueOf(1.0f);
    private Drawable placeholderDrawable;
    private Drawable errorPlaceholder;
    private Priority priority = null;
    private boolean isCacheable = true;
    private GlideAnimationFactory<TranscodeType> animationFactory = NoAnimation.getFactory();
    private int overrideHeight = -1;
    private int overrideWidth = -1;
    private DiskCacheStrategy diskCacheStrategy = DiskCacheStrategy.RESULT;
    private Transformation<ResourceType> transformation = UnitTransformation.get();
    private boolean isTransformationSet;
    private boolean isThumbnailBuilt;
    private Drawable fallbackDrawable;
    private int fallbackResource;

    /*
     * WARNING - void declaration
     */
    GenericRequestBuilder(LoadProvider<ModelType, DataType, ResourceType, TranscodeType> loadProvider, Class<TranscodeType> transcodeClass, GenericRequestBuilder<ModelType, ?, ?, ?> other) {
        this(other.context, other.modelClass, (LoadProvider<ModelType, DataType, ResourceType, TranscodeType>)var1_1, (Class<TranscodeType>)var2_2, other.glide, other.requestTracker, other.lifecycle);
        void var3_3;
        void var2_2;
        void var1_1;
        this.model = other.model;
        this.isModelSet = other.isModelSet;
        this.signature = other.signature;
        this.diskCacheStrategy = other.diskCacheStrategy;
        this.isCacheable = var3_3.isCacheable;
    }

    /*
     * WARNING - void declaration
     */
    GenericRequestBuilder(Context context, Class<ModelType> modelClass, LoadProvider<ModelType, DataType, ResourceType, TranscodeType> loadProvider, Class<TranscodeType> transcodeClass, Glide glide, RequestTracker requestTracker, Lifecycle lifecycle) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.context = context;
        this.modelClass = modelClass;
        this.transcodeClass = transcodeClass;
        this.glide = glide;
        this.requestTracker = requestTracker;
        this.lifecycle = lifecycle;
        ChildLoadProvider<ModelType, DataType, ResourceType, TranscodeType> childLoadProvider = this.loadProvider = loadProvider != null ? new ChildLoadProvider<ModelType, DataType, ResourceType, TranscodeType>(loadProvider) : null;
        if (var1_1 == null) {
            throw new NullPointerException("Context can't be null");
        }
        if (var2_2 != null && var3_3 == null) {
            throw new NullPointerException("LoadProvider must not be null");
        }
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> thumbnail(GenericRequestBuilder<?, ?, ?, TranscodeType> thumbnailRequest) {
        void var1_1;
        if (this.equals(thumbnailRequest)) {
            throw new IllegalArgumentException("You cannot set a request as a thumbnail for itself. Consider using clone() on the request you are passing to thumbnail()");
        }
        this.thumbnailRequestBuilder = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> thumbnail(float sizeMultiplier) {
        void var1_1;
        if (sizeMultiplier < 0.0f || sizeMultiplier > 1.0f) {
            throw new IllegalArgumentException("sizeMultiplier must be between 0 and 1");
        }
        this.thumbSizeMultiplier = Float.valueOf((float)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> sizeMultiplier(float sizeMultiplier) {
        void var1_1;
        if (sizeMultiplier < 0.0f || sizeMultiplier > 1.0f) {
            throw new IllegalArgumentException("sizeMultiplier must be between 0 and 1");
        }
        this.sizeMultiplier = Float.valueOf((float)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> decoder(ResourceDecoder<DataType, ResourceType> decoder) {
        if (this.loadProvider != null) {
            void var1_1;
            this.loadProvider.setSourceDecoder((ResourceDecoder<DataType, ResourceType>)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> cacheDecoder(ResourceDecoder<File, ResourceType> cacheDecoder) {
        if (this.loadProvider != null) {
            void var1_1;
            this.loadProvider.setCacheDecoder((ResourceDecoder<File, ResourceType>)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> sourceEncoder(Encoder<DataType> sourceEncoder) {
        if (this.loadProvider != null) {
            void var1_1;
            this.loadProvider.setSourceEncoder((Encoder<DataType>)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> diskCacheStrategy(DiskCacheStrategy strategy) {
        void var1_1;
        this.diskCacheStrategy = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> encoder(ResourceEncoder<ResourceType> encoder) {
        if (this.loadProvider != null) {
            void var1_1;
            this.loadProvider.setEncoder((ResourceEncoder<ResourceType>)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> priority(Priority priority) {
        void var1_1;
        this.priority = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> transform(Transformation<ResourceType> ... transformations) {
        void var1_1;
        this.isTransformationSet = true;
        this.transformation = transformations.length == 1 ? transformations[0] : new MultiTransformation<ResourceType>(var1_1);
        return this;
    }

    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> dontTransform() {
        UnitTransformation unitTransformation = UnitTransformation.get();
        return this.transform(unitTransformation);
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> transcoder(ResourceTranscoder<ResourceType, TranscodeType> transcoder) {
        if (this.loadProvider != null) {
            void var1_1;
            this.loadProvider.setTranscoder((ResourceTranscoder<ResourceType, TranscodeType>)var1_1);
        }
        return this;
    }

    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> dontAnimate() {
        GlideAnimationFactory glideAnimationFactory = NoAnimation.getFactory();
        return this.animate(glideAnimationFactory);
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> animate(int animationId) {
        void var1_1;
        return this.animate(new ViewAnimationFactory(this.context, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> animate(Animation animation) {
        void var1_1;
        return this.animate(new ViewAnimationFactory((Animation)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> animate(ViewPropertyAnimation$Animator animator) {
        void var1_1;
        return this.animate(new ViewPropertyAnimationFactory((ViewPropertyAnimation$Animator)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> animate(GlideAnimationFactory<TranscodeType> animationFactory) {
        void var1_1;
        if (animationFactory == null) {
            throw new NullPointerException("Animation factory must not be null!");
        }
        this.animationFactory = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> placeholder(int resourceId) {
        void var1_1;
        this.placeholderId = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> placeholder(Drawable drawable) {
        void var1_1;
        this.placeholderDrawable = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> fallback(Drawable drawable) {
        void var1_1;
        this.fallbackDrawable = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> fallback(int resourceId) {
        void var1_1;
        this.fallbackResource = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> error(int resourceId) {
        void var1_1;
        this.errorId = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> error(Drawable drawable) {
        void var1_1;
        this.errorPlaceholder = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> listener(RequestListener<? super ModelType, TranscodeType> requestListener) {
        void var1_1;
        this.requestListener = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> skipMemoryCache(boolean skip) {
        void var1_1;
        this.isCacheable = var1_1 == false;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> override(int width, int height) {
        void var2_2;
        void var1_1;
        if (!Util.isValidDimensions(width, height)) {
            throw new IllegalArgumentException("Width and height must be Target#SIZE_ORIGINAL or > 0");
        }
        this.overrideWidth = var1_1;
        this.overrideHeight = var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> signature(Key signature) {
        void var1_1;
        if (signature == null) {
            throw new NullPointerException("Signature must not be null");
        }
        this.signature = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> load(ModelType model) {
        void var1_1;
        this.model = var1_1;
        this.isModelSet = true;
        return this;
    }

    public GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> clone() {
        try {
            GenericRequestBuilder genericRequestBuilder = (GenericRequestBuilder)super.clone();
            ((GenericRequestBuilder)super.clone()).loadProvider = this.loadProvider != null ? this.loadProvider.clone() : null;
            return genericRequestBuilder;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    /*
     * WARNING - void declaration
     */
    public <Y extends Target<TranscodeType>> Y into(Y target) {
        void var1_1;
        Util.assertMainThread();
        if (target == null) {
            throw new IllegalArgumentException("You must pass in a non null Target");
        }
        if (!this.isModelSet) {
            throw new IllegalArgumentException("You must first set a model (try #load())");
        }
        Request request = target.getRequest();
        if (request != null) {
            request.clear();
            this.requestTracker.removeRequest(request);
            request.recycle();
        }
        request = this.buildRequest(target);
        target.setRequest(request);
        this.lifecycle.addListener(target);
        this.requestTracker.runRequest(request);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Target<TranscodeType> into(ImageView view) {
        void var1_1;
        Util.assertMainThread();
        if (view == null) {
            throw new IllegalArgumentException("You must pass in a non null View");
        }
        if (!this.isTransformationSet && view.getScaleType() != null) {
            switch (view.getScaleType()) {
                case CENTER_CROP: {
                    this.applyCenterCrop();
                    break;
                }
                case FIT_CENTER: 
                case FIT_END: 
                case FIT_START: {
                    this.applyFitCenter();
                }
            }
        }
        return this.into(this.glide.buildImageViewTarget((ImageView)var1_1, this.transcodeClass));
    }

    /*
     * WARNING - void declaration
     */
    public FutureTarget<TranscodeType> into(int width, int height) {
        void var2_3;
        void var1_1;
        RequestFutureTarget requestFutureTarget = new RequestFutureTarget(this.glide.getMainHandler(), (int)var1_1, (int)var2_3);
        this.glide.getMainHandler().post((Runnable)new GenericRequestBuilder$1(this, requestFutureTarget));
        return requestFutureTarget;
    }

    /*
     * WARNING - void declaration
     */
    public Target<TranscodeType> preload(int width, int height) {
        void var2_3;
        PreloadTarget preloadTarget = PreloadTarget.obtain(width, (int)var2_3);
        return this.into(preloadTarget);
    }

    public Target<TranscodeType> preload() {
        return this.preload(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    void applyCenterCrop() {
    }

    void applyFitCenter() {
    }

    private Priority getThumbnailPriority() {
        Priority priority = this.priority == Priority.LOW ? Priority.NORMAL : (this.priority == Priority.NORMAL ? Priority.HIGH : Priority.IMMEDIATE);
        return priority;
    }

    /*
     * WARNING - void declaration
     */
    private Request buildRequest(Target<TranscodeType> target) {
        void var1_1;
        if (this.priority == null) {
            this.priority = Priority.NORMAL;
        }
        return this.buildRequestRecursive((Target<TranscodeType>)var1_1, null);
    }

    private Request buildRequestRecursive(Target<TranscodeType> target, ThumbnailRequestCoordinator parentCoordinator) {
        Request request;
        ThumbnailRequestCoordinator thumbnailRequestCoordinator;
        if (this.thumbnailRequestBuilder != null) {
            if (this.isThumbnailBuilt) {
                throw new IllegalStateException("You cannot use a request as both the main request and a thumbnail, consider using clone() on the request(s) passed to thumbnail()");
            }
            if (this.thumbnailRequestBuilder.animationFactory.equals(NoAnimation.getFactory())) {
                this.thumbnailRequestBuilder.animationFactory = this.animationFactory;
            }
            if (this.thumbnailRequestBuilder.priority == null) {
                this.thumbnailRequestBuilder.priority = this.getThumbnailPriority();
            }
            if (Util.isValidDimensions(this.overrideWidth, this.overrideHeight) && !Util.isValidDimensions(this.thumbnailRequestBuilder.overrideWidth, this.thumbnailRequestBuilder.overrideHeight)) {
                this.thumbnailRequestBuilder.override(this.overrideWidth, this.overrideHeight);
            }
            thumbnailRequestCoordinator = new ThumbnailRequestCoordinator(thumbnailRequestCoordinator);
            Request request2 = this.obtainRequest(target, this.sizeMultiplier.floatValue(), this.priority, thumbnailRequestCoordinator);
            this.isThumbnailBuilt = true;
            request = super.buildRequestRecursive((Target<TranscodeType>)((Object)request), thumbnailRequestCoordinator);
            this.isThumbnailBuilt = false;
            thumbnailRequestCoordinator.setRequests(request2, request);
            return thumbnailRequestCoordinator;
        }
        if (this.thumbSizeMultiplier != null) {
            thumbnailRequestCoordinator = new ThumbnailRequestCoordinator(thumbnailRequestCoordinator);
            Request request3 = this.obtainRequest((Target<TranscodeType>)((Object)request), this.sizeMultiplier.floatValue(), this.priority, thumbnailRequestCoordinator);
            request = this.obtainRequest((Target<TranscodeType>)((Object)request), this.thumbSizeMultiplier.floatValue(), this.getThumbnailPriority(), thumbnailRequestCoordinator);
            thumbnailRequestCoordinator.setRequests(request3, request);
            return thumbnailRequestCoordinator;
        }
        return this.obtainRequest((Target<TranscodeType>)((Object)request), this.sizeMultiplier.floatValue(), this.priority, thumbnailRequestCoordinator);
    }

    /*
     * WARNING - void declaration
     */
    private Request obtainRequest(Target<TranscodeType> target, float sizeMultiplier, Priority priority, RequestCoordinator requestCoordinator) {
        void var2_2;
        void var1_1;
        void var3_3;
        return GenericRequest.obtain(this.loadProvider, this.model, this.signature, this.context, (Priority)var3_3, var1_1, (float)var2_2, this.placeholderDrawable, this.placeholderId, this.errorPlaceholder, this.errorId, this.fallbackDrawable, this.fallbackResource, this.requestListener, requestCoordinator, this.glide.getEngine(), this.transformation, this.transcodeClass, this.isCacheable, this.animationFactory, this.overrideWidth, this.overrideHeight, this.diskCacheStrategy);
    }
}

