/*
 * Decompiled with CFR 0.152.
 */
package com.melink.baseframe.widget;

import android.graphics.Camera;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.melink.baseframe.utils.SystemTool;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public final class AnimatorProxy
extends Animation {
    public static final boolean NEEDS_PROXY = SystemTool.getSDKVersion() < 11;
    private static final WeakHashMap<View, AnimatorProxy> PROXIES = new WeakHashMap();
    private final WeakReference<View> mView;
    private final Camera mCamera = new Camera();
    private boolean mHasPivot;
    private float mAlpha = 1.0f;
    private float mPivotX;
    private float mPivotY;
    private float mRotationX;
    private float mRotationY;
    private float mRotationZ;
    private float mScaleX = 1.0f;
    private float mScaleY = 1.0f;
    private float mTranslationX;
    private float mTranslationY;
    private final RectF mBefore = new RectF();
    private final RectF mAfter = new RectF();
    private final Matrix mTempMatrix = new Matrix();

    public static AnimatorProxy wrap(View view) {
        AnimatorProxy animatorProxy = PROXIES.get(view);
        if (animatorProxy == null || animatorProxy != view.getAnimation()) {
            View view2;
            animatorProxy = new AnimatorProxy(view);
            PROXIES.put(view2, animatorProxy);
        }
        return animatorProxy;
    }

    /*
     * WARNING - void declaration
     */
    private AnimatorProxy(View view) {
        void var1_1;
        this.setDuration(0L);
        this.setFillAfter(true);
        view.setAnimation((Animation)this);
        this.mView = new WeakReference<void>(var1_1);
    }

    public final float getAlpha() {
        return this.mAlpha;
    }

    /*
     * WARNING - void declaration
     */
    public final void setAlpha(float alpha) {
        if (this.mAlpha != alpha) {
            void var1_1;
            this.mAlpha = var1_1;
            View view = (View)this.mView.get();
            if (view != null) {
                view.invalidate();
            }
        }
    }

    public final float getPivotX() {
        return this.mPivotX;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPivotX(float pivotX) {
        if (!this.mHasPivot || this.mPivotX != pivotX) {
            void var1_1;
            this.prepareForUpdate();
            this.mHasPivot = true;
            this.mPivotX = var1_1;
            this.invalidateAfterUpdate();
        }
    }

    public final float getPivotY() {
        return this.mPivotY;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPivotY(float pivotY) {
        if (!this.mHasPivot || this.mPivotY != pivotY) {
            void var1_1;
            this.prepareForUpdate();
            this.mHasPivot = true;
            this.mPivotY = var1_1;
            this.invalidateAfterUpdate();
        }
    }

    public final float getRotation() {
        return this.mRotationZ;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRotation(float rotation) {
        if (this.mRotationZ != rotation) {
            void var1_1;
            this.prepareForUpdate();
            this.mRotationZ = var1_1;
            this.invalidateAfterUpdate();
        }
    }

    public final float getRotationX() {
        return this.mRotationX;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRotationX(float rotationX) {
        if (this.mRotationX != rotationX) {
            void var1_1;
            this.prepareForUpdate();
            this.mRotationX = var1_1;
            this.invalidateAfterUpdate();
        }
    }

    public final float getRotationY() {
        return this.mRotationY;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRotationY(float rotationY) {
        if (this.mRotationY != rotationY) {
            void var1_1;
            this.prepareForUpdate();
            this.mRotationY = var1_1;
            this.invalidateAfterUpdate();
        }
    }

    public final float getScaleX() {
        return this.mScaleX;
    }

    /*
     * WARNING - void declaration
     */
    public final void setScaleX(float scaleX) {
        if (this.mScaleX != scaleX) {
            void var1_1;
            this.prepareForUpdate();
            this.mScaleX = var1_1;
            this.invalidateAfterUpdate();
        }
    }

    public final float getScaleY() {
        return this.mScaleY;
    }

    /*
     * WARNING - void declaration
     */
    public final void setScaleY(float scaleY) {
        if (this.mScaleY != scaleY) {
            void var1_1;
            this.prepareForUpdate();
            this.mScaleY = var1_1;
            this.invalidateAfterUpdate();
        }
    }

    public final int getScrollX() {
        View view = (View)this.mView.get();
        if (view == null) {
            return 0;
        }
        return view.getScrollX();
    }

    /*
     * WARNING - void declaration
     */
    public final void setScrollX(int value) {
        View view = (View)this.mView.get();
        if (view != null) {
            void var1_1;
            view.scrollTo((int)var1_1, view.getScrollY());
        }
    }

    public final int getScrollY() {
        View view = (View)this.mView.get();
        if (view == null) {
            return 0;
        }
        return view.getScrollY();
    }

    /*
     * WARNING - void declaration
     */
    public final void setScrollY(int value) {
        View view = (View)this.mView.get();
        if (view != null) {
            void var1_1;
            view.scrollTo(view.getScrollX(), (int)var1_1);
        }
    }

    public final float getTranslationX() {
        return this.mTranslationX;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTranslationX(float translationX) {
        if (this.mTranslationX != translationX) {
            void var1_1;
            this.prepareForUpdate();
            this.mTranslationX = var1_1;
            this.invalidateAfterUpdate();
        }
    }

    public final float getTranslationY() {
        return this.mTranslationY;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTranslationY(float translationY) {
        if (this.mTranslationY != translationY) {
            void var1_1;
            this.prepareForUpdate();
            this.mTranslationY = var1_1;
            this.invalidateAfterUpdate();
        }
    }

    public final float getX() {
        View view = (View)this.mView.get();
        if (view == null) {
            return 0.0f;
        }
        return (float)view.getLeft() + this.mTranslationX;
    }

    /*
     * WARNING - void declaration
     */
    public final void setX(float x2) {
        View view = (View)this.mView.get();
        if (view != null) {
            void var1_1;
            this.setTranslationX((float)(var1_1 - (float)view.getLeft()));
        }
    }

    public final float getY() {
        View view = (View)this.mView.get();
        if (view == null) {
            return 0.0f;
        }
        return (float)view.getTop() + this.mTranslationY;
    }

    /*
     * WARNING - void declaration
     */
    public final void setY(float y2) {
        View view = (View)this.mView.get();
        if (view != null) {
            void var1_1;
            this.setTranslationY((float)(var1_1 - (float)view.getTop()));
        }
    }

    private void prepareForUpdate() {
        View view = (View)this.mView.get();
        if (view != null) {
            this.computeRect(this.mBefore, view);
        }
    }

    private void invalidateAfterUpdate() {
        View view = (View)this.mView.get();
        if (view == null || view.getParent() == null) {
            return;
        }
        RectF rectF = this.mAfter;
        this.computeRect(rectF, view);
        rectF.union(this.mBefore);
        ((View)view.getParent()).invalidate((int)Math.floor(rectF.left), (int)Math.floor(rectF.top), (int)Math.ceil(rectF.right), (int)Math.ceil(rectF.bottom));
    }

    /*
     * WARNING - void declaration
     */
    private void computeRect(RectF r2, View view) {
        void var2_2;
        float f2 = view.getWidth();
        float f3 = view.getHeight();
        r2.set(0.0f, 0.0f, f2, f3);
        Matrix matrix = this.mTempMatrix;
        matrix.reset();
        this.transformMatrix(matrix, view);
        this.mTempMatrix.mapRect(r2);
        r2.offset((float)view.getLeft(), (float)var2_2.getTop());
        if (r2.right < r2.left) {
            float f4 = r2.right;
            r2.right = r2.left;
            r2.left = f4;
        }
        if (r2.bottom < r2.top) {
            float f5 = r2.top;
            r2.top = r2.bottom;
            var1_1.bottom = f5;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void transformMatrix(Matrix m2, View view) {
        void var1_1;
        void var2_2;
        float f2 = view.getWidth();
        float f3 = var2_2.getHeight();
        boolean bl = this.mHasPivot;
        float f4 = bl ? this.mPivotX : f2 / 2.0f;
        float f5 = bl ? this.mPivotY : f3 / 2.0f;
        float f6 = this.mRotationX;
        float f7 = this.mRotationY;
        float f8 = this.mRotationZ;
        if (f6 != 0.0f || f7 != 0.0f || f8 != 0.0f) {
            Camera camera = this.mCamera;
            camera.save();
            camera.rotateX(f6);
            camera.rotateY(f7);
            camera.rotateZ(-f8);
            camera.getMatrix(m2);
            camera.restore();
            m2.preTranslate(-f4, -f5);
            m2.postTranslate(f4, f5);
        }
        float f9 = this.mScaleX;
        f6 = this.mScaleY;
        if (f9 != 1.0f || f6 != 1.0f) {
            m2.postScale(f9, f6);
            f2 = -(f4 / f2) * (f9 * f2 - f2);
            f3 = -(f5 / f3) * (f6 * f3 - f3);
            m2.postTranslate(f2, f3);
        }
        var1_1.postTranslate(this.mTranslationX, this.mTranslationY);
    }

    /*
     * WARNING - void declaration
     */
    protected final void applyTransformation(float f2, Transformation t2) {
        View view = (View)this.mView.get();
        if (view != null) {
            void var2_3;
            t2.setAlpha(this.mAlpha);
            this.transformMatrix(var2_3.getMatrix(), view);
        }
    }
}

