/*
 * Decompiled with CFR 0.152.
 */
package com.melink.baseframe.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Process;
import android.telephony.TelephonyManager;
import android.view.inputmethod.InputMethodManager;
import com.melink.baseframe.utils.KJLoger;
import com.melink.baseframe.utils.PreferenceHelper;
import java.io.File;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;

@SuppressLint(value={"SimpleDateFormat"})
public final class SystemTool {
    public static String getDataTime(String format) {
        String string;
        return new SimpleDateFormat(string).format(new Date());
    }

    public static String getDataTime() {
        return SystemTool.getDataTime("HH:mm");
    }

    public static String getPhoneIMEI(Context cxt) {
        return ((TelephonyManager)cxt.getSystemService("phone")).getDeviceId();
    }

    public static int getSDKVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static String getSystemVersion() {
        return Build.VERSION.RELEASE;
    }

    /*
     * WARNING - void declaration
     */
    public static void sendSMS(Context cxt, String smsBody) {
        Context context;
        void var1_1;
        Uri uri = Uri.parse((String)"smsto:");
        uri = new Intent("android.intent.action.SENDTO", uri);
        uri.putExtra("sms_body", (String)var1_1);
        context.startActivity((Intent)uri);
    }

    public static boolean checkNet(Context context) {
        return ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo() != null;
    }

    public static boolean checkOnlyWifi(Context context) {
        if (PreferenceHelper.readBoolean(context, "kjframe_preference", "only_wifi")) {
            Context context2;
            return SystemTool.isWiFi(context2);
        }
        return true;
    }

    public static boolean isWiFi(Context cxt) {
        Context context = ((ConnectivityManager)cxt.getSystemService("connectivity")).getNetworkInfo(1).getState();
        return NetworkInfo.State.CONNECTED == context;
    }

    public static void hideKeyBoard(Activity aty) {
        Activity activity;
        ((InputMethodManager)aty.getSystemService("input_method")).hideSoftInputFromWindow(activity.getCurrentFocus().getWindowToken(), 2);
    }

    public static boolean isBackground(Context context) {
        ActivityManager.RunningAppProcessInfo runningAppProcessInfo2 = null;
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo2 : ((ActivityManager)context.getSystemService("activity")).getRunningAppProcesses()) {
            if (!runningAppProcessInfo2.processName.equals(context.getPackageName())) continue;
            return runningAppProcessInfo2.importance == 400;
        }
        return false;
    }

    public static boolean isSleeping(Context context) {
        return ((KeyguardManager)context.getSystemService("keyguard")).inKeyguardRestrictedInputMode();
    }

    /*
     * WARNING - void declaration
     */
    public static void installApk(Context context, File file) {
        Context context2;
        void var1_1;
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.setType("application/vnd.android.package-archive");
        intent.setData(Uri.fromFile((File)file));
        intent.setDataAndType(Uri.fromFile((File)var1_1), "application/vnd.android.package-archive");
        intent.setFlags(0x10000000);
        context2.startActivity(intent);
    }

    public static String getAppVersionName(Context context) {
        Object object;
        try {
            object = context.getPackageManager().getPackageInfo((String)object.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new RuntimeException(String.valueOf(SystemTool.class.getName()) + "the application not found");
        }
        return object;
    }

    public static int getAppVersionCode(Context context) {
        int n2;
        try {
            Context context2;
            n2 = context.getPackageManager().getPackageInfo((String)context2.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new RuntimeException(String.valueOf(SystemTool.class.getName()) + "the application not found");
        }
        return n2;
    }

    public static void goHome(Context context) {
        Context context2;
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        intent.addFlags(0x10200000);
        context2.startActivity(intent);
    }

    /*
     * WARNING - void declaration
     */
    public static String getSign(Context context, String pkgName) {
        try {
            return SystemTool.hexdigest(context.getPackageManager().getPackageInfo((String)pkgName, (int)64).signatures[0].toByteArray());
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            void var1_1;
            throw new RuntimeException(String.valueOf(SystemTool.class.getName()) + "the " + (String)var1_1 + "'s application not found");
        }
    }

    private static String hexdigest(byte[] paramArrayOfByte) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            byte[] byArray;
            Object object = MessageDigest.getInstance("MD5");
            ((MessageDigest)object).update(byArray);
            byArray = ((MessageDigest)object).digest();
            object = new char[32];
            int n2 = 0;
            int n3 = 0;
            while (true) {
                if (n2 >= 16) {
                    return new String((char[])object);
                }
                byte by = byArray[n2];
                object[n3] = cArray[0xF & by >>> 4];
                object[++n3] = cArray[by & 0xF];
                ++n2;
                ++n3;
            }
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static int getDeviceUsableMemory(Context cxt) {
        Context context = (ActivityManager)cxt.getSystemService("activity");
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        context.getMemoryInfo(memoryInfo);
        return (int)(memoryInfo.availMem / 0x100000L);
    }

    public static int gc(Context cxt) {
        Context context;
        Object object;
        long l2 = SystemTool.getDeviceUsableMemory(cxt);
        int n2 = 0;
        ActivityManager activityManager = (ActivityManager)cxt.getSystemService("activity");
        Object object2 = activityManager.getRunningServices(100);
        if (object2 != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                object2 = (ActivityManager.RunningServiceInfo)object.next();
                if (((ActivityManager.RunningServiceInfo)object2).pid == Process.myPid()) continue;
                try {
                    Process.killProcess((int)((ActivityManager.RunningServiceInfo)object2).pid);
                    ++n2;
                }
                catch (Exception exception) {
                    exception.getStackTrace();
                }
            }
        }
        if ((object2 = activityManager.getRunningAppProcesses()) != null) {
            object2 = object2.iterator();
            while (object2.hasNext()) {
                object = (ActivityManager.RunningAppProcessInfo)object2.next();
                if (object.importance <= 200) continue;
                String[] stringArray = object.pkgList;
                int n3 = object.pkgList.length;
                int n4 = 0;
                while (n4 < n3) {
                    object = stringArray[n4];
                    KJLoger.debug("======\u6b63\u5728\u6740\u6b7b\u5305\u540d\uff1a" + (String)object);
                    try {
                        activityManager.killBackgroundProcesses((String)object);
                        ++n2;
                    }
                    catch (Exception exception) {
                        exception.getStackTrace();
                    }
                    ++n4;
                }
            }
        }
        KJLoger.debug("\u6e05\u7406\u4e86" + ((long)SystemTool.getDeviceUsableMemory(context) - l2) + "M\u5185\u5b58");
        return n2;
    }
}

