/*
 * Decompiled with CFR 0.152.
 */
package com.melink.baseframe.db.utils;

import com.melink.baseframe.db.ManyToOneLazyLoader;
import com.melink.baseframe.db.annoate.Id;
import com.melink.baseframe.db.annoate.Table;
import com.melink.baseframe.db.utils.FieldUtils;
import com.melink.baseframe.db.utils.ManyToOne;
import com.melink.baseframe.db.utils.OneToMany;
import com.melink.baseframe.db.utils.Property;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ClassUtils {
    public static String getTableName(Class<?> clazz) {
        Table table = clazz.getAnnotation(Table.class);
        if (table == null || table.name().trim().length() == 0) {
            Class<?> clazz2;
            return clazz2.getName().replace('.', '_');
        }
        return table.name();
    }

    public static Object getPrimaryKeyValue(Object entity) {
        Object object;
        return FieldUtils.getFieldValue(entity, ClassUtils.getPrimaryKeyField(object.getClass()));
    }

    public static String getPrimaryKeyColumn(Class<?> clazz) {
        Object object;
        String string = null;
        Field[] fieldArray = clazz.getDeclaredFields();
        if (fieldArray != null) {
            Field field;
            object = null;
            Field field2 = null;
            Field[] fieldArray2 = fieldArray;
            int n2 = fieldArray.length;
            int n3 = 0;
            while (n3 < n2) {
                field = fieldArray2[n3];
                object = field.getAnnotation(Id.class);
                if (object != null) {
                    field2 = field;
                    break;
                }
                ++n3;
            }
            if (object != null) {
                string = object.column();
                if (string == null || string.trim().length() == 0) {
                    string = field2.getName();
                }
            } else {
                fieldArray2 = fieldArray;
                n2 = fieldArray.length;
                n3 = 0;
                while (n3 < n2) {
                    field = fieldArray2[n3];
                    if ("_id".equals(field.getName())) {
                        return "_id";
                    }
                    ++n3;
                }
                fieldArray2 = fieldArray;
                n2 = fieldArray.length;
                n3 = 0;
                while (n3 < n2) {
                    field = fieldArray2[n3];
                    if ("id".equals(field.getName())) {
                        return "id";
                    }
                    ++n3;
                }
            }
        } else {
            throw new RuntimeException("this model[" + object + "] has no field");
        }
        return string;
    }

    public static Field getPrimaryKeyField(Class<?> clazz) {
        AnnotatedElement annotatedElement;
        AnnotatedElement annotatedElement2 = null;
        Field[] fieldArray = clazz.getDeclaredFields();
        if (fieldArray != null) {
            Field[] fieldArray2 = fieldArray;
            int n2 = fieldArray.length;
            int n3 = 0;
            while (n3 < n2) {
                annotatedElement = fieldArray2[n3];
                if (((Field)annotatedElement).getAnnotation(Id.class) != null) {
                    annotatedElement2 = annotatedElement;
                    break;
                }
                ++n3;
            }
            if (annotatedElement2 == null) {
                fieldArray2 = fieldArray;
                n2 = fieldArray.length;
                n3 = 0;
                while (n3 < n2) {
                    annotatedElement = fieldArray2[n3];
                    if ("_id".equals(((Field)annotatedElement).getName())) {
                        annotatedElement2 = annotatedElement;
                        break;
                    }
                    ++n3;
                }
            }
            if (annotatedElement2 == null) {
                fieldArray2 = fieldArray;
                n2 = fieldArray.length;
                n3 = 0;
                while (n3 < n2) {
                    annotatedElement = fieldArray2[n3];
                    if ("id".equals(((Field)annotatedElement).getName())) {
                        annotatedElement2 = annotatedElement;
                        break;
                    }
                    ++n3;
                }
            }
        } else {
            throw new RuntimeException("this model[" + annotatedElement + "] has no field");
        }
        return annotatedElement2;
    }

    public static String getPrimaryKeyFieldName(Class<?> clazz) {
        AnnotatedElement annotatedElement = ClassUtils.getPrimaryKeyField(clazz);
        if (annotatedElement == null) {
            return null;
        }
        return ((Field)annotatedElement).getName();
    }

    public static List<Property> getPropertyList(Class<?> clazz) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        try {
            Object object = clazz.getDeclaredFields();
            String string = ClassUtils.getPrimaryKeyFieldName(clazz);
            Field[] fieldArray = object;
            int n2 = ((Field[])object).length;
            int n3 = 0;
            while (n3 < n2) {
                object = fieldArray[n3];
                if (!FieldUtils.isTransient((Field)object) && FieldUtils.isBaseDateType((Field)object) && !((Field)object).getName().equals(string)) {
                    Property property = new Property();
                    property.setColumn(FieldUtils.getColumnByField((Field)object));
                    property.setFieldName(((Field)object).getName());
                    property.setDataType(((Field)object).getType());
                    property.setDefaultValue(FieldUtils.getPropertyDefaultValue((Field)object));
                    property.setSet(FieldUtils.getFieldSetMethod(clazz, (Field)object));
                    property.setGet(FieldUtils.getFieldGetMethod(clazz, (Field)object));
                    property.setField((Field)object);
                    arrayList.add(property);
                }
                ++n3;
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    public static List<ManyToOne> getManyToOneList(Class<?> clazz) {
        ArrayList<ManyToOne> arrayList = new ArrayList<ManyToOne>();
        try {
            Field field = null;
            Field[] fieldArray = clazz.getDeclaredFields();
            int n2 = fieldArray.length;
            int n3 = 0;
            while (n3 < n2) {
                field = fieldArray[n3];
                if (!FieldUtils.isTransient(field) && FieldUtils.isManyToOne(field)) {
                    ManyToOne manyToOne = new ManyToOne();
                    if (field.getType() == ManyToOneLazyLoader.class) {
                        Class clazz2 = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1];
                        if (clazz2 != null) {
                            manyToOne.setManyClass(clazz2);
                        }
                    } else {
                        manyToOne.setManyClass(field.getType());
                    }
                    manyToOne.setColumn(FieldUtils.getColumnByField(field));
                    manyToOne.setFieldName(field.getName());
                    manyToOne.setDataType(field.getType());
                    manyToOne.setSet(FieldUtils.getFieldSetMethod(clazz, field));
                    manyToOne.setGet(FieldUtils.getFieldGetMethod(clazz, field));
                    arrayList.add(manyToOne);
                }
                ++n3;
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    public static List<OneToMany> getOneToManyList(Class<?> clazz) {
        ArrayList<OneToMany> arrayList = new ArrayList<OneToMany>();
        try {
            Field field = null;
            Field[] fieldArray = clazz.getDeclaredFields();
            int n2 = fieldArray.length;
            int n3 = 0;
            while (n3 < n2) {
                field = fieldArray[n3];
                if (!FieldUtils.isTransient(field) && FieldUtils.isOneToMany(field)) {
                    OneToMany oneToMany = new OneToMany();
                    oneToMany.setColumn(FieldUtils.getColumnByField(field));
                    oneToMany.setFieldName(field.getName());
                    if (field.getGenericType() instanceof ParameterizedType) {
                        Type type = (ParameterizedType)field.getGenericType();
                        if (type.getActualTypeArguments().length == 1) {
                            if ((type = (Class)type.getActualTypeArguments()[0]) != null) {
                                oneToMany.setOneClass((Class<?>)type);
                            }
                        } else if ((type = (Class)type.getActualTypeArguments()[1]) != null) {
                            oneToMany.setOneClass((Class<?>)type);
                        }
                    } else {
                        throw new RuntimeException("getOneToManyList Exception:" + field.getName() + "'s type is null");
                    }
                    oneToMany.setDataType(field.getType());
                    oneToMany.setSet(FieldUtils.getFieldSetMethod(clazz, field));
                    oneToMany.setGet(FieldUtils.getFieldGetMethod(clazz, field));
                    arrayList.add(oneToMany);
                }
                ++n3;
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }
}

