/*
 * Decompiled with CFR 0.152.
 */
package com.melink.baseframe.bitmap;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import com.melink.baseframe.utils.FileUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class BitmapCreate {
    /*
     * WARNING - void declaration
     */
    public static Bitmap bitmapFromResource(Resources res, int resId, int reqWidth, int reqHeight) {
        void var3_3;
        void var2_2;
        void var1_1;
        return BitmapCreate.bitmapFromStream(res.openRawResource((int)var1_1), null, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap bitmapFromFile(String pathName, int reqWidth, int reqHeight) {
        String string;
        void var2_2;
        void var1_1;
        if (reqHeight == 0 || reqWidth == 0) {
            try {
                return BitmapFactory.decodeFile((String)pathName);
            }
            catch (OutOfMemoryError outOfMemoryError) {}
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        new BitmapFactory.Options().inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
        options = BitmapCreate.calculateInSampleSize(options, (int)var1_1, (int)var2_2);
        return BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
    }

    /*
     * Loose catch block
     */
    public static Bitmap getLoacalBitmap(String url) {
        String string;
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(string);
        string = BitmapFactory.decodeStream((InputStream)fileInputStream);
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        return string;
        catch (FileNotFoundException fileNotFoundException) {
            block11: {
                try {
                    string = null;
                    fileNotFoundException.printStackTrace();
                    if (fileInputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap bitmapFromByteArray(byte[] data, int offset, int length, int reqWidth, int reqHeight) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        void var3_3;
        if (reqHeight == 0 || reqWidth == 0) {
            try {
                return BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length);
            }
            catch (OutOfMemoryError outOfMemoryError) {}
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        new BitmapFactory.Options().inJustDecodeBounds = true;
        options.inPurgeable = true;
        BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)options);
        options = BitmapCreate.calculateInSampleSize(options, (int)var3_3, reqHeight);
        return BitmapFactory.decodeByteArray((byte[])byArray, (int)var1_1, (int)var2_2, (BitmapFactory.Options)options);
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap bitmapFromStream(InputStream is, int reqWidth, int reqHeight) {
        void var2_2;
        void var1_1;
        Object object;
        if (reqHeight == 0 || reqWidth == 0) {
            try {
                return BitmapFactory.decodeStream((InputStream)is);
            }
            catch (OutOfMemoryError outOfMemoryError) {}
        }
        byte[] byArray = FileUtils.input2byte((InputStream)object);
        object = byArray;
        return BitmapCreate.bitmapFromByteArray(byArray, 0, ((Object)object).length, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap bitmapFromStream(InputStream is, Rect outPadding, int reqWidth, int reqHeight) {
        void var1_1;
        InputStream inputStream;
        void var3_3;
        void var2_2;
        if (reqHeight == 0 || reqWidth == 0) {
            try {
                return BitmapFactory.decodeStream((InputStream)is);
            }
            catch (OutOfMemoryError outOfMemoryError) {}
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        new BitmapFactory.Options().inJustDecodeBounds = true;
        options.inPurgeable = true;
        BitmapFactory.decodeStream((InputStream)is, (Rect)outPadding, (BitmapFactory.Options)options);
        options = BitmapCreate.calculateInSampleSize(options, (int)var2_2, (int)var3_3);
        return BitmapFactory.decodeStream((InputStream)inputStream, (Rect)var1_1, (BitmapFactory.Options)options);
    }

    public static BitmapFactory.Options calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        BitmapFactory.Options options2;
        int n2 = options.outHeight;
        int n3 = options.outWidth;
        int n4 = 1;
        if (n2 > reqHeight || n3 > reqWidth) {
            int n5;
            int n6;
            n4 = (n6 = Math.round((float)n2 / (float)n6)) < (n5 = Math.round((float)n3 / (float)n5)) ? n6 : n5;
        }
        options.inSampleSize = n4;
        options.inJustDecodeBounds = false;
        return options2;
    }
}

