/*
 * Decompiled with CFR 0.152.
 */
package com.melink.baseframe;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.melink.baseframe.KJDB$DbUpdateListener;
import com.melink.baseframe.KJDB$SqliteDbHelper;
import com.melink.baseframe.db.CursorHelper;
import com.melink.baseframe.db.DaoConfig;
import com.melink.baseframe.db.DbModel;
import com.melink.baseframe.db.OneToManyLazyLoader;
import com.melink.baseframe.db.SqlBuilder;
import com.melink.baseframe.db.SqlInfo;
import com.melink.baseframe.db.utils.KeyValue;
import com.melink.baseframe.db.utils.ManyToOne;
import com.melink.baseframe.db.utils.OneToMany;
import com.melink.baseframe.db.utils.Property;
import com.melink.baseframe.db.utils.TableInfo;
import com.melink.baseframe.ui.KJActivityStack;
import com.melink.baseframe.utils.KJLoger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class KJDB {
    private static HashMap<String, KJDB> daoMap = new HashMap();
    private SQLiteDatabase db;
    private final DaoConfig config;

    /*
     * WARNING - void declaration
     */
    private KJDB(DaoConfig config) {
        void var1_1;
        if (config == null) {
            throw new RuntimeException("daoConfig is null");
        }
        if (config.getContext() == null) {
            throw new RuntimeException("android context is null");
        }
        this.db = config.getTargetDirectory() != null && config.getTargetDirectory().trim().length() > 0 ? this.createDbFileOnSDCard(config.getTargetDirectory(), config.getDbName()) : new KJDB$SqliteDbHelper(this, config.getContext().getApplicationContext(), config.getDbName(), config.getDbVersion(), config.getDbUpdateListener()).getWritableDatabase();
        this.config = var1_1;
    }

    private static synchronized KJDB getInstance(DaoConfig daoConfig) {
        KJDB kJDB = daoMap.get(daoConfig.getDbName());
        if (kJDB == null) {
            DaoConfig daoConfig2;
            kJDB = new KJDB(daoConfig);
            daoMap.put(daoConfig2.getDbName(), kJDB);
        }
        return kJDB;
    }

    public static KJDB create() {
        return KJDB.create(false);
    }

    public static KJDB create(boolean isDebug) {
        boolean bl;
        Activity activity = KJActivityStack.create().topActivity();
        if (activity == null) {
            throw new NullPointerException("you have to extends KJActivity");
        }
        return KJDB.create((Context)activity, bl);
    }

    public static KJDB create(Context context) {
        Context context2;
        DaoConfig daoConfig = new DaoConfig();
        daoConfig.setContext(context2);
        return KJDB.create(daoConfig);
    }

    /*
     * WARNING - void declaration
     */
    public static KJDB create(Context context, boolean isDebug) {
        void var1_1;
        Context context2;
        DaoConfig daoConfig = new DaoConfig();
        daoConfig.setContext(context2);
        daoConfig.setDebug((boolean)var1_1);
        return KJDB.create(daoConfig);
    }

    /*
     * WARNING - void declaration
     */
    public static KJDB create(Context context, String dbName) {
        void var1_1;
        Context context2;
        DaoConfig daoConfig = new DaoConfig();
        daoConfig.setContext(context2);
        daoConfig.setDbName((String)var1_1);
        return KJDB.create(daoConfig);
    }

    /*
     * WARNING - void declaration
     */
    public static KJDB create(Context context, String dbName, boolean isDebug) {
        void var2_2;
        void var1_1;
        Context context2;
        DaoConfig daoConfig = new DaoConfig();
        daoConfig.setContext(context2);
        daoConfig.setDbName((String)var1_1);
        daoConfig.setDebug((boolean)var2_2);
        return KJDB.create(daoConfig);
    }

    /*
     * WARNING - void declaration
     */
    public static KJDB create(Context context, int dbVersion, KJDB$DbUpdateListener dbUpdateListener) {
        void var2_2;
        void var1_1;
        Context context2;
        DaoConfig daoConfig = new DaoConfig();
        daoConfig.setContext(context2);
        daoConfig.setDbVersion((int)var1_1);
        daoConfig.setDbUpdateListener((KJDB$DbUpdateListener)var2_2);
        return KJDB.create(daoConfig);
    }

    /*
     * WARNING - void declaration
     */
    public static KJDB create(Context context, String targetDirectory, String dbName) {
        void var1_1;
        void var2_2;
        Context context2;
        DaoConfig daoConfig = new DaoConfig();
        daoConfig.setContext(context2);
        daoConfig.setDbName((String)var2_2);
        daoConfig.setTargetDirectory((String)var1_1);
        return KJDB.create(daoConfig);
    }

    /*
     * WARNING - void declaration
     */
    public static KJDB create(Context context, String targetDirectory, String dbName, boolean isDebug) {
        void var3_3;
        void var2_2;
        void var1_1;
        Context context2;
        DaoConfig daoConfig = new DaoConfig();
        daoConfig.setContext(context2);
        daoConfig.setTargetDirectory((String)var1_1);
        daoConfig.setDbName((String)var2_2);
        daoConfig.setDebug((boolean)var3_3);
        return KJDB.create(daoConfig);
    }

    /*
     * WARNING - void declaration
     */
    public static KJDB create(Context context, String dbName, boolean isDebug, int dbVersion, KJDB$DbUpdateListener dbUpdateListener) {
        void var3_3;
        void var2_2;
        void var1_1;
        Context context2;
        DaoConfig daoConfig = new DaoConfig();
        daoConfig.setContext(context2);
        daoConfig.setDbName((String)var1_1);
        daoConfig.setDebug((boolean)var2_2);
        daoConfig.setDbVersion((int)var3_3);
        daoConfig.setDbUpdateListener(dbUpdateListener);
        return KJDB.create(daoConfig);
    }

    /*
     * WARNING - void declaration
     */
    public static KJDB create(Context context, String targetDirectory, String dbName, boolean isDebug, int dbVersion, KJDB$DbUpdateListener dbUpdateListener) {
        void var3_3;
        void var2_2;
        void var1_1;
        Context context2;
        DaoConfig daoConfig = new DaoConfig();
        daoConfig.setContext(context2);
        daoConfig.setTargetDirectory((String)var1_1);
        daoConfig.setDbName((String)var2_2);
        daoConfig.setDebug((boolean)var3_3);
        daoConfig.setDbVersion(dbVersion);
        daoConfig.setDbUpdateListener(dbUpdateListener);
        return KJDB.create(daoConfig);
    }

    public static KJDB create(DaoConfig daoConfig) {
        return KJDB.getInstance(daoConfig);
    }

    /*
     * WARNING - void declaration
     */
    public void save(Object entity) {
        void var1_1;
        this.checkTableExist(entity.getClass());
        this.exeSqlInfo(SqlBuilder.buildInsertSql(var1_1));
    }

    public void save(List<? extends Object> entities) {
        if (entities != null) {
            for (Object e2 : e2) {
                this.save(e2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean saveBindId(Object entity) {
        this.checkTableExist(entity.getClass());
        Object object = SqlBuilder.getSaveKeyValueListByEntity(entity);
        if (object != null && object.size() > 0) {
            void var1_1;
            TableInfo tableInfo = TableInfo.get(entity.getClass());
            ContentValues contentValues = new ContentValues();
            this.insertContentValues((List<KeyValue>)object, contentValues);
            object = this.db.insert(tableInfo.getTableName(), null, contentValues);
            if ((Long)object == -1L) {
                return false;
            }
            tableInfo.getId().setValue(var1_1, object);
            return true;
        }
        return false;
    }

    private void insertContentValues(List<KeyValue> list, ContentValues cv) {
        if (list != null && cv != null) {
            KeyValue keyValue;
            Iterator iterator = keyValue.iterator();
            while (iterator.hasNext()) {
                keyValue = (KeyValue)iterator.next();
                cv.put(keyValue.getKey(), keyValue.getValue().toString());
            }
            return;
        }
        KJLoger.debug(String.valueOf(this.getClass().getName()) + "insertContentValues: List<KeyValue> is empty or ContentValues is empty!");
    }

    /*
     * WARNING - void declaration
     */
    public void update(Object entity) {
        void var1_1;
        this.checkTableExist(entity.getClass());
        this.exeSqlInfo(SqlBuilder.getUpdateSqlAsSqlInfo(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void update(Object entity, String strWhere) {
        void var2_2;
        void var1_1;
        this.checkTableExist(entity.getClass());
        this.exeSqlInfo(SqlBuilder.getUpdateSqlAsSqlInfo(var1_1, (String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void delete(Object entity) {
        void var1_1;
        this.checkTableExist(entity.getClass());
        this.exeSqlInfo(SqlBuilder.buildDeleteSql(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void deleteById(Class<?> clazz, Object id) {
        void var2_2;
        void var1_1;
        this.checkTableExist(clazz);
        this.exeSqlInfo(SqlBuilder.buildDeleteSql(var1_1, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void deleteByWhere(Class<?> clazz, String strWhere) {
        void var2_2;
        String string;
        this.checkTableExist(clazz);
        string = SqlBuilder.buildDeleteSql(string, (String)var2_2);
        this.debugSql(string);
        this.db.execSQL(string);
    }

    public void dropDb() {
        Cursor cursor = this.db.rawQuery("SELECT name FROM sqlite_master WHERE type ='table'", null);
        if (cursor != null) {
            while (cursor.moveToNext()) {
                try {
                    this.db.execSQL("DROP TABLE " + cursor.getString(0));
                }
                catch (SQLException sQLException) {
                    KJLoger.debug(String.valueOf(this.getClass().getName()) + sQLException.getMessage());
                }
            }
        }
        if (cursor != null) {
            cursor.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void exeSqlInfo(SqlInfo sqlInfo) {
        if (sqlInfo != null) {
            void var1_1;
            this.debugSql(sqlInfo.getSql());
            this.db.execSQL(sqlInfo.getSql(), var1_1.getBindArgsAsArray());
            return;
        }
        KJLoger.debug(String.valueOf(this.getClass().getName()) + "sava error:sqlInfo is null");
    }

    public <T> T findById(Object id, Class<T> clazz) {
        SqlInfo sqlInfo;
        this.checkTableExist(clazz);
        sqlInfo = SqlBuilder.getSelectSqlAsSqlInfo(clazz, sqlInfo);
        if (sqlInfo != null) {
            Class clazz2;
            this.debugSql(sqlInfo.getSql());
            sqlInfo = this.db.rawQuery(sqlInfo.getSql(), sqlInfo.getBindArgsAsStringArray());
            try {
                if (sqlInfo.moveToNext()) {
                    clazz2 = (Class)CursorHelper.getEntity((Cursor)sqlInfo, clazz2, this);
                    return (T)clazz2;
                }
            }
            catch (Exception exception) {
                clazz2 = null;
                exception.printStackTrace();
            }
            finally {
                sqlInfo.close();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T findWithManyToOneById(Object id, Class<T> clazz) {
        Object object;
        this.checkTableExist(clazz);
        object = SqlBuilder.getSelectSQL(clazz, object);
        this.debugSql((String)object);
        object = this.findDbModelBySQL((String)object);
        if (object != null) {
            void var2_2;
            object = CursorHelper.dbModel2Entity((DbModel)object, clazz);
            return (T)this.loadManyToOne((T)object, (Class<T>)var2_2, new Class[0]);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T findWithManyToOneById(Object id, Class<T> clazz, Class<?> ... findClass) {
        Object object;
        this.checkTableExist(clazz);
        object = SqlBuilder.getSelectSQL(clazz, object);
        this.debugSql((String)object);
        object = this.findDbModelBySQL((String)object);
        if (object != null) {
            void var3_3;
            void var2_2;
            object = CursorHelper.dbModel2Entity((DbModel)object, clazz);
            return (T)this.loadManyToOne((T)object, (Class<T>)var2_2, (Class<?>)var3_3);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T loadManyToOne(T entity, Class<T> clazz, Class<?> ... findClass) {
        void var1_1;
        if (entity != null) {
            try {
                ManyToOne manyToOne2 = null;
                for (ManyToOne manyToOne2 : TableInfo.get(manyToOne2).manyToOneMap.values()) {
                    Class<?> clazz2;
                    Object t2 = manyToOne2.getValue(entity);
                    if (t2 == null) continue;
                    boolean bl = false;
                    if (findClass == null || findClass.length == 0) {
                        bl = true;
                    }
                    Class<?>[] classArray = findClass;
                    int n2 = findClass.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        clazz2 = classArray[n3];
                        if (manyToOne2.getManyClass() == clazz2) {
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                    if (!bl || (clazz2 = this.findById(Integer.valueOf(t2.toString()), manyToOne2.getDataType())) == null) continue;
                    manyToOne2.setValue(entity, clazz2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T findWithOneToManyById(Object id, Class<T> clazz) {
        Object object;
        this.checkTableExist(clazz);
        object = SqlBuilder.getSelectSQL(clazz, object);
        this.debugSql((String)object);
        object = this.findDbModelBySQL((String)object);
        if (object != null) {
            void var2_2;
            object = CursorHelper.dbModel2Entity((DbModel)object, clazz);
            return (T)this.loadOneToMany((T)object, (Class<T>)var2_2, new Class[0]);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T findWithOneToManyById(Object id, Class<T> clazz, Class<?> ... findClass) {
        Object object;
        this.checkTableExist(clazz);
        object = SqlBuilder.getSelectSQL(clazz, object);
        this.debugSql((String)object);
        object = this.findDbModelBySQL((String)object);
        if (object != null) {
            void var3_3;
            void var2_2;
            object = CursorHelper.dbModel2Entity((DbModel)object, clazz);
            return (T)this.loadOneToMany((T)object, (Class<T>)var2_2, (Class<?>)var3_3);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T loadOneToMany(T entity, Class<T> clazz, Class<?> ... findClass) {
        void var1_1;
        if (entity != null) {
            try {
                Object t2;
                Object object = TableInfo.get(clazz).oneToManyMap.values();
                t2 = TableInfo.get(t2).getId().getValue(entity);
                Iterator<OneToMany> iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object object2;
                    object = iterator.next();
                    boolean bl = false;
                    if (findClass == null || findClass.length == 0) {
                        bl = true;
                    }
                    Class<?>[] classArray = findClass;
                    int n2 = findClass.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        object2 = classArray[n3];
                        if (((OneToMany)object).getOneClass() == object2) {
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                    if (!bl || (object2 = this.findAllByWhere(((OneToMany)object).getOneClass(), String.valueOf(((Property)object).getColumn()) + "=" + t2)) == null) continue;
                    if (((Property)object).getDataType() == OneToManyLazyLoader.class) {
                        ((OneToManyLazyLoader)((Property)object).getValue(entity)).setList(object2);
                        continue;
                    }
                    ((Property)object).setValue(entity, object2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public <T> List<T> findAll(Class<T> clazz) {
        void var1_1;
        this.checkTableExist(clazz);
        return this.findAllBySql(clazz, SqlBuilder.getSelectSQL(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public <T> List<T> findAll(Class<T> clazz, String orderBy) {
        void var2_2;
        void var1_1;
        this.checkTableExist(clazz);
        return this.findAllBySql(clazz, String.valueOf(SqlBuilder.getSelectSQL(var1_1)) + " ORDER BY " + (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public <T> List<T> findAllByWhere(Class<T> clazz, String strWhere) {
        void var2_2;
        void var1_1;
        this.checkTableExist(clazz);
        return this.findAllBySql(clazz, SqlBuilder.getSelectSQLByWhere(var1_1, (String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public <T> List<T> findAllByWhere(Class<T> clazz, String strWhere, String orderBy) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkTableExist(clazz);
        return this.findAllBySql(clazz, String.valueOf(SqlBuilder.getSelectSQLByWhere(var1_1, (String)var2_2)) + " ORDER BY " + (String)var3_3);
    }

    private <T> List<T> findAllBySql(Class<T> clazz, String strSQL) {
        Cursor cursor;
        this.checkTableExist(clazz);
        this.debugSql(strSQL);
        cursor = this.db.rawQuery((String)cursor, null);
        try {
            ArrayList<T> arrayList = new ArrayList<T>();
            while (cursor.moveToNext()) {
                T t2 = CursorHelper.getEntity(cursor, clazz, this);
                arrayList.add(t2);
            }
            ArrayList<T> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public DbModel findDbModelBySQL(String strSQL) {
        Cursor cursor;
        this.debugSql(strSQL);
        cursor = this.db.rawQuery((String)cursor, null);
        try {
            if (cursor.moveToNext()) {
                DbModel dbModel = CursorHelper.getDbModel(cursor);
                return dbModel;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            cursor.close();
        }
        return null;
    }

    public List<DbModel> findDbModelListBySQL(String strSQL) {
        Cursor cursor;
        this.debugSql(strSQL);
        cursor = this.db.rawQuery((String)cursor, null);
        ArrayList<DbModel> arrayList = new ArrayList<DbModel>();
        try {
            try {
                while (cursor.moveToNext()) {
                    arrayList.add(CursorHelper.getDbModel(cursor));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                cursor.close();
            }
        }
        finally {
            cursor.close();
        }
        return arrayList;
    }

    private void checkTableExist(Class<?> clazz) {
        if (!this.tableIsExist(TableInfo.get(clazz))) {
            String string;
            string = SqlBuilder.getCreatTableSQL(string);
            this.debugSql(string);
            this.db.execSQL(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean tableIsExist(TableInfo table) {
        if (table.isCheckDatabese()) {
            return true;
        }
        try (Cursor cursor = null;){
            String string = "SELECT COUNT(*) AS c FROM sqlite_master WHERE type ='table' AND name ='" + table.getTableName() + "' ";
            this.debugSql(string);
            cursor = this.db.rawQuery(string, null);
            if (cursor != null && cursor.moveToNext() && cursor.getInt(0) > 0) {
                void var1_1;
                var1_1.setCheckDatabese(true);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void debugSql(String sql) {
        if (this.config != null && this.config.isDebug()) {
            void var1_1;
            Log.d((String)"Debug SQL", (String)(">>>>>>  " + (String)var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private SQLiteDatabase createDbFileOnSDCard(String sdcardPath, String dbfilename) {
        block4: {
            void var2_3;
            File file;
            if (!(file = new File((String)((Object)file), (String)var2_3)).exists()) {
                try {
                    if (file.createNewFile()) {
                        return SQLiteDatabase.openOrCreateDatabase((File)file, null);
                    }
                    break block4;
                }
                catch (IOException iOException) {
                    throw new RuntimeException("\u6570\u636e\u5e93\u6587\u4ef6\u521b\u5efa\u5931\u8d25", iOException);
                }
            }
            return SQLiteDatabase.openOrCreateDatabase((File)file, null);
        }
        return null;
    }
}

