/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import java.lang.reflect.Field;
import java.util.LinkedList;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.internal.DefaultStackPresentationSite;
import org.eclipse.ui.internal.presentations.ISelfUpdatingAction;
import org.eclipse.ui.internal.presentations.util.AbstractTabFolder;
import org.eclipse.ui.internal.presentations.util.AbstractTabItem;
import org.eclipse.ui.internal.presentations.util.TabOrder;
import org.eclipse.ui.internal.presentations.util.TabbedStackPresentation;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;

public class SystemMenuCloseLeft
extends Action
implements ISelfUpdatingAction {
    private IStackPresentationSite stackPresentation;
    private IPresentablePart current;

    public SystemMenuCloseLeft(IStackPresentationSite stackPresentation) {
        this.stackPresentation = stackPresentation;
        this.setText("\u5173\u95ed\u5de6\u4fa7(&L)");
    }

    public void dispose() {
        this.stackPresentation = null;
    }

    public void run() {
        LinkedList<Object> others = new LinkedList<Object>();
        TabbedStackPresentation tabbedStackPresentation = (TabbedStackPresentation)((DefaultStackPresentationSite)this.stackPresentation).getPresentation();
        AbstractTabFolder tabFolder = tabbedStackPresentation.getTabFolder();
        AbstractTabItem[] items = tabFolder.getItems();
        boolean hasNotShow = false;
        int i = 0;
        while (i < items.length) {
            AbstractTabItem item = items[i];
            if (item.getData().equals(this.current)) break;
            try {
                if (item != null && item.isShowing()) {
                    others.add(item.getData());
                } else {
                    hasNotShow = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.stackPresentation.close(others.toArray(new IPresentablePart[others.size()]));
        if (hasNotShow) {
            try {
                Field field = tabbedStackPresentation.getClass().getDeclaredField("tabs");
                field.setAccessible(true);
                TabOrder tabs = (TabOrder)field.get(tabbedStackPresentation);
                if (tabs != null) {
                    tabs.move(this.current, 0);
                    tabbedStackPresentation.selectPart(this.current);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void update() {
    }

    public boolean shouldBeVisible() {
        return this.isEnabled();
    }

    public void setTarget(IPresentablePart current) {
        this.current = current;
        try {
            TabbedStackPresentation tabbedStackPresentation = (TabbedStackPresentation)((DefaultStackPresentationSite)this.stackPresentation).getPresentation();
            AbstractTabFolder tabFolder = tabbedStackPresentation.getTabFolder();
            AbstractTabItem[] items = tabFolder.getItems();
            if (items == null || items.length < 2) {
                this.setEnabled(false);
            } else if (items[0].getData().equals(current)) {
                this.setEnabled(false);
            } else {
                boolean leftHasShow = false;
                boolean rightHasShow = false;
                boolean hasNotShow = false;
                int currentIndex = items.length - 1;
                int i = 0;
                while (i < items.length) {
                    AbstractTabItem item = items[i];
                    if (item.getData().equals(current)) {
                        currentIndex = i;
                    } else if (!item.isShowing()) {
                        hasNotShow = true;
                    } else if (item.isShowing()) {
                        if (i > currentIndex) {
                            rightHasShow = true;
                        } else if (i < currentIndex) {
                            leftHasShow = true;
                        }
                    }
                    ++i;
                }
                this.setEnabled(leftHasShow && (rightHasShow || hasNotShow));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setEnabled(false);
        }
    }
}

