/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.core.build;

import com.aptana.core.build.Problem;
import com.aptana.core.build.RequiredBuildParticipant;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ast.IParseError;
import com.aptana.ruby.core.RubyParseState;
import com.aptana.ruby.launching.RubyLaunchingPlugin;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jrubyparser.CompatVersion;

public class RubyValidator
extends RequiredBuildParticipant {
    private CompatVersion version;

    public void buildStarting(IProject project, int kind, IProgressMonitor monitor) {
        super.buildStarting(project, kind, monitor);
        String rubyVersion = RubyLaunchingPlugin.getRubyVersionForProject((IProject)project);
        this.version = rubyVersion != null && rubyVersion.startsWith("ruby 1.9") ? CompatVersion.RUBY1_9 : (rubyVersion != null && rubyVersion.startsWith("ruby 1.8") ? CompatVersion.RUBY1_8 : CompatVersion.BOTH);
    }

    public void buildEnding(IProgressMonitor monitor) {
        this.version = CompatVersion.BOTH;
        super.buildEnding(monitor);
    }

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        if (!context.isFullBuild() && !context.isSave()) {
            return;
        }
        String contents = null;
        String uri = context.getName();
        try {
            contents = context.getContents();
            RubyParseState parseState = new RubyParseState(contents, uri, 1, this.version);
            uri = context.getURI().toString();
            context.getAST((IParseState)parseState);
        }
        catch (CoreException coreException) {}
        ArrayList<Problem> problems = new ArrayList<Problem>();
        for (IParseError parseError : context.getParseErrors()) {
            int severity = parseError.getSeverity().getCode();
            int line = -1;
            if (contents != null) {
                line = this.getLineNumber(parseError.getOffset(), contents);
            }
            problems.add(new Problem(severity, parseError.getMessage(), parseError.getOffset(), parseError.getLength(), line, uri));
        }
        context.putProblems("org.eclipse.core.resources.problemmarker", problems);
    }

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        context.removeProblems("org.eclipse.core.resources.problemmarker");
    }
}

