/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.core;

import com.aptana.ruby.core.IRubyMethod;
import com.aptana.ruby.internal.core.NamedMember;
import java.util.HashSet;
import java.util.Set;

public class RubyMethod
extends NamedMember
implements IRubyMethod {
    private String[] fParameters;
    private IRubyMethod.Visibility fVisibility;
    private boolean isSingleton;
    private Set<String> blockVars;

    public RubyMethod(String name, String[] parameters, int start, int nameStart, int nameEnd) {
        super(name, start, nameStart, nameEnd);
        this.fParameters = parameters;
        this.blockVars = new HashSet<String>();
    }

    public void addBlockVar(String name) {
        this.blockVars.add(name);
    }

    @Override
    public String[] getBlockVars() {
        return this.blockVars.toArray(new String[this.blockVars.size()]);
    }

    @Override
    public String[] getParameters() {
        return this.fParameters;
    }

    @Override
    public IRubyMethod.Visibility getVisibility() {
        return this.fVisibility;
    }

    @Override
    public short getNodeType() {
        return 3;
    }

    @Override
    public boolean isSingleton() {
        return this.isSingleton;
    }

    public void setVisibility(IRubyMethod.Visibility visibility) {
        this.fVisibility = visibility;
    }

    public void setIsSingleton(boolean singleton) {
        this.isSingleton = singleton;
    }

    @Override
    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(this.getName());
        text.append('(');
        String[] params = this.getParameters();
        int i = 0;
        while (i < params.length) {
            text.append(params[i]);
            if (i < params.length - 1) {
                text.append(", ");
            }
            ++i;
        }
        text.append(')');
        return text.toString();
    }

    @Override
    public boolean isConstructor() {
        return !this.isSingleton() && this.getName().equals("initialize");
    }
}

