/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.core.ast;

import com.aptana.core.util.ArrayUtil;
import com.aptana.ruby.core.IRubyMethod;
import com.aptana.ruby.core.ISourceElementRequestor;
import com.aptana.ruby.core.ast.ASTUtils;
import com.aptana.ruby.core.ast.InOrderVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jrubyparser.ast.AliasNode;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.ArrayNode;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.ClassVarAsgnNode;
import org.jrubyparser.ast.ClassVarDeclNode;
import org.jrubyparser.ast.ClassVarNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.ConstDeclNode;
import org.jrubyparser.ast.ConstNode;
import org.jrubyparser.ast.DAsgnNode;
import org.jrubyparser.ast.DStrNode;
import org.jrubyparser.ast.DefnNode;
import org.jrubyparser.ast.DefsNode;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.GlobalAsgnNode;
import org.jrubyparser.ast.GlobalVarNode;
import org.jrubyparser.ast.HashNode;
import org.jrubyparser.ast.IArgumentNode;
import org.jrubyparser.ast.InstAsgnNode;
import org.jrubyparser.ast.InstVarNode;
import org.jrubyparser.ast.IterNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.LocalVarNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.ModuleNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.RootNode;
import org.jrubyparser.ast.SClassNode;
import org.jrubyparser.ast.SelfNode;
import org.jrubyparser.ast.SplatNode;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.ast.UnnamedRestArgNode;
import org.jrubyparser.ast.VCallNode;
import org.jrubyparser.ast.YieldNode;

public class SourceElementVisitor
extends InOrderVisitor {
    private static final String CLASS_ATTRIBUTE = "class_attribute";
    private static final String CATTR_ACCESSOR = "cattr_accessor";
    private static final String CATTR_READER = "cattr_reader";
    private static final String CATTR_WRITER = "cattr_writer";
    private static final String BELONGS_TO = "belongs_to";
    private static final String HAS_ONE = "has_one";
    private static final String HAS_MANY = "has_many";
    private static final String DELEGATE = "delegate";
    private static final String EXTEND = "extend";
    private static final String OBJECT = "Object";
    private static final String CONSTRUCTOR_NAME = "initialize";
    private static final String MODULE = "Module";
    private static final String REQUIRE = "require";
    private static final String LOAD = "load";
    private static final String INCLUDE = "include";
    private static final String PUBLIC = "public";
    private static final String PROTECTED = "protected";
    private static final String PRIVATE = "private";
    private static final String MODULE_FUNCTION = "module_function";
    private static final String ALIAS = "alias :";
    private static final String ALIAS_METHOD = "alias_method";
    private static final String ATTR = "attr";
    private static final String ATTR_ACCESSOR = "attr_accessor";
    private static final String ATTR_READER = "attr_reader";
    private static final String ATTR_WRITER = "attr_writer";
    private static final String CLASS_EVAL = "class_eval";
    private static final String NAMESPACE_DELIMETER = "::";
    private ISourceElementRequestor requestor;
    private List<IRubyMethod.Visibility> visibilities;
    private String typeName;
    private boolean inSingletonClass;
    private boolean inModuleFunction;

    public SourceElementVisitor(ISourceElementRequestor requestor) {
        this.requestor = requestor;
        this.visibilities = new ArrayList<IRubyMethod.Visibility>();
    }

    @Override
    public Object visitAliasNode(AliasNode iVisited) {
        Node newNameNode = iVisited.getNewName();
        String name = ASTUtils.getName(newNameNode);
        int nameStart = iVisited.getPosition().getStartOffset() + ALIAS.length() - 1;
        this.addAliasMethod(name, iVisited.getPosition().getStartOffset(), iVisited.getPosition().getEndOffset(), nameStart);
        return super.visitAliasNode(iVisited);
    }

    @Override
    public Object visitArgsNode(ArgsNode iVisited) {
        ArgumentNode restArg;
        ListNode args = iVisited.getPre();
        if (args != null) {
            int size = args.size();
            int i = 0;
            while (i < size) {
                Node arg = args.get(i);
                this.requestor.enterField(SourceElementVisitor.createFieldInfo(arg));
                this.requestor.exitField(SourceElementVisitor.getFieldEndOffset(arg));
                ++i;
            }
        }
        if ((restArg = iVisited.getRest()) != null && !(restArg instanceof UnnamedRestArgNode)) {
            ISourceElementRequestor.FieldInfo field = SourceElementVisitor.createFieldInfo((Node)restArg);
            ++field.declarationStart;
            ++field.nameSourceStart;
            ++field.nameSourceEnd;
            this.requestor.enterField(field);
            this.requestor.exitField(SourceElementVisitor.getFieldEndOffset((Node)restArg) + 1);
        }
        return super.visitArgsNode(iVisited);
    }

    @Override
    public Object visitCallNode(CallNode iVisited) {
        Node receiver;
        List<String> arguments = ASTUtils.getArgumentsFromFunctionCall((IArgumentNode)iVisited);
        String name = iVisited.getName();
        if (name.equals(PUBLIC)) {
            for (String methodName : arguments) {
                this.requestor.acceptMethodVisibilityChange(methodName, SourceElementVisitor.convertVisibility(IRubyMethod.Visibility.PUBLIC));
            }
        } else if (name.equals(PRIVATE)) {
            for (String methodName : arguments) {
                this.requestor.acceptMethodVisibilityChange(methodName, SourceElementVisitor.convertVisibility(IRubyMethod.Visibility.PRIVATE));
            }
        } else if (name.equals(PROTECTED)) {
            for (String methodName : arguments) {
                this.requestor.acceptMethodVisibilityChange(methodName, SourceElementVisitor.convertVisibility(IRubyMethod.Visibility.PROTECTED));
            }
        } else if (name.equals(MODULE_FUNCTION)) {
            for (String methodName : arguments) {
                this.requestor.acceptModuleFunction(methodName);
            }
        } else if (name.equals(CLASS_EVAL) && ((receiver = iVisited.getReceiverNode()) instanceof ConstNode || receiver instanceof Colon2Node)) {
            String receiverName = null;
            receiverName = receiver instanceof Colon2Node ? ASTUtils.getFullyQualifiedName((Colon2Node)receiver) : ASTUtils.getName(receiver);
            this.requestor.acceptMethodReference(name, arguments.size(), iVisited.getPosition().getStartOffset());
            this.pushVisibility(IRubyMethod.Visibility.PUBLIC);
            ISourceElementRequestor.TypeInfo typeInfo = new ISourceElementRequestor.TypeInfo();
            typeInfo.name = receiverName;
            typeInfo.declarationStart = iVisited.getPosition().getStartOffset();
            typeInfo.nameSourceStart = receiver.getPosition().getStartOffset();
            typeInfo.nameSourceEnd = receiver.getPosition().getEndOffset() - 1;
            typeInfo.modules = ArrayUtil.NO_STRINGS;
            this.requestor.enterType(typeInfo);
            Object ins = super.visitCallNode(iVisited);
            this.popVisibility();
            this.requestor.exitType(iVisited.getPosition().getEndOffset() - 2);
            return ins;
        }
        this.requestor.acceptMethodReference(name, arguments.size(), iVisited.getPosition().getStartOffset());
        return super.visitCallNode(iVisited);
    }

    @Override
    public Object visitClassNode(ClassNode iVisited) {
        this.pushVisibility(IRubyMethod.Visibility.PUBLIC);
        ISourceElementRequestor.TypeInfo typeInfo = SourceElementVisitor.createTypeInfo((Node)iVisited.getCPath());
        typeInfo.declarationStart = iVisited.getCPath().getPosition().getStartOffset() - 6;
        if (!typeInfo.name.equals(OBJECT)) {
            Node superNode = iVisited.getSuperNode();
            typeInfo.superclass = superNode == null ? OBJECT : ASTUtils.getFullyQualifiedName(superNode);
        }
        this.typeName = typeInfo.name;
        this.requestor.enterType(typeInfo);
        Object ins = super.visitClassNode(iVisited);
        this.popVisibility();
        this.requestor.exitType(iVisited.getPosition().getEndOffset() - 2);
        return ins;
    }

    @Override
    public Object visitClassVarAsgnNode(ClassVarAsgnNode iVisited) {
        ISourceElementRequestor.FieldInfo field = SourceElementVisitor.createFieldInfo((Node)iVisited);
        this.requestor.enterField(field);
        this.requestor.exitField(SourceElementVisitor.getFieldEndOffset((Node)iVisited));
        return super.visitClassVarAsgnNode(iVisited);
    }

    @Override
    public Object visitClassVarDeclNode(ClassVarDeclNode iVisited) {
        ISourceElementRequestor.FieldInfo field = SourceElementVisitor.createFieldInfo((Node)iVisited);
        this.requestor.enterField(field);
        this.requestor.exitField(SourceElementVisitor.getFieldEndOffset((Node)iVisited));
        return super.visitClassVarDeclNode(iVisited);
    }

    @Override
    public Object visitClassVarNode(ClassVarNode iVisited) {
        this.requestor.acceptFieldReference(iVisited.getName(), iVisited.getPosition().getStartOffset());
        return super.visitClassVarNode(iVisited);
    }

    @Override
    public Object visitConstDeclNode(ConstDeclNode iVisited) {
        ISourceElementRequestor.FieldInfo field = SourceElementVisitor.createFieldInfo((Node)iVisited);
        this.requestor.enterField(field);
        this.requestor.exitField(SourceElementVisitor.getFieldEndOffset((Node)iVisited));
        return super.visitConstDeclNode(iVisited);
    }

    @Override
    public Object visitConstNode(ConstNode iVisited) {
        this.requestor.acceptTypeReference(iVisited.getName(), iVisited.getPosition().getStartOffset(), iVisited.getPosition().getEndOffset());
        return super.visitConstNode(iVisited);
    }

    @Override
    public Object visitDAsgnNode(DAsgnNode iVisited) {
        ISourceElementRequestor.FieldInfo field = SourceElementVisitor.createFieldInfo((Node)iVisited);
        field.isDynamic = true;
        this.requestor.enterField(field);
        this.requestor.exitField(SourceElementVisitor.getFieldEndOffset((Node)iVisited));
        return super.visitDAsgnNode(iVisited);
    }

    @Override
    public Object visitDefnNode(DefnNode iVisited) {
        IRubyMethod.Visibility visibility = this.getCurrentVisibility();
        ISourceElementRequestor.MethodInfo methodInfo = SourceElementVisitor.createMethodInfo((MethodDefNode)iVisited);
        if (methodInfo.name.equals(CONSTRUCTOR_NAME)) {
            visibility = IRubyMethod.Visibility.PROTECTED;
            methodInfo.isConstructor = true;
        }
        methodInfo.isClassLevel = this.inSingletonClass || this.inModuleFunction;
        methodInfo.visibility = SourceElementVisitor.convertVisibility(visibility);
        if (methodInfo.isConstructor) {
            this.requestor.enterConstructor(methodInfo);
        } else {
            this.requestor.enterMethod(methodInfo);
        }
        Object ins = super.visitDefnNode(iVisited);
        int end = iVisited.getPosition().getEndOffset() - 2;
        if (methodInfo.isConstructor) {
            this.requestor.exitConstructor(end);
        } else {
            this.requestor.exitMethod(end);
        }
        return ins;
    }

    @Override
    public Object visitDefsNode(DefsNode iVisited) {
        ISourceElementRequestor.MethodInfo methodInfo = SourceElementVisitor.createMethodInfo((MethodDefNode)iVisited);
        methodInfo.isClassLevel = true;
        methodInfo.visibility = SourceElementVisitor.convertVisibility(this.getCurrentVisibility());
        this.requestor.enterMethod(methodInfo);
        Object ins = super.visitDefsNode(iVisited);
        this.requestor.exitMethod(iVisited.getPosition().getEndOffset() - 2);
        return ins;
    }

    @Override
    public Object visitFCallNode(FCallNode iVisited) {
        List<String> arguments = ASTUtils.getArgumentsFromFunctionCall((IArgumentNode)iVisited);
        String name = iVisited.getName();
        if (REQUIRE.equals(name) || LOAD.equals(name)) {
            this.addImport(iVisited);
        } else if (EXTEND.equals(name)) {
            this.includeModule(iVisited);
        } else if (INCLUDE.equals(name)) {
            this.includeModule(iVisited);
        } else if (PUBLIC.equals(name)) {
            for (String methodName : arguments) {
                this.requestor.acceptMethodVisibilityChange(methodName, SourceElementVisitor.convertVisibility(IRubyMethod.Visibility.PUBLIC));
            }
        } else if (PRIVATE.equals(name)) {
            for (String methodName : arguments) {
                this.requestor.acceptMethodVisibilityChange(methodName, SourceElementVisitor.convertVisibility(IRubyMethod.Visibility.PRIVATE));
            }
        } else if (PROTECTED.equals(name)) {
            for (String methodName : arguments) {
                this.requestor.acceptMethodVisibilityChange(methodName, SourceElementVisitor.convertVisibility(IRubyMethod.Visibility.PROTECTED));
            }
        } else if (MODULE_FUNCTION.equals(name)) {
            for (String methodName : arguments) {
                this.requestor.acceptModuleFunction(methodName);
            }
        } else if (ALIAS_METHOD.equals(name)) {
            String newName = arguments.get(0).substring(1);
            int nameStart = iVisited.getPosition().getStartOffset() + name.length() + 2;
            this.addAliasMethod(newName, iVisited.getPosition().getStartOffset(), iVisited.getPosition().getEndOffset(), nameStart);
        } else if (DELEGATE.equals(name)) {
            this.addDelegatedMethods(iVisited);
        } else if (CLASS_ATTRIBUTE.equals(name)) {
            List<Node> nodes = ASTUtils.getArgumentNodesFromFunctionCall((IArgumentNode)iVisited);
            int size = arguments.size();
            int i = 0;
            while (i < size) {
                Node node = nodes.get(i);
                if (!(node instanceof HashNode)) {
                    String arg = arguments.get(i);
                    ISourceElementRequestor.MethodInfo info = this.createPublicMethod(String.valueOf(this.dropLeadingColon(arg)) + "?", node);
                    this.requestor.enterMethod(info);
                    this.requestor.exitMethod(node.getPosition().getEndOffset() - 1);
                    info = this.createPublicMethod(String.valueOf(this.dropLeadingColon(arg)) + "?", node);
                    info.isClassLevel = true;
                    this.requestor.enterMethod(info);
                    this.requestor.exitMethod(node.getPosition().getEndOffset() - 1);
                    this.addClassLevelReadMethod(arg, node);
                    this.addClassLevelWriteMethod(arg, node);
                    this.addReadMethod(arg, node);
                    this.addWriteMethod(arg, node);
                }
                ++i;
            }
        } else if (HAS_MANY.equals(name)) {
            this.addHasManyAssociationMethods(iVisited, arguments.get(0));
        } else if (HAS_ONE.equals(name)) {
            this.addHasOneAssociationMethods(iVisited, arguments.get(0));
        } else if (BELONGS_TO.equals(name)) {
            this.addHasOneAssociationMethods(iVisited, arguments.get(0));
        } else if (CATTR_ACCESSOR.equals(name) || CATTR_READER.equals(name) || CATTR_WRITER.equals(name)) {
            boolean addRead = false;
            boolean addInstanceRead = true;
            boolean addWrite = false;
            boolean addInstanceWrite = true;
            if (CATTR_ACCESSOR.equals(name)) {
                addRead = true;
                addWrite = true;
            } else if (CATTR_READER.equals(name)) {
                addRead = true;
            } else if (CATTR_WRITER.equals(name)) {
                addWrite = true;
            }
            List<Node> nodes = ASTUtils.getArgumentNodesFromFunctionCall((IArgumentNode)iVisited);
            Node lastNode = nodes.get(nodes.size() - 1);
            if (lastNode instanceof HashNode) {
                HashNode hash = (HashNode)lastNode;
                ListNode hashValues = hash.getListNode();
                int x = 0;
                while (x < hashValues.size()) {
                    Node key = hashValues.get(x);
                    Node value = hashValues.get(x + 1);
                    if ("false".equals(ASTUtils.getStringRepresentation(value))) {
                        if (":instance_writer".equals(ASTUtils.getStringRepresentation(key))) {
                            addInstanceWrite = false;
                        } else if (":instance_reader".equals(ASTUtils.getStringRepresentation(key))) {
                            addInstanceRead = false;
                        }
                    }
                    x += 2;
                }
            }
            int size = arguments.size();
            int i = 0;
            while (i < size) {
                Node node = nodes.get(i);
                if (!(node instanceof HashNode)) {
                    String arg = arguments.get(i);
                    if (addRead) {
                        this.addClassLevelReadMethod(arg, node);
                        if (addInstanceRead) {
                            this.addReadMethod(arg, node);
                        }
                    }
                    if (addWrite) {
                        this.addClassLevelWriteMethod(arg, node);
                        if (addInstanceWrite) {
                            this.addWriteMethod(arg, node);
                        }
                    }
                    this.addClassVar(arg, node);
                }
                ++i;
            }
        } else if (ATTR.equals(name) || ATTR_ACCESSOR.equals(name) || ATTR_READER.equals(name) || ATTR_WRITER.equals(name)) {
            List<Node> nodes = ASTUtils.getArgumentNodesFromFunctionCall((IArgumentNode)iVisited);
            boolean addRead = false;
            boolean addWrite = false;
            if (ATTR_ACCESSOR.equals(name)) {
                addRead = true;
                addWrite = true;
            } else if (ATTR_READER.equals(name)) {
                addRead = true;
            } else if (ATTR_WRITER.equals(name)) {
                addWrite = true;
            }
            if (ATTR.equals(name)) {
                addRead = true;
                if (arguments.size() == 2 && "true".equals(arguments.get(1))) {
                    addWrite = true;
                }
            }
            int size = arguments.size();
            int i = 0;
            while (i < size) {
                if (!ATTR.equals(name) || !addWrite || i <= 0) {
                    Node node = nodes.get(i);
                    String arg = arguments.get(i);
                    if (addRead) {
                        this.addReadMethod(arg, node);
                    }
                    if (addWrite) {
                        this.addWriteMethod(arg, node);
                    }
                    this.addInstanceVar(arg, node);
                    ++i;
                    continue;
                }
                break;
            }
        }
        this.requestor.acceptMethodReference(name, arguments.size(), iVisited.getPosition().getStartOffset());
        return super.visitFCallNode(iVisited);
    }

    private void addInstanceVar(String arg, Node node) {
        ISourceElementRequestor.FieldInfo field = new ISourceElementRequestor.FieldInfo();
        field.declarationStart = node.getPosition().getStartOffset();
        String argName = this.dropLeadingColon(arg);
        field.name = "@" + argName;
        field.nameSourceStart = node.getPosition().getStartOffset();
        field.nameSourceEnd = node.getPosition().getEndOffset() - 1;
        this.requestor.enterField(field);
        this.requestor.exitField(node.getPosition().getEndOffset() - 1);
    }

    private ISourceElementRequestor.MethodInfo createPublicMethod(String methodName, Node node) {
        ISourceElementRequestor.MethodInfo info = new ISourceElementRequestor.MethodInfo();
        info.declarationStart = node.getPosition().getStartOffset();
        info.name = methodName;
        info.nameSourceStart = node.getPosition().getStartOffset();
        info.nameSourceEnd = node.getPosition().getEndOffset() - 1;
        info.visibility = IRubyMethod.Visibility.PUBLIC;
        info.parameterNames = ArrayUtil.NO_STRINGS;
        return info;
    }

    private void addClassVar(String arg, Node node) {
        int end;
        ISourceElementRequestor.FieldInfo field = new ISourceElementRequestor.FieldInfo();
        field.name = "@@" + this.dropLeadingColon(arg);
        field.declarationStart = node.getPosition().getStartOffset();
        field.nameSourceStart = node.getPosition().getStartOffset();
        field.nameSourceEnd = end = node.getPosition().getStartOffset() + field.name.length() - 2;
        this.requestor.enterField(field);
        this.requestor.exitField(end);
    }

    protected void addHasManyAssociationMethods(FCallNode iVisited, String association) {
        String firstArg = this.dropLeadingColon(association);
        Node argsNode = iVisited.getArgsNode();
        Node firstArgNode = (Node)argsNode.childNodes().iterator().next();
        this.addReadMethod(firstArg, firstArgNode);
        this.addReadMethod(String.valueOf(firstArg) + "=", firstArgNode);
    }

    protected void addHasOneAssociationMethods(FCallNode iVisited, String association) {
        String firstArg = this.dropLeadingColon(association);
        Node argsNode = iVisited.getArgsNode();
        Node firstArgNode = (Node)argsNode.childNodes().iterator().next();
        this.addReadMethod(firstArg, firstArgNode);
        this.addReadMethod(String.valueOf(firstArg) + "=", firstArgNode);
        this.addReadMethod("build_" + firstArg, firstArgNode);
        this.addReadMethod("create_" + firstArg, firstArgNode);
    }

    private String dropLeadingColon(String association) {
        if (association.length() > 0 && association.charAt(0) == ':') {
            return association.substring(1);
        }
        return association;
    }

    protected void addDelegatedMethods(FCallNode iVisited) {
        List<Node> nodes = ASTUtils.getArgumentNodesFromFunctionCall((IArgumentNode)iVisited);
        String prefix = "";
        String to = "";
        boolean useToForPrefix = false;
        Node lastNode = nodes.get(nodes.size() - 1);
        if (lastNode instanceof HashNode) {
            HashNode hash = (HashNode)lastNode;
            ListNode hashValues = hash.getListNode();
            int x = 0;
            while (x < hashValues.size()) {
                Node key = hashValues.get(x);
                Node value = hashValues.get(x + 1);
                if (":to".equals(ASTUtils.getStringRepresentation(key))) {
                    to = ASTUtils.getStringRepresentation(value);
                } else if (":prefix".equals(ASTUtils.getStringRepresentation(key))) {
                    String blah = ASTUtils.getStringRepresentation(value);
                    if ("true".equals(blah)) {
                        useToForPrefix = true;
                    } else {
                        prefix = this.dropLeadingColon(blah);
                    }
                }
                x += 2;
            }
        }
        if (useToForPrefix) {
            prefix = this.dropLeadingColon(to);
        }
        if (prefix.length() > 0) {
            prefix = String.valueOf(prefix) + "_";
        }
        for (Node arg : nodes) {
            if (arg instanceof HashNode) continue;
            String methodName = String.valueOf(prefix) + this.dropLeadingColon(ASTUtils.getStringRepresentation(arg));
            int start = arg.getPosition().getStartOffset();
            int end = arg.getPosition().getEndOffset() - 1;
            ISourceElementRequestor.MethodInfo method = new ISourceElementRequestor.MethodInfo();
            IRubyMethod.Visibility visibility = this.getCurrentVisibility();
            method.declarationStart = start;
            method.isClassLevel = this.inSingletonClass;
            method.name = methodName;
            method.visibility = SourceElementVisitor.convertVisibility(visibility);
            method.nameSourceStart = start;
            method.nameSourceEnd = end;
            method.parameterNames = ArrayUtil.NO_STRINGS;
            this.requestor.enterMethod(method);
            this.requestor.exitMethod(end);
        }
    }

    @Override
    public Object visitGlobalAsgnNode(GlobalAsgnNode iVisited) {
        ISourceElementRequestor.FieldInfo field = SourceElementVisitor.createFieldInfo((Node)iVisited);
        this.requestor.enterField(field);
        this.requestor.exitField(SourceElementVisitor.getFieldEndOffset((Node)iVisited));
        return super.visitGlobalAsgnNode(iVisited);
    }

    @Override
    public Object visitGlobalVarNode(GlobalVarNode iVisited) {
        this.requestor.acceptFieldReference(iVisited.getName(), iVisited.getPosition().getStartOffset());
        return super.visitGlobalVarNode(iVisited);
    }

    @Override
    public Object visitInstAsgnNode(InstAsgnNode iVisited) {
        ISourceElementRequestor.FieldInfo field = SourceElementVisitor.createFieldInfo((Node)iVisited);
        this.requestor.enterField(field);
        this.requestor.exitField(SourceElementVisitor.getFieldEndOffset((Node)iVisited));
        return super.visitInstAsgnNode(iVisited);
    }

    @Override
    public Object visitInstVarNode(InstVarNode iVisited) {
        this.requestor.acceptFieldReference(iVisited.getName(), iVisited.getPosition().getStartOffset());
        return super.visitInstVarNode(iVisited);
    }

    @Override
    public Object visitIterNode(IterNode iVisited) {
        this.requestor.enterBlock(iVisited.getPosition().getStartOffset(), iVisited.getPosition().getEndOffset() - 1);
        Object ins = super.visitIterNode(iVisited);
        this.requestor.exitBlock(iVisited.getPosition().getEndOffset() - 1);
        return ins;
    }

    @Override
    public Object visitModuleNode(ModuleNode iVisited) {
        this.pushVisibility(IRubyMethod.Visibility.PUBLIC);
        ISourceElementRequestor.TypeInfo typeInfo = SourceElementVisitor.createTypeInfo((Node)iVisited.getCPath());
        typeInfo.declarationStart = iVisited.getCPath().getPosition().getStartOffset() - 7;
        typeInfo.superclass = MODULE;
        typeInfo.isModule = true;
        this.typeName = typeInfo.name;
        this.requestor.enterType(typeInfo);
        Object ins = super.visitModuleNode(iVisited);
        this.popVisibility();
        this.requestor.exitType(iVisited.getPosition().getEndOffset() - 2);
        this.inModuleFunction = false;
        return ins;
    }

    @Override
    public Object visitLocalAsgnNode(LocalAsgnNode iVisited) {
        ISourceElementRequestor.FieldInfo field = SourceElementVisitor.createFieldInfo((Node)iVisited);
        this.requestor.enterField(field);
        this.requestor.exitField(SourceElementVisitor.getFieldEndOffset((Node)iVisited));
        return super.visitLocalAsgnNode(iVisited);
    }

    @Override
    public Object visitRootNode(RootNode iVisited) {
        this.requestor.enterScript();
        this.pushVisibility(IRubyMethod.Visibility.PUBLIC);
        Object ins = super.visitRootNode(iVisited);
        this.popVisibility();
        this.requestor.exitScript(iVisited.getPosition().getEndOffset());
        return ins;
    }

    @Override
    public Object visitSClassNode(SClassNode iVisited) {
        Node receiver = iVisited.getReceiverNode();
        if (receiver instanceof SelfNode) {
            this.inSingletonClass = true;
        }
        this.pushVisibility(IRubyMethod.Visibility.PUBLIC);
        Object ins = super.visitSClassNode(iVisited);
        this.popVisibility();
        if (receiver instanceof SelfNode) {
            this.inSingletonClass = false;
        }
        return ins;
    }

    @Override
    public Object visitVCallNode(VCallNode iVisited) {
        String functionName = iVisited.getName();
        if (functionName.equals(PUBLIC)) {
            this.setVisibility(IRubyMethod.Visibility.PUBLIC);
        } else if (functionName.equals(PRIVATE)) {
            this.setVisibility(IRubyMethod.Visibility.PRIVATE);
        } else if (functionName.equals(PROTECTED)) {
            this.setVisibility(IRubyMethod.Visibility.PROTECTED);
        } else if (functionName.equals(MODULE_FUNCTION)) {
            this.inModuleFunction = true;
        }
        this.requestor.acceptMethodReference(functionName, 0, iVisited.getPosition().getStartOffset());
        return super.visitVCallNode(iVisited);
    }

    @Override
    public Object visitYieldNode(YieldNode iVisited) {
        Node argsNode = iVisited.getArgsNode();
        if (argsNode instanceof LocalVarNode) {
            this.requestor.acceptYield(((LocalVarNode)argsNode).getName());
        } else if (argsNode instanceof SelfNode) {
            String name = null;
            if (this.typeName == null) {
                name = "var";
            } else {
                name = this.typeName.toLowerCase();
                if (name.indexOf(NAMESPACE_DELIMETER) > -1) {
                    name = name.substring(name.lastIndexOf(NAMESPACE_DELIMETER) + 2);
                }
            }
            this.requestor.acceptYield(name);
        }
        return super.visitYieldNode(iVisited);
    }

    private void pushVisibility(IRubyMethod.Visibility visibility) {
        this.visibilities.add(visibility);
    }

    private void popVisibility() {
        this.visibilities.remove(this.visibilities.size() - 1);
    }

    private IRubyMethod.Visibility getCurrentVisibility() {
        return this.visibilities.get(this.visibilities.size() - 1);
    }

    private void setVisibility(IRubyMethod.Visibility visibility) {
        this.popVisibility();
        this.pushVisibility(visibility);
    }

    private void addImport(FCallNode iVisited) {
        ArrayNode node;
        String arg;
        Node argsNode = iVisited.getArgsNode();
        if (argsNode instanceof ArrayNode && (arg = SourceElementVisitor.getString(node = (ArrayNode)argsNode)) != null) {
            this.requestor.acceptImport(arg, iVisited.getPosition().getStartOffset(), iVisited.getPosition().getEndOffset());
        }
    }

    private void addAliasMethod(String name, int start, int end, int nameStart) {
        ISourceElementRequestor.MethodInfo method = new ISourceElementRequestor.MethodInfo();
        IRubyMethod.Visibility visibility = this.getCurrentVisibility();
        if (name.equals(CONSTRUCTOR_NAME)) {
            visibility = IRubyMethod.Visibility.PROTECTED;
            method.isConstructor = true;
        }
        method.declarationStart = start;
        method.isClassLevel = this.inSingletonClass;
        method.name = name;
        method.visibility = SourceElementVisitor.convertVisibility(visibility);
        method.nameSourceStart = nameStart;
        method.nameSourceEnd = nameStart + name.length() - 1;
        method.parameterNames = ArrayUtil.NO_STRINGS;
        this.requestor.enterMethod(method);
        this.requestor.exitMethod(end);
    }

    private ISourceElementRequestor.MethodInfo createReadMethod(String argument, Node node) {
        argument = this.dropLeadingColon(argument);
        ISourceElementRequestor.MethodInfo info = new ISourceElementRequestor.MethodInfo();
        info.declarationStart = node.getPosition().getStartOffset();
        info.name = argument;
        info.nameSourceStart = node.getPosition().getStartOffset();
        info.nameSourceEnd = node.getPosition().getEndOffset() - 1;
        info.visibility = IRubyMethod.Visibility.PUBLIC;
        info.parameterNames = ArrayUtil.NO_STRINGS;
        return info;
    }

    private void addReadMethod(String argument, Node node) {
        this.requestor.enterMethod(this.createReadMethod(argument, node));
        this.requestor.exitMethod(node.getPosition().getEndOffset() - 1);
    }

    private void addClassLevelReadMethod(String argument, Node node) {
        ISourceElementRequestor.MethodInfo info = this.createReadMethod(argument, node);
        info.isClassLevel = true;
        this.requestor.enterMethod(info);
        this.requestor.exitMethod(node.getPosition().getEndOffset() - 1);
    }

    private ISourceElementRequestor.MethodInfo createWriteMethod(String argument, int start, int end) {
        argument = this.dropLeadingColon(argument);
        ISourceElementRequestor.MethodInfo info = new ISourceElementRequestor.MethodInfo();
        info.declarationStart = start;
        info.name = String.valueOf(argument) + "=";
        info.nameSourceStart = start;
        info.nameSourceEnd = end;
        info.visibility = IRubyMethod.Visibility.PUBLIC;
        info.parameterNames = new String[]{"new_value"};
        return info;
    }

    private void addWriteMethod(String argument, Node node) {
        this.addWriteMethod(argument, node.getPosition().getStartOffset(), node.getPosition().getEndOffset() - 1);
    }

    private void addWriteMethod(String argument, int start, int end) {
        ISourceElementRequestor.MethodInfo info = this.createWriteMethod(argument, start, end);
        this.requestor.enterMethod(info);
        this.requestor.exitMethod(end);
    }

    private void addClassLevelWriteMethod(String argument, Node node) {
        int start = node.getPosition().getStartOffset();
        int end = node.getPosition().getEndOffset() - 1;
        ISourceElementRequestor.MethodInfo info = this.createWriteMethod(argument, start, end);
        info.isClassLevel = true;
        this.requestor.enterMethod(info);
        this.requestor.exitMethod(end);
    }

    private void includeModule(FCallNode iVisited) {
        LinkedList<String> mixins = new LinkedList<String>();
        Iterator iter = null;
        Node argsNode = iVisited.getArgsNode();
        if (argsNode instanceof SplatNode) {
            iter = ((SplatNode)argsNode).childNodes().iterator();
        } else if (argsNode instanceof ArrayNode) {
            iter = ((ArrayNode)argsNode).childNodes().iterator();
        }
        if (iter != null) {
            while (iter.hasNext()) {
                Node next;
                Node node = (Node)iter.next();
                if (node instanceof StrNode) {
                    mixins.add(((StrNode)node).getValue());
                    continue;
                }
                if (node instanceof ConstNode) {
                    mixins.add(((ConstNode)node).getName());
                    continue;
                }
                if (node instanceof Colon2Node) {
                    mixins.add(ASTUtils.getFullyQualifiedName((Colon2Node)node));
                    continue;
                }
                if (!(node instanceof DStrNode) || !((next = (Node)((DStrNode)node).childNodes().iterator().next()) instanceof StrNode)) continue;
                mixins.add(((StrNode)next).getValue());
            }
        }
        for (String string : mixins) {
            this.requestor.acceptMixin(string);
        }
    }

    private static ISourceElementRequestor.FieldInfo createFieldInfo(Node iVisited) {
        ISourceElementRequestor.FieldInfo field = new ISourceElementRequestor.FieldInfo();
        field.name = ASTUtils.getName(iVisited);
        field.declarationStart = iVisited.getPosition().getStartOffset();
        field.nameSourceStart = iVisited.getPosition().getStartOffset();
        field.nameSourceEnd = iVisited.getPosition().getStartOffset() + field.name.length() - 1;
        return field;
    }

    private static ISourceElementRequestor.TypeInfo createTypeInfo(Node iVisited) {
        ISourceElementRequestor.TypeInfo typeInfo = new ISourceElementRequestor.TypeInfo();
        typeInfo.name = ASTUtils.getFullyQualifiedName(iVisited);
        typeInfo.nameSourceStart = iVisited.getPosition().getStartOffset();
        typeInfo.nameSourceEnd = iVisited.getPosition().getEndOffset() - 1;
        typeInfo.modules = ArrayUtil.NO_STRINGS;
        return typeInfo;
    }

    private static ISourceElementRequestor.MethodInfo createMethodInfo(MethodDefNode iVisited) {
        ISourceElementRequestor.MethodInfo methodInfo = new ISourceElementRequestor.MethodInfo();
        methodInfo.declarationStart = iVisited.getPosition().getStartOffset();
        methodInfo.name = iVisited.getName();
        methodInfo.nameSourceStart = iVisited.getNameNode().getPosition().getStartOffset();
        methodInfo.nameSourceEnd = iVisited.getNameNode().getPosition().getEndOffset() - 1;
        methodInfo.parameterNames = ASTUtils.getArgs(iVisited.getArgsNode(), iVisited.getScope());
        return methodInfo;
    }

    private static int getFieldEndOffset(Node iVisited) {
        return iVisited.getPosition().getEndOffset() - 1;
    }

    private static String getString(ArrayNode node) {
        Node child = (Node)node.childNodes().iterator().next();
        if (child instanceof DStrNode) {
            DStrNode dstrNode = (DStrNode)child;
            child = (Node)dstrNode.childNodes().iterator().next();
        }
        if (child instanceof StrNode) {
            return ((StrNode)child).getValue();
        }
        return null;
    }

    private static IRubyMethod.Visibility convertVisibility(IRubyMethod.Visibility visibility) {
        if (visibility == IRubyMethod.Visibility.PUBLIC) {
            return IRubyMethod.Visibility.PUBLIC;
        }
        if (visibility == IRubyMethod.Visibility.PROTECTED) {
            return IRubyMethod.Visibility.PROTECTED;
        }
        return IRubyMethod.Visibility.PRIVATE;
    }
}

