/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.core;

import com.aptana.core.logging.IdeLog;
import com.aptana.parsing.AbstractParser;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.WorkingParseResult;
import com.aptana.parsing.ast.IParseError;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.ast.ParseError;
import com.aptana.ruby.core.CollectingRubyWarnings;
import com.aptana.ruby.core.NullParserResult;
import com.aptana.ruby.core.RubyCorePlugin;
import com.aptana.ruby.core.RubyParseState;
import com.aptana.ruby.core.RubyStructureBuilder;
import com.aptana.ruby.core.ast.SourceElementVisitor;
import com.aptana.ruby.internal.core.RubyComment;
import com.aptana.ruby.internal.core.RubyScript;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.jrubyparser.CompatVersion;
import org.jrubyparser.IRubyWarnings;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.CommentNode;
import org.jrubyparser.lexer.LexerSource;
import org.jrubyparser.lexer.SyntaxException;
import org.jrubyparser.parser.ParserConfiguration;
import org.jrubyparser.parser.ParserSupport;
import org.jrubyparser.parser.ParserSupport19;
import org.jrubyparser.parser.Ruby18Parser;
import org.jrubyparser.parser.Ruby19Parser;

public class RubyParser
extends AbstractParser {
    protected void parse(IParseState parseState, WorkingParseResult working) {
        ParserSupport support;
        String source = parseState.getSource();
        RubyScript root = new RubyScript(parseState.getStartingOffset(), parseState.getStartingOffset() + source.length() - 1);
        CompatVersion compatVersion = CompatVersion.BOTH;
        int lineNumber = 0;
        String fileName = "<unnamed file>";
        if (parseState instanceof RubyParseState) {
            RubyParseState rubyParseState = (RubyParseState)parseState;
            compatVersion = rubyParseState.getCompatVersion();
            lineNumber = rubyParseState.getStartingLineNumber();
            fileName = rubyParseState.getFilename();
        }
        CollectingRubyWarnings warnings = new CollectingRubyWarnings(fileName);
        Ruby18Parser parser = null;
        ParserConfiguration config = new ParserConfiguration(lineNumber, compatVersion);
        if (compatVersion == CompatVersion.RUBY1_8) {
            support = new ParserSupport();
            support.setConfiguration(config);
            parser = new Ruby18Parser(support);
        } else {
            support = new ParserSupport19();
            support.setConfiguration(config);
            parser = new Ruby19Parser((ParserSupport19)support);
        }
        parser.setWarnings((IRubyWarnings)warnings);
        LexerSource lexerSource = LexerSource.getSource((String)fileName, (Reader)new StringReader(source), (ParserConfiguration)config);
        lexerSource.setOffset(parseState.getStartingOffset());
        NullParserResult result = new NullParserResult();
        try {
            result = parser.parse(config, lexerSource);
            RubyStructureBuilder builder = new RubyStructureBuilder(root);
            SourceElementVisitor visitor = new SourceElementVisitor(builder);
            visitor.acceptNode(result.getAST());
            ArrayList<IParseNode> commentParseNodes = new ArrayList<IParseNode>();
            for (CommentNode commentNode : result.getCommentNodes()) {
                commentParseNodes.add(new RubyComment(commentNode, this.getText(source, commentNode.getPosition())));
            }
            root.setCommentNodes(commentParseNodes);
        }
        catch (SyntaxException se) {
            int start = se.getPosition().getStartOffset();
            working.addError((IParseError)new ParseError("com.aptana.contenttype.ruby", start, se.getPosition().getEndOffset() - start, se.getMessage(), IParseError.Severity.ERROR));
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)RubyCorePlugin.getDefault(), (String)"Failed to parse ruby code due to IOException", (Throwable)e);
        }
        CollectingRubyWarnings collector = warnings;
        for (IParseError warning : collector.getWarnings()) {
            working.addError(warning);
        }
        working.setParseResult((IParseRootNode)root);
    }

    private String getText(String source, SourcePosition position) {
        return new String(source.substring(position.getStartOffset(), position.getEndOffset()));
    }
}

