/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.text;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonSourceViewerConfiguration;
import com.aptana.editor.common.contentassist.ILexemeProvider;
import com.aptana.editor.common.text.RubyRegexpAutoIndentStrategy;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.editor.css.contentassist.CSSContentAssistProcessor;
import com.aptana.editor.css.contentassist.LocationType;
import com.aptana.editor.css.parsing.lexer.CSSTokenType;
import com.aptana.parsing.lexer.Lexeme;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class CSSAutoIndentStrategy
extends RubyRegexpAutoIndentStrategy {
    public CSSAutoIndentStrategy(String contentType, SourceViewerConfiguration configuration, ISourceViewer sourceViewer, IPreferenceStore prefStore) {
        super(contentType, configuration, sourceViewer, prefStore);
    }

    protected boolean autoIndent(IDocument d, DocumentCommand c) {
        if (c.offset <= 0 || d.getLength() == 0 || !this.shouldAutoIndent()) {
            return false;
        }
        AbstractThemeableEditor editor = null;
        if (this.getSourceViewerConfiguration() instanceof CommonSourceViewerConfiguration) {
            editor = ((CommonSourceViewerConfiguration)this.getSourceViewerConfiguration()).getEditor();
        }
        if (editor != null) {
            try {
                ILexemeProvider<CSSTokenType> lexemeProvider;
                CSSContentAssistProcessor css;
                LocationType location;
                IRegion line = d.getLineInformationOfOffset(c.offset);
                int lineEnd = line.getOffset() + line.getLength() - 1;
                String end = null;
                if (lineEnd > c.offset) {
                    end = d.get(c.offset, lineEnd - c.offset);
                }
                if (StringUtil.isBlank(end) && StringUtil.isNotBlank((String)d.get(line.getOffset(), line.getLength())) && (location = (css = new CSSContentAssistProcessor(editor)).getCoarseLocationType(lexemeProvider = css.createLexemeProvider(d, c.offset), c.offset)) == LocationType.INSIDE_RULE) {
                    int index = lexemeProvider.getLexemeFloorIndex(c.offset);
                    Lexeme current = lexemeProvider.getLexeme(index);
                    if (current.getType() == CSSTokenType.RCURLY) {
                        current = lexemeProvider.getLexeme(index - 1);
                    }
                    if (current == null || current.getEndingOffset() < line.getOffset()) {
                        return super.autoIndent(d, c);
                    }
                    location = css.getInsideLocationType(lexemeProvider, current.getEndingOffset()).getLocationType();
                    if (location != LocationType.INSIDE_VALUE && location != LocationType.INSIDE_ARG || current.getType() == CSSTokenType.SEMICOLON) {
                        return super.autoIndent(d, c);
                    }
                    if (lineEnd > current.getEndingOffset()) {
                        d.replace(current.getEndingOffset() + 1, lineEnd - current.getEndingOffset() - 1, "");
                        c.offset = current.getEndingOffset() + 1;
                    }
                    c.text = ";" + c.text;
                }
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
            }
        }
        return super.autoIndent(d, c);
    }

    protected boolean checkNextLineForComment(IDocument document, DocumentCommand command) {
        try {
            String content;
            ITypedRegion region = document.getPartition(command.offset);
            if (region != null && "__css_multiline_comment".equals(region.getType()) && StringUtil.isNotEmpty((String)(content = document.get(region.getOffset(), region.getLength()))) && content.endsWith("*/") && content.lastIndexOf("/*") == 0) {
                return true;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return super.checkNextLineForComment(document, command);
    }
}

