/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.parsing.ast;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.css.parsing.ast.CSSDeclarationNode;
import com.aptana.editor.css.parsing.ast.CSSNode;
import com.aptana.editor.css.parsing.ast.CSSRuleBodyNode;
import com.aptana.editor.css.parsing.ast.CSSSelectorNode;
import com.aptana.editor.css.parsing.ast.CSSTreeWalker;
import com.aptana.parsing.ast.INameNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.ParseNode;
import java.util.List;

public class CSSRuleNode
extends CSSNode {
    private static final CSSDeclarationNode[] NO_DECLARATIONS = new CSSDeclarationNode[0];
    private CSSSelectorNode[] fSelectors;
    private CSSRuleBodyNode fRuleBody;
    private ParseNode.NameNode nameNode;

    public CSSRuleNode(List<CSSSelectorNode> selectors) {
        this(selectors, null);
    }

    public CSSRuleNode(List<CSSSelectorNode> selectors, CSSRuleBodyNode ruleBody) {
        this.fSelectors = selectors.toArray(new CSSSelectorNode[selectors.size()]);
        this.fRuleBody = ruleBody;
        this.setChildren((IParseNode[])this.fSelectors);
        if (this.fRuleBody != null) {
            this.addChild((IParseNode)this.fRuleBody);
        }
    }

    @Override
    public short getNodeType() {
        return 6;
    }

    @Override
    public void accept(CSSTreeWalker walker) {
        walker.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSRuleNode)) {
            return false;
        }
        CSSRuleNode other = (CSSRuleNode)((Object)obj);
        if (this.fRuleBody != other.getRuleBody()) {
            return false;
        }
        if (this.fSelectors.length != other.fSelectors.length) {
            return false;
        }
        int i = 0;
        while (i < this.fSelectors.length) {
            if (this.fSelectors[i].getNodeType() != other.fSelectors[i].getNodeType() || this.fSelectors[i].getStartingOffset() != other.fSelectors[i].getStartingOffset()) {
                return false;
            }
            ++i;
        }
        return super.equals(obj);
    }

    public CSSRuleBodyNode getRuleBody() {
        return this.fRuleBody;
    }

    public CSSDeclarationNode[] getDeclarations() {
        return this.fRuleBody == null ? CSSRuleBodyNode.NO_DECLARATIONS : this.fRuleBody.getDeclarations();
    }

    public IParseNode getNodeAtOffset(int offset) {
        IParseNode result = super.getNodeAtOffset(offset);
        if (result == this) {
            CSSSelectorNode[] cSSSelectorNodeArray = this.fSelectors;
            int n = this.fSelectors.length;
            int n2 = 0;
            while (n2 < n) {
                CSSSelectorNode selector = cSSSelectorNodeArray[n2];
                if (selector.contains(offset)) {
                    result = selector.getNodeAtOffset(offset);
                    break;
                }
                ++n2;
            }
        }
        if (result == this && this.fRuleBody != null && this.fRuleBody.contains(offset)) {
            result = this.fRuleBody.getNodeAtOffset(offset);
        }
        return result;
    }

    public CSSSelectorNode[] getSelectors() {
        return this.fSelectors;
    }

    public int hashCode() {
        int hash = super.hashCode();
        CSSSelectorNode[] cSSSelectorNodeArray = this.fSelectors;
        int n = this.fSelectors.length;
        int n2 = 0;
        while (n2 < n) {
            CSSSelectorNode node = cSSSelectorNodeArray[n2];
            hash = hash * 31 + node.hashCode();
            ++n2;
        }
        if (this.fRuleBody != null) {
            hash = hash * 31 + this.fRuleBody.hashCode();
        }
        return hash;
    }

    public INameNode getNameNode() {
        if (this.nameNode == null) {
            StringBuilder text = new StringBuilder();
            CSSSelectorNode[] selectors = this.getSelectors();
            int end = this.end;
            CSSSelectorNode[] cSSSelectorNodeArray = selectors;
            int n = selectors.length;
            int n2 = 0;
            while (n2 < n) {
                CSSSelectorNode selector = cSSSelectorNodeArray[n2];
                text.append((Object)selector);
                String combinator = selector.getCombinator();
                end = selector.getEndingOffset();
                if (!StringUtil.isEmpty((String)combinator)) {
                    if (!",".equals(combinator)) {
                        text.append(' ');
                    }
                    text.append(combinator).append(' ');
                }
                ++n2;
            }
            this.nameNode = new ParseNode.NameNode(text.toString(), this.start, end);
        }
        return this.nameNode;
    }

    public String toString() {
        CSSSelectorNode[] selectors;
        StringBuilder text = new StringBuilder();
        CSSSelectorNode[] cSSSelectorNodeArray = selectors = this.getSelectors();
        int n = selectors.length;
        int n2 = 0;
        while (n2 < n) {
            CSSSelectorNode selector = cSSSelectorNodeArray[n2];
            text.append((Object)selector);
            String combinator = selector.getCombinator();
            if (!StringUtil.isEmpty((String)combinator)) {
                if (!",".equals(combinator)) {
                    text.append(' ');
                }
                text.append(combinator).append(' ');
            }
            ++n2;
        }
        CSSDeclarationNode[] declarations = this.getDeclarations();
        text.append(" {");
        int i = 0;
        while (i < declarations.length) {
            text.append((Object)declarations[i]);
            if (i < declarations.length - 1) {
                text.append(' ');
            }
            ++i;
        }
        text.append('}');
        return text.toString();
    }
}

