/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.parsing.ast;

import com.aptana.editor.css.parsing.ast.CSSDeclarationNode;
import com.aptana.editor.css.parsing.ast.CSSNode;
import com.aptana.editor.css.parsing.ast.CSSTreeWalker;
import com.aptana.parsing.ast.IParseNode;

public class CSSPageNode
extends CSSNode {
    private static final String PAGE = "@page";
    private CSSNode[] fPageSelects;

    public CSSPageNode() {
        this(null, new CSSNode[0]);
    }

    public CSSPageNode(CSSNode ruleBody, CSSNode ... pageSelects) {
        this.setChildren((IParseNode[])pageSelects);
        this.addChild((IParseNode)ruleBody);
        this.fPageSelects = pageSelects;
    }

    @Override
    public short getNodeType() {
        return 8;
    }

    @Override
    public void accept(CSSTreeWalker walker) {
        walker.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof CSSPageNode)) {
            return false;
        }
        CSSPageNode other = (CSSPageNode)((Object)obj);
        return this.toString().equals(other.toString());
    }

    public CSSDeclarationNode[] getDeclarations() {
        return null;
    }

    public CSSNode[] getSelector() {
        return this.fPageSelects;
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append(PAGE);
        CSSNode[] selector = this.getSelector();
        if (selector != null) {
            text.append(' ');
            CSSNode[] cSSNodeArray = selector;
            int n = selector.length;
            int n2 = 0;
            while (n2 < n) {
                CSSNode child = cSSNodeArray[n2];
                text.append((Object)child);
                text.append(",");
                ++n2;
            }
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }

    public int hashCode() {
        return super.hashCode() * 31 + this.toString().hashCode();
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(PAGE);
        CSSNode[] selector = this.getSelector();
        if (selector != null) {
            text.append(' ');
            CSSNode[] cSSNodeArray = selector;
            int n = selector.length;
            int n2 = 0;
            while (n2 < n) {
                CSSNode child = cSSNodeArray[n2];
                text.append((Object)child);
                text.append(",");
                ++n2;
            }
            text.deleteCharAt(text.length() - 1);
        }
        text.append(" {");
        text.append('}');
        return text.toString();
    }
}

