/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.parsing;

import com.aptana.editor.common.text.rules.CharacterMapRule;
import com.aptana.editor.common.text.rules.ExtendedWordRule;
import com.aptana.editor.common.text.rules.WhitespaceDetector;
import com.aptana.editor.css.internal.text.rules.CSSFunctionRule;
import com.aptana.editor.css.internal.text.rules.CSSHexColorRule;
import com.aptana.editor.css.internal.text.rules.CSSIdentifierRule;
import com.aptana.editor.css.internal.text.rules.CSSNumberRule;
import com.aptana.editor.css.internal.text.rules.CSSURLRule;
import com.aptana.editor.css.internal.text.rules.EqualOperatorWordDetector;
import com.aptana.editor.css.internal.text.rules.IdentifierWithPrefixDetector;
import com.aptana.editor.css.parsing.lexer.CSSTokenType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class CSSTokenScanner
extends RuleBasedScanner {
    private static Pattern CLASS_IS_NUMBER_PATTERN = Pattern.compile("\\.[0-9]+");
    private boolean _inMediaRule;
    private int _curlyBraceCount;

    public CSSTokenScanner() {
        List<IRule> rules = this.createRules();
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }

    private WordRule createAtWordsRule() {
        WordRule atRule = new WordRule((IWordDetector)new IdentifierWithPrefixDetector('@'), this.createToken(CSSTokenType.AT_RULE), true);
        atRule.addWord("@import", this.createToken(CSSTokenType.IMPORT));
        atRule.addWord("@page", this.createToken(CSSTokenType.PAGE));
        atRule.addWord("@media", this.createToken(CSSTokenType.MEDIA_KEYWORD));
        atRule.addWord("@charset", this.createToken(CSSTokenType.CHARSET));
        atRule.addWord("@font-face", this.createToken(CSSTokenType.FONTFACE));
        atRule.addWord("@namespace", this.createToken(CSSTokenType.NAMESPACE));
        atRule.addWord("@keyframes", this.createToken(CSSTokenType.KEYFRAMES_KEYWORD));
        atRule.addWord("@document", this.createToken(CSSTokenType.MOZ_DOCUMENT));
        return atRule;
    }

    protected CharacterMapRule createPunctuatorsRule() {
        CharacterMapRule punctuatorsRule = new CharacterMapRule();
        punctuatorsRule.add(':', this.createToken(CSSTokenType.COLON));
        punctuatorsRule.add(';', this.createToken(CSSTokenType.SEMICOLON));
        punctuatorsRule.add('{', this.createToken(CSSTokenType.LCURLY));
        punctuatorsRule.add('}', this.createToken(CSSTokenType.RCURLY));
        punctuatorsRule.add('(', this.createToken(CSSTokenType.LPAREN));
        punctuatorsRule.add(')', this.createToken(CSSTokenType.RPAREN));
        punctuatorsRule.add('%', this.createToken(CSSTokenType.PERCENTAGE));
        punctuatorsRule.add('[', this.createToken(CSSTokenType.LBRACKET));
        punctuatorsRule.add(']', this.createToken(CSSTokenType.RBRACKET));
        punctuatorsRule.add(',', this.createToken(CSSTokenType.COMMA));
        punctuatorsRule.add('+', this.createToken(CSSTokenType.PLUS));
        punctuatorsRule.add('*', this.createToken(CSSTokenType.STAR));
        punctuatorsRule.add('>', this.createToken(CSSTokenType.GREATER));
        punctuatorsRule.add('/', this.createToken(CSSTokenType.SLASH));
        punctuatorsRule.add('=', this.createToken(CSSTokenType.EQUAL));
        punctuatorsRule.add('-', this.createToken(CSSTokenType.MINUS));
        punctuatorsRule.add('~', this.createToken(CSSTokenType.WAVY));
        return punctuatorsRule;
    }

    protected List<IRule> createRules() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        rules.add((IRule)new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        rules.add((IRule)new MultiLineRule("/*", "*/", this.createToken(CSSTokenType.COMMENT), '\u0000', true));
        rules.add((IRule)new EndOfLineRule("//", this.createToken(CSSTokenType.COMMENT)));
        rules.add((IRule)new SingleLineRule("expression(", ")", this.createToken(CSSTokenType.IE_EXPRESSION), '\u0000', true));
        rules.addAll(this.createStringRules());
        rules.add((IRule)this.createAtWordsRule());
        rules.addAll(this.createUnitRules());
        rules.add((IRule)new CSSNumberRule(this.createToken(CSSTokenType.NUMBER)));
        rules.add((IRule)new CSSHexColorRule(this.createToken(CSSTokenType.RGB)));
        rules.add((IRule)new WordRule((IWordDetector)new IdentifierWithPrefixDetector('.'), this.createToken(CSSTokenType.CLASS)));
        rules.add((IRule)new WordRule((IWordDetector)new IdentifierWithPrefixDetector('#'), this.createToken(CSSTokenType.ID)));
        rules.add((IRule)new WordRule((IWordDetector)new IdentifierWithPrefixDetector('!'), this.createToken(CSSTokenType.IMPORTANT)));
        rules.add((IRule)new CSSURLRule(this.createToken(CSSTokenType.URL)));
        rules.add((IRule)new CSSFunctionRule(this.createToken(CSSTokenType.FUNCTION)));
        rules.add((IRule)new CSSIdentifierRule(this.createToken(CSSTokenType.IDENTIFIER)));
        WordRule punctuatorRule2 = new WordRule((IWordDetector)new EqualOperatorWordDetector(), Token.UNDEFINED);
        punctuatorRule2.addWord("~=", this.createToken(CSSTokenType.INCLUDES));
        punctuatorRule2.addWord("|=", this.createToken(CSSTokenType.DASHMATCH));
        punctuatorRule2.addWord("^=", this.createToken(CSSTokenType.BEGINS_WITH));
        punctuatorRule2.addWord("$=", this.createToken(CSSTokenType.ENDS_WITH));
        punctuatorRule2.addWord("*=", this.createToken(CSSTokenType.CONTAINS));
        rules.add((IRule)punctuatorRule2);
        rules.add((IRule)this.createPunctuatorsRule());
        return rules;
    }

    private List<IRule> createStringRules() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        rules.add((IRule)new SingleLineRule("\"", "\"", this.createToken(CSSTokenType.DOUBLE_QUOTED_STRING), '\\'));
        rules.add((IRule)new SingleLineRule("'", "'", this.createToken(CSSTokenType.SINGLE_QUOTED_STRING), '\\'));
        return rules;
    }

    protected IToken createToken(CSSTokenType type) {
        return new Token((Object)type);
    }

    private IRule createUnitRule(final String regex, CSSTokenType tokenType) {
        return new ExtendedWordRule(new IWordDetector(){

            public boolean isWordPart(char c) {
                return c == '.' || c == '%' || Character.isLetterOrDigit(c);
            }

            public boolean isWordStart(char c) {
                return c == '-' || c == '+' || c == '.' || Character.isDigit(c);
            }
        }, this.createToken(tokenType), true){
            private Pattern pattern;

            protected boolean wordOK(String word, ICharacterScanner scanner) {
                if (this.pattern == null) {
                    this.pattern = Pattern.compile("[-+]?([0-9]+(\\.[0-9]+)?|\\.[0-9]+)(" + regex + ")", 2);
                }
                return this.pattern.matcher(word).matches();
            }
        };
    }

    protected List<IRule> createUnitRules() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        rules.add(this.createUnitRule("em", CSSTokenType.EMS));
        rules.add(this.createUnitRule("px|cm|mm|in|pt|pc", CSSTokenType.LENGTH));
        rules.add(this.createUnitRule("%", CSSTokenType.PERCENTAGE));
        rules.add(this.createUnitRule("deg|rad|grad", CSSTokenType.ANGLE));
        rules.add(this.createUnitRule("ex", CSSTokenType.EXS));
        rules.add(this.createUnitRule("k?[Hh]z", CSSTokenType.FREQUENCY));
        rules.add(this.createUnitRule("m?s", CSSTokenType.TIME));
        return rules;
    }

    private boolean isOutsideRule() {
        return this._curlyBraceCount < (this._inMediaRule ? 2 : 1);
    }

    public IToken nextToken() {
        IToken token = super.nextToken();
        Object data = token.getData();
        if (data instanceof CSSTokenType) {
            switch ((CSSTokenType)((Object)data)) {
                case MEDIA_KEYWORD: {
                    this._inMediaRule = true;
                    break;
                }
                case LCURLY: {
                    ++this._curlyBraceCount;
                    break;
                }
                case RCURLY: {
                    --this._curlyBraceCount;
                    if (this._curlyBraceCount != 0 || !this._inMediaRule) break;
                    this._inMediaRule = false;
                    break;
                }
                case RGB: {
                    if (!this.isOutsideRule()) break;
                    token = this.createToken(CSSTokenType.ID);
                    break;
                }
                case CLASS: {
                    if (this.isOutsideRule()) break;
                    try {
                        String text = this.fDocument.get(this.getTokenOffset(), this.getTokenLength());
                        if (!CLASS_IS_NUMBER_PATTERN.matcher(text).matches()) break;
                        token = this.createToken(CSSTokenType.NUMBER);
                        break;
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
        }
        return token;
    }

    public void setRange(IDocument document, int offset, int length) {
        super.setRange(document, offset, length);
        this._inMediaRule = false;
        this._curlyBraceCount = 0;
    }
}

