/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.parsing;

import beaver.Parser;
import beaver.ParsingTables;
import beaver.Scanner;
import beaver.Symbol;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.css.parsing.CSSFlexScanner;
import com.aptana.editor.css.parsing.ast.CSSArgNode;
import com.aptana.editor.css.parsing.ast.CSSAtRuleNode;
import com.aptana.editor.css.parsing.ast.CSSAttributeSelectorNode;
import com.aptana.editor.css.parsing.ast.CSSCharSetNode;
import com.aptana.editor.css.parsing.ast.CSSCommentNode;
import com.aptana.editor.css.parsing.ast.CSSDeclarationNode;
import com.aptana.editor.css.parsing.ast.CSSErrorExpressionNode;
import com.aptana.editor.css.parsing.ast.CSSExpressionNode;
import com.aptana.editor.css.parsing.ast.CSSFontFaceNode;
import com.aptana.editor.css.parsing.ast.CSSFunctionNode;
import com.aptana.editor.css.parsing.ast.CSSIEExpressionNode;
import com.aptana.editor.css.parsing.ast.CSSImportNode;
import com.aptana.editor.css.parsing.ast.CSSInvokeNode;
import com.aptana.editor.css.parsing.ast.CSSKeyFramesNode;
import com.aptana.editor.css.parsing.ast.CSSKeyFramesRuleBodyNode;
import com.aptana.editor.css.parsing.ast.CSSKeyFramesStatementNode;
import com.aptana.editor.css.parsing.ast.CSSList;
import com.aptana.editor.css.parsing.ast.CSSMediaBodyNode;
import com.aptana.editor.css.parsing.ast.CSSMediaExpressNode;
import com.aptana.editor.css.parsing.ast.CSSMediaNode;
import com.aptana.editor.css.parsing.ast.CSSMediaQueryNode;
import com.aptana.editor.css.parsing.ast.CSSMozDocument;
import com.aptana.editor.css.parsing.ast.CSSNamespaceNode;
import com.aptana.editor.css.parsing.ast.CSSNode;
import com.aptana.editor.css.parsing.ast.CSSPageNode;
import com.aptana.editor.css.parsing.ast.CSSPageRuleBodyNode;
import com.aptana.editor.css.parsing.ast.CSSPageSelectorNode;
import com.aptana.editor.css.parsing.ast.CSSPageSubRuleNode;
import com.aptana.editor.css.parsing.ast.CSSParseRootNode;
import com.aptana.editor.css.parsing.ast.CSSRuleBodyNode;
import com.aptana.editor.css.parsing.ast.CSSRuleNode;
import com.aptana.editor.css.parsing.ast.CSSSelectorNode;
import com.aptana.editor.css.parsing.ast.CSSSimpleSelectorNode;
import com.aptana.editor.css.parsing.ast.CSSStringNode;
import com.aptana.editor.css.parsing.ast.CSSSupportNode;
import com.aptana.editor.css.parsing.ast.CSSSupportsConditionInParensNode;
import com.aptana.editor.css.parsing.ast.CSSSupportsNegationNode;
import com.aptana.editor.css.parsing.ast.CSSSupportsRuleBodyNode;
import com.aptana.editor.css.parsing.ast.CSSTermListNode;
import com.aptana.editor.css.parsing.ast.CSSTermNode;
import com.aptana.editor.css.parsing.ast.CSSTerminalNode;
import com.aptana.editor.css.parsing.ast.CSSTextNode;
import com.aptana.editor.css.parsing.ast.CSSURLNode;
import com.aptana.editor.css.parsing.ast.CSSUnkownArgNode;
import com.aptana.editor.css.parsing.ast.CSSViewportNode;
import com.aptana.editor.css.parsing.ast.KeyFramesSelectorNode;
import com.aptana.editor.css.parsing.lexer.CSSTokenType;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.IParser;
import com.aptana.parsing.IRecoveryStrategy;
import com.aptana.parsing.InsertionRecoveryStrategy;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.WorkingParseResult;
import com.aptana.parsing.ast.IParseError;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.ast.ParseError;
import com.aptana.parsing.ast.ParseRootNode;
import com.aptana.parsing.lexer.ITypePredicate;
import com.aptana.parsing.util.ParseUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CSSParser
extends Parser
implements IParser {
    static final ParsingTables PARSING_TABLES = new ParsingTables("U9ojM0TyL4KJdxrtCPAWS0eYBGc4c8Ig8A0q4P4YJOea9g4992AH5WD81wLta2PsiM750YeM51IxOWD1504RwYTMiCxtttbpkNV9EyJoxZUtExip$obRtoEAIw7Ur8cgq6bq8NMWM#Wp#jJKfXrq0zr8Dz7Pw0jH4#axXUfJUwf3$QavdKFdKX$yqgawNKhrg04rf4Pq9fr5ZQafDQDkr9LEfqjCVRgBUj3Tr8AwK7UQI9De2asbc#bp#eAcqHnQG4leEXfBusWyNKqJQ39TIpDf5iscrRI6hgUrua4rzI19F9XlJbSFUj5vb6wgceenFEXeJZ9TORi7jQLAue55Q##YcMg2jjXKST5CPNCQq2gPSZ7GaYHJAK2pleJHQgXlDGLjERTGtxQR2v2TvsbB3BJQWbQh5DgLYjPAq5RHvM4qSEdqEhqQ0wqA3QIML1LeIJIY1AslYyRB1StQqv7ZPK3BfkGOQ5PoE#K2RGml5RIZ5WzvTxtBiNYc0lBkuks4$NJwXdR7mFkLzj13z1xmDg2qU1lKHXPzII$HQ7hBjA6VwJSgD2aKJ$jCCYMP4#bZEf7AKG8bqabqCXMRRgObxQSWnT49L9ugq7fZw2gw1pW13quD#f4AOJFU14qSFMDEDAsZS6gORlGzLuxWy0k8mFNdsmWERwEtWJFK#aD3Q0zmo8jZJY47wyJhZyrvlkRe2ibvQngcEVgJXYD7J4K#ETfEnHx$Zz9qs5qFkuZDN0IxxQFydq4E$qdRF7QBgIFLfKpCz8le6igW5w0zLpApaDAO8HlkFmEo6RGKkNwHNgOLfeN8tYcMQj8XSnvzPqwWowWYdMhQKO6fJlVIO97T3jdsheyqigoiQGXP6$$zEkUMoXn9CerqTRKrTH7$0$IWJ$nMxmdDssR9szEcdkRjMPC9lUTyysRrYbJl5T4hejVKNbt4d6ww86P$lLsgzw7uMO$ULtjxwHFO#veEnj3xGVL#4dixJ43rZj0lqDjXultrJABkEWbYBsHETVNuESoXT5C3Uww$NYtLInUz5FvKzGv28zqqG7xzzHhhE7nYzNYVEL$rFkQFA9ttyeV#Uhn7uoE9ppvkFbkXbYvyMRt8$BfOvbTFIFqFj9DIPNwHpCMmJ3lm6NI1hBWzg1#G#KMON$Pvd9waftpcuZRCBtUD4cpOUJYA3gF#1xqZDlQ9ZSxI7rbBnU0AQR$fB3RQm4Pupo0V6zjX8wAxKtJ9D16$2FiHcRDDKzFCD3Vdc7CHjVN#FTD1FB9FLNCczb$x#4IDSyP6JNBEx3ILh4Ucl1krEOlo4674es9Wvneo5mhQDWzUCRWSQ7IIdcBfELzwR8GbSiOHFHOfs#DwIFIxcsqV3o#MSUafKZRJyqGoqlkkz5P5fcsCYtprzeEMUNgsbVHONrTYTDv4pHqzwq6khmTzKERWNl41F2YBrOyk0TP7YbfPV8r44pt#f6FOKRCGsIUj9VBmQSV1tqgtqUsqZkwWXy5lGou8kRXFOej6ZlX3a8pkWxzOkuFWpqxqsT5F5JzpGVkazWWzIe$HHjgawoD7Ch8V6N5dOaCTpQserzUCh3SPQc#0iRkyrNZ3QfWw8blY3#QXQCWy9Cn3eg$CoPB5gCUabLJtKUndFncSlacuIzZJA1xte2ISYoaub#nPPVk2Ub8bwocMhNtv#8LmFWx3tQmoxfzLS6EiYhjUTPpW5gKOzy8Ct11I4KKEJgvqx3JkNcjdGq#ShMrm$skBsTyEwwgzx5eT4KLdvBaBRXtTSC$e8HwagGUEUZ1PFSX2FIGtJdyFiZ2NhUrKr8FYWKKhfsZJ5CqeccqBeMr133H7j9S2pKg6qSA#vIkQesXvM2qX6e1xdJzQl6Wdb48hB1Lfi0Ijt37HxFYj0a8gD1ULe9aeDDiI7Zb7HYuX1fgLpCFOfSAYesYsRRBYDHKyc$VmE2G1BmKtM7#y5Do33MvKgT0tWXTK6sbu6x5H3S8UtWJtew5ukoZ0ZGXt9DotMk8#FO96OgyPJMFaFXK4NlXTOo9s$JfugpaLEDCzE6cmE1Gs2#Gzf3PmagDmqe2p7Eyc4Ho325n$l3X6$CaMVv8HmN14uCL90avAb3yM8rbpbAqZcAmvceDQYER3HjaSvI4shrq7TYl2heqj2NPJekpQym$BssCt7lvdoqpFXSL#yBSYCAosWvilINpX$dZqEyXrBMJ6GVwiR9R8riNDe7xKtS3WHf65UAni7cJBbVXOLhO8iZR#nL5pRah9Jd8DyXx2cilqYT$gPQfUfkXbuWtArNDaZIVuviqTCw#zF4YwUcdmF2Gn##l5grwMwBKg6IUx0uRmLfiSGs#MwiqMlHIiM5Ul2NuXuVtrKbHleUWLbknXAVY5m3inz8fKBq7qffRiBuwiuI9e##ibgbwYw2LYHRbwYVY5vF#OUdZhW1xZKRrar4B2##b5pw$#a4e4PU7T0$CBDJk$IcJ0GqQiNOxw5NP#eQpZiUO$5sMy8HElyz3QICGznyxX2c9ZhlH7rb8ykA4OqGAPmwinXtNFG7jP6tcm4T7DihgW0fQ7XeEYrw7h$GhhaKZO7SEHca$Kw7Kp4vvrrgD4ZNeDvflnU1IF$IO3s8cA6y6pvqPJDx#I2HlxNEcnU16vEQ8tNwHiJxn6SPrcE#QugCK0nixgHVnFr56hO6D4hvzUpUYUSCpgws2xFb5pCsmzp$2T6Vaec#9yiXwKpP#zLm1BKIU9hv5eeiPV97GCewEnbcI6Xj67$3NlkR#aWiUP20c7CYMsw1XA$C7$a59zrby7usrZ6o8U9iX$XXqLgVN2RQuFxeHzTOOrbOpKf64QSv7EjmJLiXcfYBtMjJS9UssyQ2HO3PediX5$Z6heAXUDHEiLHpskL#vivfWFl2BJVPfxuzmDEcphVvVmb0VOJreVIUIi0tzG#N1fxygzG1D0IxNj1oqVTSk0lIsVfFMs$yGNnLiNetsxnhfE#JvgAyz7rhv37u5i#N$emzVGhUg#AnhxvjaRX2upFo8Jl05$so9ye3pwYzJ7EOhp2kfBj6s5BP7RGoxlu2tP#Lhxke4sXx7iw1w$h#P54B3CtXZzNy2tyQY4vyfNuAz3fLZvdy4$XCeDolyA$ZLKjXwV$U20s7s1Z4ZTQGdPSMgZCVfEFZxyG3KjaxIifMLNuAr5sKdzUCTVtoc0p43qDq3PJsKFbChH36qlfzX3jCHzBu3yaOwP$P8HGDK9edwAoWpt#5fuZ3pPTyQW#fIYPI$53O6wQ5tdUM2KbgErlONgzF79qHIVjbcgrmprvQhxYFfon1Fx5BUagR5yLxoRGRUex0ceLz3sBOgvoItZ0jh#ifOTj7mNj0lqGGJJMQjz#xGy2FeSXFKN#0RqBUWmw7VuYVqdy6D4DzXRTPvLdp2dpGPWRbNijwBzfyrUNji#WKxciU8#7i9otG9x1ppy9azzezfg7SvTj0#1LyFx2igr$zONdnYxgPszqUrEzdzjosDpUUo#O64qRvgNbJ6zVJ1pj6yJOlbDsnu4dnkMGQvt$RTnEFV0tsGF$pZuT0$$0lX67lvjy6NYySSswuzJ3ZRDQgrl$6$YeXuU$2F#CW57PSTwsX9AoRolCg#KrNSE8HTTLIv3suwYBUVl#HgSQSyazJLEow5gr#uL8RLHoL$V6QmwzNnYREBJrjAMc4lOSm9rjVwXsbljaTFpDD3chsC8z5KVx3dxahRbQNpvwcVJKZfPfNZFEUFyupqBkhiLJyyLEatR4zMVn59sAqVpfhkhnd$mR$mh$y97#GZ$p3$nZ$m3Vy$VyM7f$LQbFW2zpM$X$qqGzZf#6VIIz6q7JUHnF9QB#IfkmFMv7jVbJCxWT3w3qxWEft9jhiKfd0n9xE#y1BGOj8WNy7nkgJREvOKyWPjnKpwRct1Zlfh7yulSWd7xuZT0h$Dh8hUJTqYvYz#NSXteTgdT1heLX3iT5$5e7i4ZkO27WXl2W$ao7iG3UG3tvtwSnxbgDOSlvMpEuhxANw9b7orxQzcBU$B5t8ExSpVkobtu8hHrvaxSaJlmXNm1j#TsVBv8jfN$y$WSRixLkHfNvTEv2kFUm6r0hK6j5BCGD9oJk2RNu7o#Kbkl00tZotaKokj1QtWEp#Ph#5gUnLX5F9MdyGoUpbDu4a$cUJoNp#8pkH4tvBMY$nu8fpI$8znZe4VuGTx03p3cBTyFke$lvNluRhwJx#Br$2W$ZBOxH7ehQ0leMNu6$q#1DlCJ$3Xluety93yjChlb7tTpnldENu9mjsAiOVvC8pZ4k9to0T1#AlFmBNmpZ#7dKVj6MrQ3Rk9LV2FAbRp2hbawHDVZdGhnqtIyxqsNhtP$ZyRXBN6qqXGXWpSx#qN8abD2Kz5kQGRQxNVJDQZ7eWcG6Kz19KVeIj0Ij2z1EKd8uFtGaWCAW8B23mC$36K#skmNv7oyGIu5FrPfb7opDRG0j10o2y4lGxaC$BKePuAVYVhaKZG2xIFGlnpbSl2pKNV92CsIhsuERbO1aA4vIlF1pqSv4kNLw7SfA3G6zJ5eNo5ag01b0Sf2#SRkq4J8J8J$Ar5VYVPBqPw3CaohmAz2tseXGtELvWa5b1oycriAWW8We$KuRG$8Ts#NxFSK1sHB8vHRYeRATrz3bq76VWKUX7AGb9RYb89A3Wr0$m3qvGa5ZfFYOhHvwQym71yAU4gZzRWecMpzpcvfcj8G7rfKYlhz2nheeSKngF$$0JeSn3e=");
    private WorkingParseResult fWorking;
    private final List<IRecoveryStrategy> recoveryStrategies;

    public synchronized ParseResult parse(IParseState parseState) throws Exception {
        WorkingParseResult working = new WorkingParseResult();
        this.parse(parseState, working);
        return working.getImmutableResult();
    }

    protected void recoverFromError(Symbol token, Parser.TokenStream in) throws IOException, Parser.Exception {
        boolean success = false;
        if (this.recoveryStrategies != null) {
            for (IRecoveryStrategy strategy : this.recoveryStrategies) {
                if (!strategy.recover((IParser)this, this.getLastSymbol(), token, in, this.report)) continue;
                success = true;
                break;
            }
        }
        if (!success) {
            super.recoverFromError(token, in);
        }
    }

    protected Symbol getLastSymbol() {
        Symbol result = null;
        if (this.top >= 0 && this.top < this._symbols.length) {
            result = this._symbols[this.top];
        }
        return result;
    }

    protected synchronized void parse(IParseState parseState, WorkingParseResult working) throws Exception {
        this.fWorking = working;
        try {
            String source = parseState.getSource();
            CSSFlexScanner scanner = new CSSFlexScanner();
            scanner.setSource(source);
            ParseRootNode result = (ParseRootNode)this.parse(scanner, parseState.getNeedSleep());
            List<Symbol> comments = scanner.getComments();
            ArrayList<CSSCommentNode> commentNodes = new ArrayList<CSSCommentNode>(comments.size());
            for (Symbol comment : comments) {
                CSSCommentNode commentNode = new CSSCommentNode(source.substring(comment.getStart(), comment.getEnd() + 1), comment.getStart(), comment.getEnd());
                commentNodes.add(commentNode);
            }
            result.setCommentNodes(commentNodes.toArray(new IParseNode[commentNodes.size()]));
            int start = parseState.getStartingOffset();
            int length = source.length();
            result.setLocation(0, length - 1);
            if (start != 0) {
                ParseUtil.addOffset((IParseNode)result, (int)start, (boolean)parseState.getNeedSleep());
            }
            this.fWorking.setParseResult((IParseRootNode)result);
            EditorUtil.flexScannerYYclose((Object)((Object)scanner));
        }
        finally {
            this.fWorking = null;
        }
    }

    public CSSParser() {
        super(PARSING_TABLES);
        this.report = new CSSEvents();
        this.recoveryStrategies = new ArrayList<IRecoveryStrategy>();
        this.recoveryStrategies.add((IRecoveryStrategy)new InsertionRecoveryStrategy((ITypePredicate)CSSTokenType.SEMICOLON, ";", (ITypePredicate[])new CSSTokenType[0]));
        this.recoveryStrategies.add((IRecoveryStrategy)new InsertionRecoveryStrategy((ITypePredicate)CSSTokenType.IDENTIFIER, "", (ITypePredicate[])new CSSTokenType[0]));
        this.recoveryStrategies.add((IRecoveryStrategy)new InsertionRecoveryStrategy((ITypePredicate)CSSTokenType.LCURLY, "{", (ITypePredicate)CSSTokenType.RCURLY, "}", (ITypePredicate[])new CSSTokenType[0]));
        this.recoveryStrategies.add((IRecoveryStrategy)new InsertionRecoveryStrategy((ITypePredicate)CSSTokenType.LPAREN, "(", (ITypePredicate)CSSTokenType.RPAREN, ")", (ITypePredicate[])new CSSTokenType[]{CSSTokenType.MEDIA_AND}));
        this.recoveryStrategies.add((IRecoveryStrategy)new InsertionRecoveryStrategy((ITypePredicate)CSSTokenType.DOUBLE_QUOTED_STRING, "", (ITypePredicate[])new CSSTokenType[]{CSSTokenType.CHARSET, CSSTokenType.NAMESPACE, CSSTokenType.IMPORT}));
        this.recoveryStrategies.add((IRecoveryStrategy)new InsertionRecoveryStrategy((ITypePredicate)CSSTokenType.DOUBLE_QUOTED_STRING, "", (ITypePredicate)CSSTokenType.SEMICOLON, ";", (ITypePredicate[])new CSSTokenType[]{CSSTokenType.CHARSET, CSSTokenType.NAMESPACE, CSSTokenType.IMPORT}));
    }

    protected Symbol invokeReduceAction(int rule_num, int offset) {
        switch (rule_num) {
            case 0: {
                Symbol _symbol_p = this._symbols[offset + 1];
                ArrayList _list_p = (ArrayList)_symbol_p.value;
                CSSNode[] p = _list_p == null ? new CSSNode[]{} : _list_p.toArray(new CSSNode[_list_p.size()]);
                return new CSSParseRootNode((Symbol[])p);
            }
            case 1: {
                return new CSSParseRootNode();
            }
            case 2: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 3: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 16: {
                Symbol c = this._symbols[offset + 1];
                Symbol s = this._symbols[offset + 2];
                CSSTerminalNode terminal = new CSSTerminalNode(c);
                CSSStringNode node = new CSSStringNode(s);
                return new CSSCharSetNode(terminal, node);
            }
            case 17: {
                Symbol s = this._symbols[offset + 1];
                Symbol _symbol_l = this._symbols[offset + 2];
                ArrayList _list_l = (ArrayList)_symbol_l.value;
                CSSNode[] l = _list_l == null ? new CSSNode[]{} : _list_l.toArray(new CSSNode[_list_l.size()]);
                Symbol _symbol_b = this._symbols[offset + 3];
                CSSNode b = (CSSNode)((Object)_symbol_b.value);
                CSSTerminalNode terminal = new CSSTerminalNode(s);
                return new CSSSupportNode(terminal, b, l);
            }
            case 18: {
                Symbol s = this._symbols[offset + 1];
                Symbol _symbol_n = this._symbols[offset + 2];
                CSSNode n = (CSSNode)((Object)_symbol_n.value);
                Symbol _symbol_b = this._symbols[offset + 3];
                CSSNode b = (CSSNode)((Object)_symbol_b.value);
                CSSTerminalNode terminal = new CSSTerminalNode(s);
                return new CSSSupportNode(terminal, b, n);
            }
            case 19: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 3].value);
                return this._symbols[offset + 1];
            }
            case 20: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 21: {
                Symbol _symbol_s = this._symbols[offset + 2];
                CSSNode s = (CSSNode)((Object)_symbol_s.value);
                return new CSSSupportsNegationNode(s);
            }
            case 22: {
                return new CSSSupportsConditionInParensNode(new CSSNode[0]);
            }
            case 23: {
                Symbol _symbol_d = this._symbols[offset + 2];
                List d = (List)_symbol_d.value;
                return new CSSSupportsConditionInParensNode(d.toArray(new CSSNode[0]));
            }
            case 24: {
                Symbol _symbol_n = this._symbols[offset + 2];
                CSSNode n = (CSSNode)((Object)_symbol_n.value);
                return new CSSSupportsConditionInParensNode(n);
            }
            case 25: {
                Symbol _symbol_l = this._symbols[offset + 2];
                ArrayList _list_l = (ArrayList)_symbol_l.value;
                CSSNode[] l = _list_l == null ? new CSSNode[]{} : _list_l.toArray(new CSSNode[_list_l.size()]);
                return new CSSSupportsConditionInParensNode(l);
            }
            case 28: {
                return new CSSSupportsRuleBodyNode(new CSSNode[0]);
            }
            case 29: {
                Symbol _symbol_r = this._symbols[offset + 2];
                CSSNode r = (CSSNode)((Object)_symbol_r.value);
                return new CSSSupportsRuleBodyNode(r);
            }
            case 37: {
                Symbol v = this._symbols[offset + 1];
                Symbol _symbol_b = this._symbols[offset + 2];
                CSSRuleBodyNode b = (CSSRuleBodyNode)((Object)_symbol_b.value);
                CSSTerminalNode terminal = new CSSTerminalNode(v);
                return new CSSViewportNode(terminal, b);
            }
            case 38: {
                Symbol i = this._symbols[offset + 1];
                Symbol s = this._symbols[offset + 2];
                Symbol _symbol_m = this._symbols[offset + 3];
                ArrayList _list_m = (ArrayList)_symbol_m.value;
                CSSNode[] m = _list_m == null ? new CSSNode[]{} : _list_m.toArray(new CSSNode[_list_m.size()]);
                CSSTerminalNode terminal = new CSSTerminalNode(i);
                CSSStringNode node = new CSSStringNode(s);
                return new CSSImportNode(terminal, node, m);
            }
            case 39: {
                Symbol i = this._symbols[offset + 1];
                Symbol _symbol_s = this._symbols[offset + 2];
                CSSURLNode s = (CSSURLNode)((Object)_symbol_s.value);
                Symbol _symbol_m = this._symbols[offset + 3];
                ArrayList _list_m = (ArrayList)_symbol_m.value;
                CSSNode[] m = _list_m == null ? new CSSNode[]{} : _list_m.toArray(new CSSNode[_list_m.size()]);
                CSSTerminalNode terminal = new CSSTerminalNode(i);
                return new CSSImportNode(terminal, s, m);
            }
            case 40: {
                Symbol i = this._symbols[offset + 1];
                Symbol s = this._symbols[offset + 2];
                CSSTerminalNode terminal = new CSSTerminalNode(i);
                CSSStringNode node = new CSSStringNode(s);
                return new CSSImportNode(terminal, node, new CSSNode[0]);
            }
            case 41: {
                Symbol i = this._symbols[offset + 1];
                Symbol _symbol_s = this._symbols[offset + 2];
                CSSURLNode s = (CSSURLNode)((Object)_symbol_s.value);
                CSSTerminalNode terminal = new CSSTerminalNode(i);
                return new CSSImportNode(terminal, s, new CSSNode[0]);
            }
            case 42: {
                Symbol k = this._symbols[offset + 1];
                Symbol _symbol_m = this._symbols[offset + 2];
                ArrayList _list_m = (ArrayList)_symbol_m.value;
                CSSNode[] m = _list_m == null ? new CSSNode[]{} : _list_m.toArray(new CSSNode[_list_m.size()]);
                Symbol _symbol_b = this._symbols[offset + 3];
                CSSNode b = (CSSNode)((Object)_symbol_b.value);
                CSSTerminalNode node = new CSSTerminalNode(k);
                return new CSSMediaNode(node, b, m);
            }
            case 43: {
                return new CSSMediaBodyNode(new CSSNode[0]);
            }
            case 44: {
                Symbol _symbol_s = this._symbols[offset + 2];
                ArrayList _list_s = (ArrayList)_symbol_s.value;
                CSSNode[] s = _list_s == null ? new CSSNode[]{} : _list_s.toArray(new CSSNode[_list_s.size()]);
                return new CSSMediaBodyNode(s);
            }
            case 45: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 3].value);
                return this._symbols[offset + 1];
            }
            case 46: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 47: {
                Symbol m = this._symbols[offset + 1];
                CSSTerminalNode node = new CSSTerminalNode(m);
                return new CSSMediaQueryNode(node);
            }
            case 48: {
                Symbol m = this._symbols[offset + 1];
                Symbol a = this._symbols[offset + 2];
                Symbol _symbol_l = this._symbols[offset + 3];
                ArrayList _list_l = (ArrayList)_symbol_l.value;
                CSSNode[] l = _list_l == null ? new CSSNode[]{} : _list_l.toArray(new CSSNode[_list_l.size()]);
                ArrayList<CSSNode> children = new ArrayList<CSSNode>();
                children.add(new CSSTerminalNode(m));
                children.add(new CSSTerminalNode(a));
                CSSNode[] cSSNodeArray = l;
                int n = l.length;
                int n2 = 0;
                while (n2 < n) {
                    CSSNode child = cSSNodeArray[n2];
                    children.add(child);
                    ++n2;
                }
                return new CSSMediaQueryNode(children.toArray(new CSSNode[0]));
            }
            case 49: {
                Symbol _symbol_k = this._symbols[offset + 1];
                CSSNode k = (CSSNode)((Object)_symbol_k.value);
                Symbol m = this._symbols[offset + 2];
                CSSTerminalNode node = new CSSTerminalNode(m);
                return new CSSMediaQueryNode(k, node);
            }
            case 50: {
                Symbol _symbol_k = this._symbols[offset + 1];
                CSSNode k = (CSSNode)((Object)_symbol_k.value);
                Symbol m = this._symbols[offset + 2];
                Symbol a = this._symbols[offset + 3];
                Symbol _symbol_l = this._symbols[offset + 4];
                ArrayList _list_l = (ArrayList)_symbol_l.value;
                CSSNode[] l = _list_l == null ? new CSSNode[]{} : _list_l.toArray(new CSSNode[_list_l.size()]);
                ArrayList<CSSNode> children = new ArrayList<CSSNode>();
                children.add(k);
                children.add(new CSSTerminalNode(m));
                children.add(new CSSTerminalNode(a));
                CSSNode[] cSSNodeArray = l;
                int n = l.length;
                int n3 = 0;
                while (n3 < n) {
                    CSSNode child = cSSNodeArray[n3];
                    children.add(child);
                    ++n3;
                }
                return new CSSMediaQueryNode(children.toArray(new CSSNode[0]));
            }
            case 51: {
                Symbol _symbol_l = this._symbols[offset + 1];
                ArrayList _list_l = (ArrayList)_symbol_l.value;
                CSSNode[] l = _list_l == null ? new CSSNode[]{} : _list_l.toArray(new CSSNode[_list_l.size()]);
                return new CSSMediaQueryNode(l);
            }
            case 52: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 3].value);
                return this._symbols[offset + 1];
            }
            case 53: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 54: {
                return new CSSMediaExpressNode();
            }
            case 55: {
                Symbol _symbol_m = this._symbols[offset + 2];
                CSSNode m = (CSSNode)((Object)_symbol_m.value);
                return new CSSMediaExpressNode(m);
            }
            case 56: {
                Symbol _symbol_m = this._symbols[offset + 2];
                CSSNode m = (CSSNode)((Object)_symbol_m.value);
                Symbol _symbol_e = this._symbols[offset + 4];
                CSSExpressionNode e = (CSSExpressionNode)((Object)_symbol_e.value);
                return new CSSMediaExpressNode(m, e);
            }
            case 57: {
                Symbol i = this._symbols[offset + 1];
                return new CSSTerminalNode(i);
            }
            case 58: {
                Symbol o = this._symbols[offset + 1];
                return new CSSTerminalNode(o);
            }
            case 59: {
                Symbol n = this._symbols[offset + 1];
                return new CSSTerminalNode(n);
            }
            case 60: {
                Symbol k = this._symbols[offset + 1];
                Symbol _symbol_m = this._symbols[offset + 2];
                CSSNode m = (CSSNode)((Object)_symbol_m.value);
                Symbol _symbol_b = this._symbols[offset + 3];
                CSSNode b = (CSSNode)((Object)_symbol_b.value);
                return new CSSKeyFramesNode(k, m, b);
            }
            case 62: {
                Symbol _symbol_s = this._symbols[offset + 1];
                String s = (String)_symbol_s.value;
                return new CSSTextNode(s);
            }
            case 63: {
                return new CSSKeyFramesRuleBodyNode(new CSSNode[0]);
            }
            case 64: {
                Symbol _symbol_s = this._symbols[offset + 2];
                ArrayList _list_s = (ArrayList)_symbol_s.value;
                CSSNode[] s = _list_s == null ? new CSSNode[]{} : _list_s.toArray(new CSSNode[_list_s.size()]);
                return new CSSKeyFramesRuleBodyNode(s);
            }
            case 65: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 66: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 67: {
                Symbol _symbol_l = this._symbols[offset + 1];
                ArrayList _list_l = (ArrayList)_symbol_l.value;
                CSSNode[] l = _list_l == null ? new CSSNode[]{} : _list_l.toArray(new CSSNode[_list_l.size()]);
                Symbol _symbol_b = this._symbols[offset + 2];
                CSSRuleBodyNode b = (CSSRuleBodyNode)((Object)_symbol_b.value);
                return new CSSKeyFramesStatementNode(b, l);
            }
            case 68: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 3].value);
                return this._symbols[offset + 1];
            }
            case 69: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 70: {
                Symbol p = this._symbols[offset + 1];
                return new KeyFramesSelectorNode(p);
            }
            case 71: {
                Symbol f = this._symbols[offset + 1];
                return new KeyFramesSelectorNode(f);
            }
            case 72: {
                Symbol t = this._symbols[offset + 1];
                return new KeyFramesSelectorNode(t);
            }
            case 73: {
                Symbol i = this._symbols[offset + 1];
                return new KeyFramesSelectorNode(i);
            }
            case 74: {
                Symbol _symbol_l = this._symbols[offset + 2];
                ArrayList _list_l = (ArrayList)_symbol_l.value;
                CSSNode[] l = _list_l == null ? new CSSNode[]{} : _list_l.toArray(new CSSNode[_list_l.size()]);
                Symbol _symbol_b = this._symbols[offset + 3];
                CSSNode b = (CSSNode)((Object)_symbol_b.value);
                return new CSSPageNode(b, l);
            }
            case 75: {
                Symbol _symbol_b = this._symbols[offset + 2];
                CSSNode b = (CSSNode)((Object)_symbol_b.value);
                return new CSSPageNode(b, new CSSNode[0]);
            }
            case 76: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 3].value);
                return this._symbols[offset + 1];
            }
            case 77: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 78: {
                Symbol p1 = this._symbols[offset + 1];
                Symbol p2 = this._symbols[offset + 2];
                CSSTerminalNode node1 = new CSSTerminalNode(p1);
                CSSTerminalNode node2 = new CSSTerminalNode(p2);
                return new CSSPageSelectorNode(node1, node2);
            }
            case 79: {
                Symbol i = this._symbols[offset + 1];
                Symbol p = this._symbols[offset + 2];
                CSSTerminalNode node1 = new CSSTerminalNode(i);
                CSSTerminalNode node2 = new CSSTerminalNode(p);
                return new CSSPageSelectorNode(node1, node2);
            }
            case 80: {
                Symbol p = this._symbols[offset + 1];
                CSSTerminalNode node = new CSSTerminalNode(p);
                return new CSSPageSelectorNode(node);
            }
            case 81: {
                Symbol i = this._symbols[offset + 1];
                CSSTerminalNode node = new CSSTerminalNode(i);
                return new CSSPageSelectorNode(node);
            }
            case 82: {
                return new CSSPageRuleBodyNode(new CSSNode[0]);
            }
            case 83: {
                Symbol _symbol_l = this._symbols[offset + 2];
                ArrayList _list_l = (ArrayList)_symbol_l.value;
                CSSNode[] l = _list_l == null ? new CSSNode[]{} : _list_l.toArray(new CSSNode[_list_l.size()]);
                return new CSSPageRuleBodyNode(l);
            }
            case 84: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 85: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 88: {
                Symbol r = this._symbols[offset + 1];
                Symbol _symbol_b = this._symbols[offset + 2];
                CSSRuleBodyNode b = (CSSRuleBodyNode)((Object)_symbol_b.value);
                CSSTerminalNode node = new CSSTerminalNode(r);
                return new CSSPageSubRuleNode(node, b);
            }
            case 89: {
                Symbol r = this._symbols[offset + 1];
                CSSTerminalNode node = new CSSTerminalNode(r);
                return new CSSPageSubRuleNode(node, null);
            }
            case 90: {
                Symbol _symbol_b = this._symbols[offset + 2];
                CSSRuleBodyNode b = (CSSRuleBodyNode)((Object)_symbol_b.value);
                return new CSSFontFaceNode(b);
            }
            case 91: {
                Symbol s = this._symbols[offset + 2];
                CSSStringNode node = new CSSStringNode(s);
                return new CSSNamespaceNode(node);
            }
            case 92: {
                Symbol _symbol_u = this._symbols[offset + 2];
                CSSURLNode u = (CSSURLNode)((Object)_symbol_u.value);
                return new CSSNamespaceNode(u);
            }
            case 93: {
                Symbol i = this._symbols[offset + 2];
                Symbol s = this._symbols[offset + 3];
                CSSTerminalNode prefix = new CSSTerminalNode(i);
                CSSStringNode urinode = new CSSStringNode(s);
                return new CSSNamespaceNode(prefix, urinode);
            }
            case 94: {
                Symbol i = this._symbols[offset + 2];
                Symbol _symbol_u = this._symbols[offset + 3];
                CSSURLNode u = (CSSURLNode)((Object)_symbol_u.value);
                CSSTerminalNode node = new CSSTerminalNode(i);
                return new CSSNamespaceNode(node, u);
            }
            case 95: {
                Symbol a = this._symbols[offset + 1];
                Symbol s = this._symbols[offset + 2];
                CSSStringNode node = new CSSStringNode(s);
                return new CSSAtRuleNode(a, node);
            }
            case 96: {
                Symbol a = this._symbols[offset + 1];
                return new CSSAtRuleNode(a, null);
            }
            case 97: {
                Symbol _symbol_rs = this._symbols[offset + 1];
                CSSList rs = (CSSList)((Object)_symbol_rs.value);
                Symbol _symbol_r = this._symbols[offset + 2];
                CSSRuleNode r = (CSSRuleNode)((Object)_symbol_r.value);
                rs.addChild((IParseNode)r);
                return rs;
            }
            case 98: {
                Symbol _symbol_r = this._symbols[offset + 1];
                CSSRuleNode r = (CSSRuleNode)((Object)_symbol_r.value);
                CSSList list = new CSSList();
                list.addChild((IParseNode)r);
                return list;
            }
            case 99: {
                Symbol _symbol_s = this._symbols[offset + 1];
                List s = (List)_symbol_s.value;
                Symbol _symbol_b = this._symbols[offset + 2];
                CSSRuleBodyNode b = (CSSRuleBodyNode)((Object)_symbol_b.value);
                CSSRuleNode result = new CSSRuleNode(s, b);
                for (CSSSelectorNode selector : s) {
                    selector.setParent((IParseNode)result);
                }
                return result;
            }
            case 101: {
                return new CSSRuleBodyNode();
            }
            case 102: {
                Symbol _symbol_d = this._symbols[offset + 2];
                List d = (List)_symbol_d.value;
                CSSRuleBodyNode body = new CSSRuleBodyNode(d.toArray(new CSSNode[0]));
                return body;
            }
            case 103: {
                Symbol _symbol_fs = this._symbols[offset + 2];
                CSSList fs = (CSSList)((Object)_symbol_fs.value);
                CSSMozDocument doc = new CSSMozDocument();
                doc.addChild((IParseNode)fs);
                doc.addChild((IParseNode)new CSSList());
                return doc;
            }
            case 104: {
                Symbol _symbol_fs = this._symbols[offset + 2];
                CSSList fs = (CSSList)((Object)_symbol_fs.value);
                Symbol _symbol_rs = this._symbols[offset + 4];
                CSSList rs = (CSSList)((Object)_symbol_rs.value);
                CSSMozDocument doc = new CSSMozDocument();
                doc.addChild((IParseNode)fs);
                doc.addChild((IParseNode)rs);
                return doc;
            }
            case 105: {
                Symbol _symbol_fs = this._symbols[offset + 1];
                CSSList fs = (CSSList)((Object)_symbol_fs.value);
                Symbol _symbol_f = this._symbols[offset + 3];
                CSSExpressionNode f = (CSSExpressionNode)((Object)_symbol_f.value);
                fs.addChild((IParseNode)f);
                return fs;
            }
            case 106: {
                Symbol _symbol_f = this._symbols[offset + 1];
                CSSExpressionNode f = (CSSExpressionNode)((Object)_symbol_f.value);
                CSSList list = new CSSList();
                list.addChild((IParseNode)f);
                return list;
            }
            case 107: {
                Symbol _symbol_n = this._symbols[offset + 1];
                CSSNode n = (CSSNode)((Object)_symbol_n.value);
                Symbol _symbol_v = this._symbols[offset + 2];
                CSSNode v = (CSSNode)((Object)_symbol_v.value);
                return new CSSFunctionNode(n, v);
            }
            case 108: {
                Symbol i = this._symbols[offset + 1];
                return new CSSTerminalNode(i);
            }
            case 109: {
                Symbol i = this._symbols[offset + 1];
                return new CSSTerminalNode(i);
            }
            case 110: {
                Symbol i = this._symbols[offset + 1];
                return new CSSTerminalNode(i);
            }
            case 111: {
                return new CSSInvokeNode(new CSSNode[0]);
            }
            case 112: {
                Symbol _symbol_s = this._symbols[offset + 2];
                ArrayList _list_s = (ArrayList)_symbol_s.value;
                CSSNode[] s = _list_s == null ? new CSSNode[]{} : _list_s.toArray(new CSSNode[_list_s.size()]);
                return new CSSInvokeNode(s);
            }
            case 113: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 3].value);
                return this._symbols[offset + 1];
            }
            case 114: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 115: {
                Symbol _symbol_t = this._symbols[offset + 1];
                CSSExpressionNode t = (CSSExpressionNode)((Object)_symbol_t.value);
                return new CSSArgNode(t);
            }
            case 116: {
                return new CSSUnkownArgNode();
            }
            case 117: {
                Symbol _symbol_d = this._symbols[offset + 1];
                CSSDeclarationNode d = (CSSDeclarationNode)((Object)_symbol_d.value);
                ArrayList<CSSDeclarationNode> list = new ArrayList<CSSDeclarationNode>();
                list.add(d);
                return new Symbol(list);
            }
            case 118: {
                Symbol _symbol_d = this._symbols[offset + 1];
                CSSDeclarationNode d = (CSSDeclarationNode)((Object)_symbol_d.value);
                Symbol s = this._symbols[offset + 2];
                ArrayList<CSSDeclarationNode> list = new ArrayList<CSSDeclarationNode>();
                d.setHasSemicolon(s);
                list.add(d);
                return new Symbol(list);
            }
            case 119: {
                Symbol _symbol_ds = this._symbols[offset + 1];
                List ds = (List)_symbol_ds.value;
                Symbol _symbol_d = this._symbols[offset + 2];
                CSSDeclarationNode d = (CSSDeclarationNode)((Object)_symbol_d.value);
                ds.add(d);
                return this._symbols[offset + 1];
            }
            case 120: {
                Symbol _symbol_ds = this._symbols[offset + 1];
                List ds = (List)_symbol_ds.value;
                Symbol _symbol_d = this._symbols[offset + 2];
                CSSDeclarationNode d = (CSSDeclarationNode)((Object)_symbol_d.value);
                Symbol s = this._symbols[offset + 3];
                d.setHasSemicolon(s);
                ds.add(d);
                return this._symbols[offset + 1];
            }
            case 121: {
                Symbol i = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 3];
                CSSExpressionNode e = (CSSExpressionNode)((Object)_symbol_e.value);
                CSSTerminalNode node = new CSSTerminalNode(i);
                return new CSSDeclarationNode(node, e);
            }
            case 122: {
                Symbol i = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 3];
                CSSExpressionNode e = (CSSExpressionNode)((Object)_symbol_e.value);
                Symbol s = this._symbols[offset + 4];
                CSSTerminalNode node = new CSSTerminalNode(i);
                return new CSSDeclarationNode(node, e, s);
            }
            case 123: {
                Symbol i = this._symbols[offset + 1];
                CSSTerminalNode node = new CSSTerminalNode(i);
                return new CSSDeclarationNode(node, null);
            }
            case 124: {
                Symbol i = this._symbols[offset + 1];
                CSSTerminalNode node = new CSSTerminalNode(i);
                return new CSSDeclarationNode(node, null);
            }
            case 125: {
                Symbol i = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 4];
                CSSExpressionNode e = (CSSExpressionNode)((Object)_symbol_e.value);
                CSSTerminalNode node = new CSSTerminalNode(i);
                return new CSSDeclarationNode(node, e);
            }
            case 126: {
                Symbol i = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 4];
                CSSExpressionNode e = (CSSExpressionNode)((Object)_symbol_e.value);
                Symbol s = this._symbols[offset + 5];
                CSSTerminalNode node = new CSSTerminalNode(i);
                return new CSSDeclarationNode(node, e, s);
            }
            case 127: {
                Symbol i = this._symbols[offset + 2];
                CSSTerminalNode node = new CSSTerminalNode(i);
                return new CSSDeclarationNode(node, null);
            }
            case 128: {
                Symbol i = this._symbols[offset + 2];
                CSSTerminalNode node = new CSSTerminalNode(i);
                return new CSSDeclarationNode(node, null);
            }
            case 132: {
                Symbol _symbol_e = this._symbols[offset + 1];
                CSSExpressionNode e = (CSSExpressionNode)((Object)_symbol_e.value);
                Symbol _symbol_s = this._symbols[offset + 2];
                String s = (String)_symbol_s.value;
                Symbol _symbol_t = this._symbols[offset + 3];
                CSSExpressionNode t = (CSSExpressionNode)((Object)_symbol_t.value);
                return new CSSTermListNode(e, t, s);
            }
            case 133: {
                Symbol _symbol_e = this._symbols[offset + 1];
                CSSExpressionNode e = (CSSExpressionNode)((Object)_symbol_e.value);
                Symbol _symbol_t = this._symbols[offset + 2];
                CSSExpressionNode t = (CSSExpressionNode)((Object)_symbol_t.value);
                return new CSSTermListNode(e, t);
            }
            case 135: {
                return new CSSErrorExpressionNode();
            }
            case 136: {
                Symbol _symbol_e = this._symbols[offset + 1];
                String e = (String)_symbol_e.value;
                CSSIEExpressionNode expressionNode = new CSSIEExpressionNode(e, _symbol_e.getStart(), _symbol_e.getEnd());
                return expressionNode;
            }
            case 137: {
                Symbol p = this._symbols[offset + 1];
                CSSTerminalNode node = new CSSTerminalNode(p);
                return new CSSTermNode(node);
            }
            case 139: {
                Symbol _symbol_u = this._symbols[offset + 1];
                CSSURLNode u = (CSSURLNode)((Object)_symbol_u.value);
                return new CSSTermNode(u);
            }
            case 140: {
                Symbol _symbol_ss = this._symbols[offset + 1];
                List ss = (List)_symbol_ss.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                Symbol _symbol_s = this._symbols[offset + 3];
                CSSSelectorNode s = (CSSSelectorNode)((Object)_symbol_s.value);
                CSSSelectorNode lastSelector = (CSSSelectorNode)((Object)ss.get(ss.size() - 1));
                lastSelector.setCombinator(c);
                ss.add(s);
                return this._symbols[offset + 1];
            }
            case 141: {
                Symbol _symbol_s = this._symbols[offset + 1];
                CSSSelectorNode s = (CSSSelectorNode)((Object)_symbol_s.value);
                ArrayList<CSSSelectorNode> list = new ArrayList<CSSSelectorNode>();
                list.add(s);
                return new Symbol(list);
            }
            case 142: {
                Symbol _symbol_s = this._symbols[offset + 1];
                CSSSelectorNode s = (CSSSelectorNode)((Object)_symbol_s.value);
                Symbol _symbol_ss = this._symbols[offset + 2];
                CSSSimpleSelectorNode ss = (CSSSimpleSelectorNode)((Object)_symbol_ss.value);
                s.addChild((IParseNode)ss);
                return s;
            }
            case 143: {
                Symbol _symbol_ss = this._symbols[offset + 1];
                CSSSimpleSelectorNode ss = (CSSSimpleSelectorNode)((Object)_symbol_ss.value);
                CSSSelectorNode selector = new CSSSelectorNode(new CSSSimpleSelectorNode[0]);
                selector.addChild((IParseNode)ss);
                return selector;
            }
            case 144: {
                Symbol _symbol_t = this._symbols[offset + 1];
                String t = (String)_symbol_t.value;
                Symbol _symbol_a = this._symbols[offset + 2];
                ArrayList _list_a = (ArrayList)_symbol_a.value;
                CSSAttributeSelectorNode[] a = _list_a == null ? new CSSAttributeSelectorNode[]{} : _list_a.toArray(new CSSAttributeSelectorNode[_list_a.size()]);
                return new CSSSimpleSelectorNode(t, a);
            }
            case 145: {
                Symbol _symbol_t = this._symbols[offset + 1];
                String t = (String)_symbol_t.value;
                return new CSSSimpleSelectorNode(t);
            }
            case 146: {
                Symbol _symbol_a = this._symbols[offset + 1];
                ArrayList _list_a = (ArrayList)_symbol_a.value;
                CSSAttributeSelectorNode[] a = _list_a == null ? new CSSAttributeSelectorNode[]{} : _list_a.toArray(new CSSAttributeSelectorNode[_list_a.size()]);
                return new CSSSimpleSelectorNode(a);
            }
            case 147: {
                Symbol _symbol_t = this._symbols[offset + 1];
                String t = (String)_symbol_t.value;
                Symbol _symbol_c1 = this._symbols[offset + 2];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_s = this._symbols[offset + 4];
                String s = (String)_symbol_s.value;
                return new CSSSimpleSelectorNode(String.valueOf(t) + c1 + "(" + s + ")");
            }
            case 148: {
                Symbol _symbol_t = this._symbols[offset + 1];
                String t = (String)_symbol_t.value;
                Symbol _symbol_c1 = this._symbols[offset + 2];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_s = this._symbols[offset + 4];
                ArrayList _list_s = (ArrayList)_symbol_s.value;
                CSSAttributeSelectorNode[] s = _list_s == null ? new CSSAttributeSelectorNode[]{} : _list_s.toArray(new CSSAttributeSelectorNode[_list_s.size()]);
                String type = s.toString();
                if (s.getClass().isArray()) {
                    type = s[0].toString();
                }
                return new CSSSimpleSelectorNode(String.valueOf(t) + c1 + "(" + type + ")");
            }
            case 149: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_s = this._symbols[offset + 3];
                String s = (String)_symbol_s.value;
                return new CSSSimpleSelectorNode(String.valueOf(c1) + "(" + s + ")");
            }
            case 150: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_s = this._symbols[offset + 3];
                ArrayList _list_s = (ArrayList)_symbol_s.value;
                CSSAttributeSelectorNode[] s = _list_s == null ? new CSSAttributeSelectorNode[]{} : _list_s.toArray(new CSSAttributeSelectorNode[_list_s.size()]);
                String type = s.toString();
                if (s.getClass().isArray()) {
                    type = s[0].toString();
                }
                return new CSSSimpleSelectorNode(String.valueOf(c1) + "(" + type + ")");
            }
            case 151: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                return new CSSSimpleSelectorNode(c1);
            }
            case 152: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 153: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 154: {
                Symbol _symbol_c = this._symbols[offset + 1];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(c);
            }
            case 155: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 156: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 157: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 158: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 159: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 160: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 161: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 162: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 163: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 164: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 165: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                Symbol i = this._symbols[offset + 4];
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c + "(" + i + ")");
            }
            case 166: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 167: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 168: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 169: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 170: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                Symbol _symbol_i = this._symbols[offset + 4];
                CSSExpressionNode cfr_ignored_0 = (CSSExpressionNode)((Object)_symbol_i.value);
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 171: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                Symbol _symbol_i = this._symbols[offset + 4];
                CSSExpressionNode cfr_ignored_1 = (CSSExpressionNode)((Object)_symbol_i.value);
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 172: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                Symbol _symbol_i = this._symbols[offset + 4];
                CSSExpressionNode cfr_ignored_2 = (CSSExpressionNode)((Object)_symbol_i.value);
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 173: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                Symbol _symbol_i = this._symbols[offset + 4];
                CSSExpressionNode cfr_ignored_3 = (CSSExpressionNode)((Object)_symbol_i.value);
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 174: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 175: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 176: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 177: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 178: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 179: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 180: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 181: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 182: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c2 = this._symbols[offset + 2];
                String c2 = (String)_symbol_c2.value;
                Symbol _symbol_i = this._symbols[offset + 3];
                String i = (String)_symbol_i.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c2 + i);
            }
            case 183: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c2 = this._symbols[offset + 2];
                String c2 = (String)_symbol_c2.value;
                Symbol _symbol_i = this._symbols[offset + 3];
                String i = (String)_symbol_i.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c2 + i);
            }
            case 184: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c2 = this._symbols[offset + 2];
                String c2 = (String)_symbol_c2.value;
                Symbol _symbol_i = this._symbols[offset + 3];
                String i = (String)_symbol_i.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c2 + i);
            }
            case 185: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c2 = this._symbols[offset + 2];
                String c2 = (String)_symbol_c2.value;
                Symbol _symbol_i = this._symbols[offset + 3];
                String i = (String)_symbol_i.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c2 + i);
            }
            case 186: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c2 = this._symbols[offset + 2];
                String c2 = (String)_symbol_c2.value;
                Symbol _symbol_i = this._symbols[offset + 3];
                String i = (String)_symbol_i.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c2 + i);
            }
            case 187: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol i = this._symbols[offset + 2];
                return new CSSAttributeSelectorNode(String.valueOf(c1) + i);
            }
            case 188: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c2 = this._symbols[offset + 2];
                String c2 = (String)_symbol_c2.value;
                Symbol i = this._symbols[offset + 3];
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c2 + i);
            }
            case 189: {
                Symbol _symbol_f = this._symbols[offset + 2];
                CSSExpressionNode f = (CSSExpressionNode)((Object)_symbol_f.value);
                return new CSSAttributeSelectorNode(f);
            }
            case 190: {
                Symbol _symbol_h = this._symbols[offset + 1];
                String h = (String)_symbol_h.value;
                return new CSSAttributeSelectorNode(h);
            }
            case 191: {
                Symbol _symbol_l = this._symbols[offset + 1];
                String l = (String)_symbol_l.value;
                Symbol i = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                String r = (String)_symbol_r.value;
                return new CSSAttributeSelectorNode(String.valueOf(l) + i + r);
            }
            case 192: {
                Symbol _symbol_l = this._symbols[offset + 1];
                String l = (String)_symbol_l.value;
                Symbol i = this._symbols[offset + 2];
                Symbol _symbol_o = this._symbols[offset + 3];
                String o = (String)_symbol_o.value;
                Symbol _symbol_s = this._symbols[offset + 4];
                String s = (String)_symbol_s.value;
                Symbol _symbol_r = this._symbols[offset + 5];
                String r = (String)_symbol_r.value;
                return new CSSAttributeSelectorNode(String.valueOf(l) + i + " " + o + " " + s + r);
            }
            case 193: {
                Symbol _symbol_l = this._symbols[offset + 1];
                String l = (String)_symbol_l.value;
                Symbol _symbol_i = this._symbols[offset + 2];
                String i = (String)_symbol_i.value;
                Symbol _symbol_r = this._symbols[offset + 3];
                String r = (String)_symbol_r.value;
                return new CSSAttributeSelectorNode(String.valueOf(l) + i + r);
            }
            case 194: {
                Symbol _symbol_l = this._symbols[offset + 1];
                String l = (String)_symbol_l.value;
                Symbol _symbol_i = this._symbols[offset + 2];
                String i = (String)_symbol_i.value;
                Symbol _symbol_r = this._symbols[offset + 3];
                String r = (String)_symbol_r.value;
                return new CSSAttributeSelectorNode(String.valueOf(l) + i + r);
            }
            case 195: {
                Symbol _symbol_l = this._symbols[offset + 1];
                String l = (String)_symbol_l.value;
                Symbol _symbol_i = this._symbols[offset + 2];
                String i = (String)_symbol_i.value;
                Symbol _symbol_r = this._symbols[offset + 3];
                String r = (String)_symbol_r.value;
                return new CSSAttributeSelectorNode(String.valueOf(l) + i + r);
            }
            case 196: {
                Symbol _symbol_u = this._symbols[offset + 1];
                String u = (String)_symbol_u.value;
                return new CSSURLNode(u);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 61: 
            case 86: 
            case 87: 
            case 100: 
            case 129: 
            case 130: 
            case 134: 
            case 138: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: {
                return this._symbols[offset + 1];
            }
            case 131: {
                return this._symbols[offset + 2];
            }
        }
        throw new IllegalArgumentException("unknown production #" + rule_num);
    }

    private class CSSEvents
    extends Parser.Events {
        private CSSEvents() {
        }

        public void scannerError(Scanner.Exception e) {
        }

        public void syntaxError(Symbol token) {
            if (token == null || CSSParser.this.fWorking == null) {
                return;
            }
            CSSParser.this.fWorking.addError((IParseError)new ParseError("com.aptana.contenttype.css", token, IParseError.Severity.ERROR));
        }

        public void unexpectedTokenRemoved(Symbol token) {
        }

        public void missingTokenInserted(Symbol token) {
        }

        public void misspelledTokenReplaced(Symbol token) {
        }

        public void errorPhraseRemoved(Symbol error) {
        }
    }
}

