/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.outline;

import com.aptana.editor.common.outline.CommonOutlineContentProvider;
import com.aptana.editor.common.outline.CommonOutlineItem;
import com.aptana.editor.css.parsing.ast.CSSCommentNode;
import com.aptana.editor.css.parsing.ast.CSSDeclarationNode;
import com.aptana.editor.css.parsing.ast.CSSFunctionNode;
import com.aptana.editor.css.parsing.ast.CSSKeyFramesNode;
import com.aptana.editor.css.parsing.ast.CSSMediaNode;
import com.aptana.editor.css.parsing.ast.CSSNode;
import com.aptana.editor.css.parsing.ast.CSSPageNode;
import com.aptana.editor.css.parsing.ast.CSSPageSubRuleNode;
import com.aptana.editor.css.parsing.ast.CSSRuleNode;
import com.aptana.editor.css.parsing.ast.CSSSelectorNode;
import com.aptana.editor.css.parsing.ast.CSSSupportNode;
import com.aptana.editor.css.parsing.ast.CSSTermListNode;
import com.aptana.editor.css.parsing.ast.CSSTermNode;
import com.aptana.editor.css.parsing.ast.CSSViewportNode;
import com.aptana.parsing.ast.IParseNode;
import java.util.ArrayList;

public class CSSOutlineContentProvider
extends CommonOutlineContentProvider {
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof CSSRuleNode) {
            return this.filter((IParseNode[])((CSSRuleNode)((Object)parentElement)).getDeclarations());
        }
        if (parentElement instanceof CSSMediaNode || parentElement instanceof CSSSupportNode || parentElement instanceof CSSViewportNode || parentElement instanceof CSSKeyFramesNode || parentElement instanceof CSSPageNode || parentElement instanceof CSSPageSubRuleNode) {
            CSSNode node = (CSSNode)((Object)parentElement);
            return super.getChildren((Object)node.getLastChild());
        }
        return super.getChildren(parentElement);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof CommonOutlineItem || element instanceof CSSNode) {
            IParseNode[] childs;
            CSSNode node = null;
            node = element instanceof CommonOutlineItem ? ((CommonOutlineItem)element).getReferenceNode() : (CSSNode)((Object)element);
            if (node instanceof CSSRuleNode) {
                return ((CSSRuleNode)node).getDeclarations().length > 0;
            }
            if (!(node instanceof CSSCommentNode || node instanceof CSSTermNode || node instanceof CSSTermListNode || node instanceof CSSFunctionNode || (childs = node.getChildren()).length <= 0)) {
                IParseNode[] iParseNodeArray = childs;
                int n = childs.length;
                int n2 = 0;
                while (n2 < n) {
                    IParseNode child = iParseNodeArray[n2];
                    if (this.hasChildren(child)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
        return super.hasChildren(element);
    }

    public static Object getElementAt(IParseNode root, int offset) {
        IParseNode[] children;
        if (root == null) {
            return null;
        }
        IParseNode[] iParseNodeArray = children = root.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            CSSSelectorNode[] selectors;
            CSSRuleNode rule;
            IParseNode child = iParseNodeArray[n2];
            if (child instanceof CSSRuleNode && offset <= (rule = (CSSRuleNode)child).getEnd() && (selectors = rule.getSelectors()).length > 0) {
                if (offset <= selectors[selectors.length - 1].getEnd()) {
                    CSSSelectorNode[] cSSSelectorNodeArray = selectors;
                    int n3 = selectors.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        CSSSelectorNode selector = cSSSelectorNodeArray[n4];
                        if (offset <= selector.getEnd()) {
                            return CSSOutlineContentProvider.getItem((IParseNode)rule);
                        }
                        ++n4;
                    }
                } else {
                    CSSDeclarationNode[] declarations;
                    CSSDeclarationNode[] cSSDeclarationNodeArray = declarations = rule.getDeclarations();
                    int n5 = declarations.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        CSSDeclarationNode declaration = cSSDeclarationNodeArray[n6];
                        if (offset <= declaration.getEnd()) {
                            return CSSOutlineContentProvider.getItem((IParseNode)declaration);
                        }
                        ++n6;
                    }
                }
                return CSSOutlineContentProvider.getItem((IParseNode)selectors[selectors.length - 1]);
            }
            ++n2;
        }
        return null;
    }

    protected Object[] filter(IParseNode[] nodes) {
        ArrayList<CommonOutlineItem> items = new ArrayList<CommonOutlineItem>();
        IParseNode[] iParseNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            CommonOutlineItem item;
            IParseNode node = iParseNodeArray[n2];
            if (node instanceof CSSRuleNode) {
                item = this.getOutlineItem(node);
                if (item != null) {
                    items.add(item);
                }
            } else if (!(node instanceof CSSCommentNode || node instanceof CSSTermNode || node instanceof CSSTermListNode || node instanceof CSSFunctionNode || (item = this.getOutlineItem(node)) == null)) {
                items.add(item);
            }
            ++n2;
        }
        return items.toArray(new CommonOutlineItem[items.size()]);
    }

    private static CommonOutlineItem getItem(IParseNode node) {
        return new CommonOutlineItem(node.getNameNode().getNameRange(), node);
    }
}

