/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.internal.text.rules;

import com.aptana.editor.common.text.rules.ExtendedWordRule;
import java.util.regex.Pattern;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;

public class CSSFunctionRule
extends ExtendedWordRule {
    private Pattern pattern;

    public CSSFunctionRule(IToken token) {
        super((IWordDetector)new CSSFunctionWordDetector(), token, true);
    }

    protected boolean wordOK(String word, ICharacterScanner scanner) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile("\\([^)]*\\)", 2);
        }
        return this.pattern.matcher(word).matches();
    }

    private static class CSSFunctionWordDetector
    implements IWordDetector {
        private boolean foundEnd;

        private CSSFunctionWordDetector() {
        }

        public boolean isWordStart(char c) {
            this.foundEnd = false;
            return c == '(';
        }

        public boolean isWordPart(char c) {
            if (c == ')') {
                this.foundEnd = true;
                return true;
            }
            return !this.foundEnd;
        }
    }
}

