/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.contentassist.MetadataLoader;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.editor.css.Messages;
import com.aptana.editor.css.contentassist.CSSIndexQueryHelper;
import com.aptana.editor.css.contentassist.index.CSSIndexCacher;
import com.aptana.editor.css.contentassist.index.CSSIndexWriter;
import com.aptana.editor.css.contentassist.index.CSSMetadataReader;
import com.aptana.editor.css.contentassist.model.ElementElement;
import com.aptana.editor.css.contentassist.model.PropertyElement;
import com.aptana.editor.css.contentassist.model.PseudoClassElement;
import com.aptana.editor.css.contentassist.model.PseudoElementElement;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

public class CSSMetadataLoader
extends MetadataLoader<CSSMetadataReader> {
    public CSSMetadataLoader() {
        super(Messages.CSSMetadataLoader_Loading_Metadata);
    }

    protected CSSMetadataReader createMetadataReader() {
        return new CSSMetadataReader();
    }

    protected Bundle getBundle() {
        return CSSPlugin.getDefault().getBundle();
    }

    protected String getIndexVersionKey() {
        return "CSS_INDEX_VERSION";
    }

    protected String[] getMetadataFiles() {
        return new String[]{"/metadata/css_metadata.xml"};
    }

    protected String getPluginId() {
        return "com.aptana.editor.css";
    }

    protected void writeIndex(CSSMetadataReader reader) {
        this.getIndexManager().removeIndex(URI.create("css.metadata:/css"));
        CSSIndexWriter indexer = new CSSIndexWriter();
        Index index = this.getIndex();
        for (ElementElement element : reader.getElements()) {
            indexer.writeElement(index, element);
        }
        for (PropertyElement property : reader.getProperties()) {
            indexer.writeProperty(index, property);
        }
        for (PseudoClassElement pseudoClass : reader.getPseudoClasses()) {
            indexer.writePseudoClass(index, pseudoClass);
        }
        for (PseudoElementElement pseudoElement : reader.getPseudoElements()) {
            indexer.writePseudoElement(index, pseudoElement);
        }
        try {
            index.save();
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
        }
    }

    protected IndexManager getIndexManager() {
        return IndexPlugin.getDefault().getIndexManager();
    }

    protected Index getIndex() {
        return CSSIndexQueryHelper.getIndex();
    }

    protected void loadIndexCacher() {
        this.loadMetadataCacheIndex();
    }

    private void loadMetadataCacheIndex() {
        boolean isIndexfileExist;
        CSSIndexCacher cacher = CSSIndexCacher.getInstance();
        boolean isExistCache = cacher.isExistCache();
        if (isExistCache) {
            return;
        }
        Index index = this.getIndex();
        File indexFile = cacher.getIndexFile(index, false);
        boolean bl = isIndexfileExist = indexFile == null ? false : indexFile.exists();
        if (isIndexfileExist) {
            try {
                cacher.deSerialize(index);
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
                this.buildMetadata((IProgressMonitor)new NullProgressMonitor());
            }
        } else {
            this.buildMetadata((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

