/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css;

import com.aptana.core.util.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class CSSColors {
    private static final String HASH = "#";
    private static Map<String, String> NAMED_COLORS = new HashMap<String, String>();
    private static Map<String, String> NAMED_COLORS_RGB = new HashMap<String, String>();

    static {
        NAMED_COLORS.put("aliceblue", "#F0F8FF");
        NAMED_COLORS.put("antiquewhite", "#FAEBD7");
        NAMED_COLORS.put("aqua", "#00FFFF");
        NAMED_COLORS.put("aquamarine", "#7FFFD4");
        NAMED_COLORS.put("azure", "#F0FFFF");
        NAMED_COLORS.put("beige", "#F5F5DC");
        NAMED_COLORS.put("bisque", "#FFE4C4");
        NAMED_COLORS.put("black", "#000000");
        NAMED_COLORS.put("blanchedalmond", "#FFEBCD");
        NAMED_COLORS.put("blue", "#0000FF");
        NAMED_COLORS.put("blueviolet", "#8A2BE2");
        NAMED_COLORS.put("brown", "#A52A2A");
        NAMED_COLORS.put("burlywood", "#DEB887");
        NAMED_COLORS.put("cadetblue", "#5F9EA0");
        NAMED_COLORS.put("chartreuse", "#7FFF00");
        NAMED_COLORS.put("chocolate", "#D2691E");
        NAMED_COLORS.put("coral", "#FF7F50");
        NAMED_COLORS.put("cornflowerblue", "#6495ED");
        NAMED_COLORS.put("cornsilk", "#FFF8DC");
        NAMED_COLORS.put("crimson", "#DC143C");
        NAMED_COLORS.put("cyan", "#00FFFF");
        NAMED_COLORS.put("darkblue", "#00008B");
        NAMED_COLORS.put("darkcyan", "#008B8B");
        NAMED_COLORS.put("darkgoldenrod", "#B8860B");
        NAMED_COLORS.put("darkgray", "#A9A9A9");
        NAMED_COLORS.put("darkgreen", "#006400");
        NAMED_COLORS.put("darkgrey", "#A9A9A9");
        NAMED_COLORS.put("darkkhaki", "#BDB76B");
        NAMED_COLORS.put("darkmagenta", "#8B008B");
        NAMED_COLORS.put("darkolivegreen", "#556B2F");
        NAMED_COLORS.put("darkorange", "#FF8C00");
        NAMED_COLORS.put("darkorchid", "#9932CC");
        NAMED_COLORS.put("darkred", "#8B0000");
        NAMED_COLORS.put("darksalmon", "#E9967A");
        NAMED_COLORS.put("darkseagreen", "#8FBC8F");
        NAMED_COLORS.put("darkslateblue", "#483D8B");
        NAMED_COLORS.put("darkslategray", "#2F4F4F");
        NAMED_COLORS.put("darkslategrey", "#2F4F4F");
        NAMED_COLORS.put("darkturquoise", "#00CED1");
        NAMED_COLORS.put("darkviolet", "#9400D3");
        NAMED_COLORS.put("deeppink", "#FF1493");
        NAMED_COLORS.put("deepskyblue", "#00BFFF");
        NAMED_COLORS.put("dimgray", "#696969");
        NAMED_COLORS.put("dimgrey", "#696969");
        NAMED_COLORS.put("dodgerblue", "#1E90FF");
        NAMED_COLORS.put("firebrick", "#B22222");
        NAMED_COLORS.put("floralwhite", "#FFFAF0");
        NAMED_COLORS.put("forestgreen", "#228B22");
        NAMED_COLORS.put("fuchsia", "#FF00FF");
        NAMED_COLORS.put("gainsboro", "#DCDCDC");
        NAMED_COLORS.put("ghostwhite", "#F8F8FF");
        NAMED_COLORS.put("gold", "#FFD700");
        NAMED_COLORS.put("goldenrod", "#DAA520");
        NAMED_COLORS.put("gray", "#808080");
        NAMED_COLORS.put("green", "#008000");
        NAMED_COLORS.put("greenyellow", "#ADFF2F");
        NAMED_COLORS.put("grey", "#808080");
        NAMED_COLORS.put("honeydew", "#F0FFF0");
        NAMED_COLORS.put("hotpink", "#FF69B4");
        NAMED_COLORS.put("indianred", "#CD5C5C");
        NAMED_COLORS.put("indigo", "#4B0082");
        NAMED_COLORS.put("ivory", "#FFFFF0");
        NAMED_COLORS.put("khaki", "#F0E68C");
        NAMED_COLORS.put("lavender", "#E6E6FA");
        NAMED_COLORS.put("lavenderblush", "#FFF0F5");
        NAMED_COLORS.put("lawngreen", "#7CFC00");
        NAMED_COLORS.put("lemonchiffon", "#FFFACD");
        NAMED_COLORS.put("lightblue", "#ADD8E6");
        NAMED_COLORS.put("lightcoral", "#F08080");
        NAMED_COLORS.put("lightcyan", "#E0FFFF");
        NAMED_COLORS.put("lightgoldenrodyellow", "#FAFAD2");
        NAMED_COLORS.put("lightgray", "#D3D3D3");
        NAMED_COLORS.put("lightgreen", "#90EE90");
        NAMED_COLORS.put("lightgrey", "#D3D3D3");
        NAMED_COLORS.put("lightpink", "#FFB6C1");
        NAMED_COLORS.put("lightsalmon", "#FFA07A");
        NAMED_COLORS.put("lightseagreen", "#20B2AA");
        NAMED_COLORS.put("lightskyblue", "#87CEFA");
        NAMED_COLORS.put("lightslategray", "#778899");
        NAMED_COLORS.put("lightslategrey", "#778899");
        NAMED_COLORS.put("lightsteelblue", "#B0C4DE");
        NAMED_COLORS.put("lightyellow", "#FFFFE0");
        NAMED_COLORS.put("lime", "#00FF00");
        NAMED_COLORS.put("limegreen", "#32CD32");
        NAMED_COLORS.put("linen", "#FAF0E6");
        NAMED_COLORS.put("magenta", "#FF00FF");
        NAMED_COLORS.put("maroon", "#800000");
        NAMED_COLORS.put("mediumaquamarine", "#66CDAA");
        NAMED_COLORS.put("mediumblue", "#0000CD");
        NAMED_COLORS.put("mediumorchid", "#BA55D3");
        NAMED_COLORS.put("mediumpurple", "#9370DB");
        NAMED_COLORS.put("mediumseagreen", "#3CB371");
        NAMED_COLORS.put("mediumslateblue", "#7B68EE");
        NAMED_COLORS.put("mediumspringgreen", "#00FA9A");
        NAMED_COLORS.put("mediumturquoise", "#48D1CC");
        NAMED_COLORS.put("mediumvioletred", "#C71585");
        NAMED_COLORS.put("midnightblue", "#191970");
        NAMED_COLORS.put("mintcream", "#F5FFFA");
        NAMED_COLORS.put("mistyrose", "#FFE4E1");
        NAMED_COLORS.put("moccasin", "#FFE4B5");
        NAMED_COLORS.put("navajowhite", "#FFDEAD");
        NAMED_COLORS.put("navy", "#000080");
        NAMED_COLORS.put("oldlace", "#FDF5E6");
        NAMED_COLORS.put("olive", "#808000");
        NAMED_COLORS.put("olivedrab", "#6B8E23");
        NAMED_COLORS.put("orange", "#FFA500");
        NAMED_COLORS.put("orangered", "#FF4500");
        NAMED_COLORS.put("orchid", "#DA70D6");
        NAMED_COLORS.put("palegoldenrod", "#EEE8AA");
        NAMED_COLORS.put("palegreen", "#98FB98");
        NAMED_COLORS.put("paleturquoise", "#AFEEEE");
        NAMED_COLORS.put("palevioletred", "#DB7093");
        NAMED_COLORS.put("papayawhip", "#FFEFD5");
        NAMED_COLORS.put("peachpuff", "#FFDAB9");
        NAMED_COLORS.put("peru", "#CD853F");
        NAMED_COLORS.put("pink", "#FFC0CB");
        NAMED_COLORS.put("plum", "#DDA0DD");
        NAMED_COLORS.put("powderblue", "#B0E0E6");
        NAMED_COLORS.put("purple", "#800080");
        NAMED_COLORS.put("red", "#FF0000");
        NAMED_COLORS.put("rosybrown", "#BC8F8F");
        NAMED_COLORS.put("royalblue", "#4169E1");
        NAMED_COLORS.put("saddlebrown", "#8B4513");
        NAMED_COLORS.put("salmon", "#FA8072");
        NAMED_COLORS.put("sandybrown", "#F4A460");
        NAMED_COLORS.put("seagreen", "#2E8B57");
        NAMED_COLORS.put("seashell", "#FFF5EE");
        NAMED_COLORS.put("sienna", "#A0522D");
        NAMED_COLORS.put("silver", "#C0C0C0");
        NAMED_COLORS.put("skyblue", "#87CEEB");
        NAMED_COLORS.put("slateblue", "#6A5ACD");
        NAMED_COLORS.put("slategray", "#708090");
        NAMED_COLORS.put("slategrey", "#708090");
        NAMED_COLORS.put("snow", "#FFFAFA");
        NAMED_COLORS.put("springgreen", "#00FF7F");
        NAMED_COLORS.put("steelblue", "#4682B4");
        NAMED_COLORS.put("tan", "#D2B48C");
        NAMED_COLORS.put("teal", "#008080");
        NAMED_COLORS.put("thistle", "#D8BFD8");
        NAMED_COLORS.put("tomato", "#FF6347");
        NAMED_COLORS.put("turquoise", "#40E0D0");
        NAMED_COLORS.put("violet", "#EE82EE");
        NAMED_COLORS.put("wheat", "#F5DEB3");
        NAMED_COLORS.put("white", "#FFFFFF");
        NAMED_COLORS.put("whitesmoke", "#F5F5F5");
        NAMED_COLORS.put("yellow", "#FFFF00");
        NAMED_COLORS.put("yellowgreen", "#9ACD32");
        NAMED_COLORS_RGB.put("aliceblue", "240,248,255");
        NAMED_COLORS_RGB.put("antiquewhite", "250,235,215");
        NAMED_COLORS_RGB.put("aqua", "0,255,255");
        NAMED_COLORS_RGB.put("aquamarine", "127,255,212");
        NAMED_COLORS_RGB.put("azure", "240,255,255");
        NAMED_COLORS_RGB.put("beige", "245,245,220");
        NAMED_COLORS_RGB.put("bisque", "255,228,196");
        NAMED_COLORS_RGB.put("black", "0,0,0");
        NAMED_COLORS_RGB.put("blanchedalmond", "255,235,205");
        NAMED_COLORS_RGB.put("blue", "0,0,255");
        NAMED_COLORS_RGB.put("blueviolet", "138,43,226");
        NAMED_COLORS_RGB.put("brown", "165,42,42");
        NAMED_COLORS_RGB.put("burlywood", "222,184,135");
        NAMED_COLORS_RGB.put("cadetblue", "95,158,160");
        NAMED_COLORS_RGB.put("chartreuse", "127,255,0");
        NAMED_COLORS_RGB.put("chocolate", "210,105,30");
        NAMED_COLORS_RGB.put("coral", "255,127,80");
        NAMED_COLORS_RGB.put("cornflowerblue", "100,149,237");
        NAMED_COLORS_RGB.put("cornsilk", "255,248,220");
        NAMED_COLORS_RGB.put("crimson", "220,20,60");
        NAMED_COLORS_RGB.put("cyan", "0,255,255");
        NAMED_COLORS_RGB.put("darkblue", "0,0,139");
        NAMED_COLORS_RGB.put("darkcyan", "0,139,139");
        NAMED_COLORS_RGB.put("darkgoldenrod", "184,134,11");
        NAMED_COLORS_RGB.put("darkgray", "169,169,169");
        NAMED_COLORS_RGB.put("darkgreen", "0,100,0");
        NAMED_COLORS_RGB.put("darkgrey", "169,169,169");
        NAMED_COLORS_RGB.put("darkkhaki", "189,183,107");
        NAMED_COLORS_RGB.put("darkmagenta", "139,0,139");
        NAMED_COLORS_RGB.put("darkolivegreen", "85,107,47");
        NAMED_COLORS_RGB.put("darkorange", "255,140,0");
        NAMED_COLORS_RGB.put("darkorchid", "153,50,204");
        NAMED_COLORS_RGB.put("darkred", "139,0,0");
        NAMED_COLORS_RGB.put("darksalmon", "233,150,122");
        NAMED_COLORS_RGB.put("darkseagreen", "143,188,143");
        NAMED_COLORS_RGB.put("darkslateblue", "72,61,139");
        NAMED_COLORS_RGB.put("darkslategray", "47,79,79");
        NAMED_COLORS_RGB.put("darkslategrey", "47,79,79");
        NAMED_COLORS_RGB.put("darkturquoise", "0,206,209");
        NAMED_COLORS_RGB.put("darkviolet", "148,0,211");
        NAMED_COLORS_RGB.put("deeppink", "255,20,147");
        NAMED_COLORS_RGB.put("deepskyblue", "0,191,255");
        NAMED_COLORS_RGB.put("dimgray", "105,105,105");
        NAMED_COLORS_RGB.put("dimgrey", "105,105,105");
        NAMED_COLORS_RGB.put("dodgerblue", "30,144,255");
        NAMED_COLORS_RGB.put("firebrick", "178,34,34");
        NAMED_COLORS_RGB.put("floralwhite", "255,250,240");
        NAMED_COLORS_RGB.put("forestgreen", "34,139,34");
        NAMED_COLORS_RGB.put("fuchsia", "255,0,255");
        NAMED_COLORS_RGB.put("gainsboro", "220,220,220");
        NAMED_COLORS_RGB.put("ghostwhite", "248,248,255");
        NAMED_COLORS_RGB.put("gold", "255,215,0");
        NAMED_COLORS_RGB.put("goldenrod", "218,165,32");
        NAMED_COLORS_RGB.put("gray", "128,128,128");
        NAMED_COLORS_RGB.put("green", "0,128,0");
        NAMED_COLORS_RGB.put("greenyellow", "173,255,47");
        NAMED_COLORS_RGB.put("grey", "128,128,128");
        NAMED_COLORS_RGB.put("honeydew", "240,255,240");
        NAMED_COLORS_RGB.put("hotpink", "255,105,180");
        NAMED_COLORS_RGB.put("indianred", "205,92,92");
        NAMED_COLORS_RGB.put("indigo", "75,0,130");
        NAMED_COLORS_RGB.put("ivory", "255,255,240");
        NAMED_COLORS_RGB.put("khaki", "240,230,140");
        NAMED_COLORS_RGB.put("lavender", "230,230,250");
        NAMED_COLORS_RGB.put("lavenderblush", "255,240,245");
        NAMED_COLORS_RGB.put("lawngreen", "124,252,0");
        NAMED_COLORS_RGB.put("lemonchiffon", "255,250,205");
        NAMED_COLORS_RGB.put("lightblue", "173,216,230");
        NAMED_COLORS_RGB.put("lightcoral", "240,128,128");
        NAMED_COLORS_RGB.put("lightcyan", "224,255,255");
        NAMED_COLORS_RGB.put("lightgoldenrodyellow", "250,250,210");
        NAMED_COLORS_RGB.put("lightgray", "211,211,211");
        NAMED_COLORS_RGB.put("lightgreen", "144,238,144");
        NAMED_COLORS_RGB.put("lightgrey", "211,211,211");
        NAMED_COLORS_RGB.put("lightpink", "255,182,193");
        NAMED_COLORS_RGB.put("lightsalmon", "255,160,122");
        NAMED_COLORS_RGB.put("lightseagreen", "32,178,170");
        NAMED_COLORS_RGB.put("lightskyblue", "135,206,250");
        NAMED_COLORS_RGB.put("lightslategray", "119,136,153");
        NAMED_COLORS_RGB.put("lightslategrey", "119,136,153");
        NAMED_COLORS_RGB.put("lightsteelblue", "176,196,222");
        NAMED_COLORS_RGB.put("lightyellow", "255,255,224");
        NAMED_COLORS_RGB.put("lime", "0,255,0");
        NAMED_COLORS_RGB.put("limegreen", "50,205,50");
        NAMED_COLORS_RGB.put("linen", "250,240,230");
        NAMED_COLORS_RGB.put("magenta", "255,0,255");
        NAMED_COLORS_RGB.put("maroon", "128,0,0");
        NAMED_COLORS_RGB.put("mediumaquamarine", "102,205,170");
        NAMED_COLORS_RGB.put("mediumblue", "0,0,205");
        NAMED_COLORS_RGB.put("mediumorchid", "186,85,211");
        NAMED_COLORS_RGB.put("mediumpurple", "147,112,219");
        NAMED_COLORS_RGB.put("mediumseagreen", "60,179,113");
        NAMED_COLORS_RGB.put("mediumslateblue", "123,104,238");
        NAMED_COLORS_RGB.put("mediumspringgreen", "0,250,154");
        NAMED_COLORS_RGB.put("mediumturquoise", "72,209,204");
        NAMED_COLORS_RGB.put("mediumvioletred", "199,21,133");
        NAMED_COLORS_RGB.put("midnightblue", "25,25,112");
        NAMED_COLORS_RGB.put("mintcream", "245,255,250");
        NAMED_COLORS_RGB.put("mistyrose", "255,228,225");
        NAMED_COLORS_RGB.put("moccasin", "255,228,181");
        NAMED_COLORS_RGB.put("navajowhite", "255,222,173");
        NAMED_COLORS_RGB.put("navy", "0,0,128");
        NAMED_COLORS_RGB.put("oldlace", "253,245,230");
        NAMED_COLORS_RGB.put("olive", "128,128,0");
        NAMED_COLORS_RGB.put("olivedrab", "107,142,35");
        NAMED_COLORS_RGB.put("orange", "255,165,0");
        NAMED_COLORS_RGB.put("orangered", "255,69,0");
        NAMED_COLORS_RGB.put("orchid", "218,112,214");
        NAMED_COLORS_RGB.put("palegoldenrod", "238,232,170");
        NAMED_COLORS_RGB.put("palegreen", "152,251,152");
        NAMED_COLORS_RGB.put("paleturquoise", "175,238,238");
        NAMED_COLORS_RGB.put("palevioletred", "219,112,147");
        NAMED_COLORS_RGB.put("papayawhip", "255,239,213");
        NAMED_COLORS_RGB.put("peachpuff", "255,218,185");
        NAMED_COLORS_RGB.put("peru", "205,133,63");
        NAMED_COLORS_RGB.put("pink", "255,192,203");
        NAMED_COLORS_RGB.put("plum", "221,160,221");
        NAMED_COLORS_RGB.put("powderblue", "176,224,230");
        NAMED_COLORS_RGB.put("purple", "128,0,128");
        NAMED_COLORS_RGB.put("red", "255,0,0");
        NAMED_COLORS_RGB.put("rosybrown", "188,143,143");
        NAMED_COLORS_RGB.put("royalblue", "65,105,225");
        NAMED_COLORS_RGB.put("saddlebrown", "139,69,19");
        NAMED_COLORS_RGB.put("salmon", "250,128,114");
        NAMED_COLORS_RGB.put("sandybrown", "244,164,96");
        NAMED_COLORS_RGB.put("seagreen", "46,139,87");
        NAMED_COLORS_RGB.put("seashell", "255,245,238");
        NAMED_COLORS_RGB.put("sienna", "160,82,45");
        NAMED_COLORS_RGB.put("silver", "192,192,192");
        NAMED_COLORS_RGB.put("skyblue", "135,206,235");
        NAMED_COLORS_RGB.put("slateblue", "106,90,205");
        NAMED_COLORS_RGB.put("slategray", "112,128,144");
        NAMED_COLORS_RGB.put("slategrey", "112,128,144");
        NAMED_COLORS_RGB.put("snow", "255,250,250");
        NAMED_COLORS_RGB.put("springgreen", "0,255,127");
        NAMED_COLORS_RGB.put("steelblue", "70,130,180");
        NAMED_COLORS_RGB.put("tan", "210,180,140");
        NAMED_COLORS_RGB.put("teal", "0,128,128");
        NAMED_COLORS_RGB.put("thistle", "216,191,216");
        NAMED_COLORS_RGB.put("tomato", "255,99,71");
        NAMED_COLORS_RGB.put("transparent", "");
        NAMED_COLORS_RGB.put("turquoise", "64,224,208");
        NAMED_COLORS_RGB.put("violet", "238,130,238");
        NAMED_COLORS_RGB.put("wheat", "245,222,179");
        NAMED_COLORS_RGB.put("white", "255,255,255");
        NAMED_COLORS_RGB.put("whitesmoke", "245,245,245");
        NAMED_COLORS_RGB.put("yellow", "255,255,0");
        NAMED_COLORS_RGB.put("yellowgreen", "154,205,50");
    }

    public static String getRGBByName(String colorName) {
        if (StringUtil.isBlank((String)colorName)) {
            return "";
        }
        return NAMED_COLORS_RGB.get(colorName.toLowerCase());
    }

    public static boolean namedColorExists(String colorName) {
        return NAMED_COLORS.containsKey(colorName);
    }

    public static String getHexValueForName(String colorName) {
        return NAMED_COLORS.get(colorName);
    }

    public static Set<String> getNamedColors() {
        return Collections.unmodifiableSet(NAMED_COLORS.keySet());
    }

    public static RGB hexToRGB(String color) {
        return CSSColors.toRGB(CSSColors.to6CharHexWithLeadingHash(color));
    }

    public static RGB namedColorToRGB(String name) {
        return CSSColors.toRGB(CSSColors.getHexValueForName(name));
    }

    private static RGB toRGB(String color) {
        if (CSSColors.namedColorExists(color.toLowerCase())) {
            color = CSSColors.getHexValueForName(color.toLowerCase());
        }
        if (color.startsWith(HASH)) {
            color = color.substring(1);
        }
        if (color.length() == 3) {
            int red = Integer.decode(HASH + color.substring(0, 1) + color.substring(0, 1));
            int green = Integer.decode(HASH + color.substring(1, 2) + color.substring(1, 2));
            int blue = Integer.decode(HASH + color.substring(2, 3) + color.substring(2, 3));
            return new RGB(red, green, blue);
        }
        int red = Integer.decode(HASH + color.substring(0, 2));
        int green = Integer.decode(HASH + color.substring(2, 4));
        int blue = Integer.decode(HASH + color.substring(4, 6));
        return new RGB(red, green, blue);
    }

    public static String to6CharHexWithLeadingHash(String color) {
        if (CSSColors.namedColorExists(color.toLowerCase())) {
            return CSSColors.getHexValueForName(color.toLowerCase());
        }
        if (color.startsWith(HASH)) {
            color = color.substring(1);
        }
        if (color.length() == 3) {
            return (HASH + color.charAt(0) + color.charAt(0) + color.charAt(1) + color.charAt(1) + color.charAt(2) + color.charAt(2)).toUpperCase();
        }
        return HASH + color.toUpperCase();
    }

    public static Image toImage(String color, int height, int width) {
        RGB actualColor = CSSColors.toRGB(color);
        PaletteData paletteData = new PaletteData(new RGB[]{actualColor, new RGB(0, 0, 0)});
        ImageData imageData = new ImageData(16, 16, 1, paletteData);
        return new Image((Device)Display.getDefault(), imageData);
    }
}

