/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.IOUtil;
import com.aptana.editor.css.parsing.ast.CSSParseRootNode;
import com.pandora.core.appstream.AbstractNestedASTParser;
import com.pandora.core.appstream.CSSURLValue;
import com.pandora.core.appstream.IASTParser;
import com.pandora.core.appstream.IValue;
import com.pandora.core.appstream.RelationTree;
import com.pandora.core.utils.StringUtil;
import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.graphics.Point;

public class CSSASTParser
extends AbstractNestedASTParser
implements IASTParser {
    private static final Pattern cssUrlPattern = Pattern.compile("url\\(([^\\(\\)])*\\)");

    public boolean processAST(IFile file, RelationTree tree, IProject project, Set<URI> visitedUris) {
        try {
            String contents = IOUtil.read((InputStream)file.getContents(), (String)file.getCharset());
            String[] lines = contents.split("\n");
            this.processPattern(tree, lines, false, 0);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
        }
        return false;
    }

    public boolean processNestedAST(IFile file, Object astRoot, RelationTree tree, IProject project) {
        if (astRoot instanceof CSSParseRootNode) {
            CSSParseRootNode root = (CSSParseRootNode)((Object)astRoot);
            try {
                String contents = IOUtil.read((InputStream)file.getContents(), (String)file.getCharset());
                String styleContent = contents.substring(root.getStartingOffset(), root.getEndingOffset());
                String[] lines = styleContent.split("\n");
                this.processPattern(tree, lines, true, root.getStartingOffset());
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
            }
        }
        return false;
    }

    protected void processPattern(RelationTree tree, String[] lines, boolean isNested, int start) {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String lineStr = stringArray[n2];
            if (StringUtil.isEmpty((String)lineStr)) {
                start = start + lineStr.length() + 1;
            } else if (lineStr.length() <= 5) {
                start = start + lineStr.length() + 1;
            } else {
                Matcher cssUrlMatcher = cssUrlPattern.matcher(lineStr);
                while (cssUrlMatcher.find()) {
                    String strings = cssUrlMatcher.group();
                    try {
                        String strContents;
                        if (strings.length() <= 5 || (strContents = strings.substring(4, strings.length() - 1)).length() > 200) continue;
                        CSSURLValue value = new CSSURLValue(strContents, isNested);
                        value.setRange(new Point(start + cssUrlMatcher.regionStart() + 4, start + cssUrlMatcher.regionEnd() - 1));
                        tree.addValue((IValue)value);
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
                    }
                }
            }
            ++n2;
        }
    }
}

