/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public final class VersionUtil {
    private static final String VERSION_SPLIT_PATTERN = "(\\d+)\\.(\\d+)(\\.(\\d+))?";
    private static Pattern VERSION_DOT_PATTERN = Pattern.compile("\\.");

    private VersionUtil() {
    }

    public static int compareVersions(String left, String right) {
        String[] lparts = VERSION_DOT_PATTERN.split(left);
        String[] rparts = VERSION_DOT_PATTERN.split(right);
        int i = 0;
        while (i < lparts.length && i < rparts.length) {
            int result;
            try {
                Integer lInt = Integer.valueOf(lparts[i]);
                Integer rInt = Integer.valueOf(rparts[i]);
                result = lInt.compareTo(rInt);
            }
            catch (NumberFormatException numberFormatException) {
                result = lparts[i].compareToIgnoreCase(rparts[i]);
            }
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return lparts.length - rparts.length;
    }

    public static Version parseVersion(String rawOutput) {
        Pattern pattern = Pattern.compile(VERSION_SPLIT_PATTERN);
        Matcher matcher = pattern.matcher(rawOutput);
        if (matcher.find()) {
            String version = matcher.group();
            try {
                return Version.parseVersion((String)version);
            }
            catch (IllegalArgumentException iae) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), "Error parsing the version string - " + version, iae);
            }
        }
        return null;
    }

    public static boolean isCompatibleVersions(String[] installedVersions, String[] requiredVersions) {
        if (installedVersions == null || requiredVersions == null) {
            return requiredVersions != null && requiredVersions.length > 0;
        }
        HashMap<String, Version> installed = new HashMap<String, Version>();
        String[] stringArray = installedVersions;
        int n = installedVersions.length;
        int n2 = 0;
        while (n2 < n) {
            String installedVer = stringArray[n2];
            try {
                Version version = VersionUtil.getVersion(installedVer);
                if (version != null) {
                    installed.put(installedVer, version);
                } else {
                    installed.put(installedVer, Version.emptyVersion);
                }
            }
            catch (Exception exception) {
                IdeLog.logWarning((Plugin)CorePlugin.getDefault(), MessageFormat.format("Error parsing the installed version {0}", installedVer));
            }
            ++n2;
        }
        stringArray = requiredVersions;
        n = requiredVersions.length;
        n2 = 0;
        while (n2 < n) {
            String required = stringArray[n2];
            if (VersionUtil.isRange(required) ? !VersionUtil.isCompatibleVersionsRange(installed, required) : !VersionUtil.isCompatibleVersionsRegex(installed, required)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isCompatibleVersions(String version, String versionRange) {
        return VersionUtil.isCompatibleVersions(new String[]{version}, new String[]{versionRange});
    }

    private static boolean isCompatibleVersionsRegex(Map<String, Version> installed, String required) {
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(required);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), MessageFormat.format("The required version '{0}' should be defined as a regular-expression", required));
            return false;
        }
        for (String installedVersion : installed.keySet()) {
            Matcher matcher = pattern.matcher(installedVersion);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    private static boolean isCompatibleVersionsRange(Map<String, Version> installed, String required) {
        VersionRange versionRange = new VersionRange(required);
        for (Version installedVersion : installed.values()) {
            if (!versionRange.isIncluded(installedVersion)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isRange(String versionString) {
        if ((versionString = versionString.trim()).charAt(0) == '[' || versionString.charAt(0) == '(') {
            int comma = versionString.indexOf(44);
            if (comma < 0) {
                return false;
            }
            char last = versionString.charAt(versionString.length() - 1);
            return last == ']' || last == ')';
        }
        return false;
    }

    public static Version getVersion(String version) {
        return VersionUtil.parseVersion(version);
    }
}

