/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SocketUtil {
    private static final Pattern IPV4_PATTERN = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");

    private SocketUtil() {
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int findFreePort(InetAddress address) {
        ServerSocket socket = null;
        socket = new ServerSocket(0, 0, address);
        socket.setReuseAddress(true);
        int n = socket.getLocalPort();
        if (socket == null) return n;
        try {
            socket.close();
            return n;
        }
        catch (IOException iOException) {}
        return n;
        catch (IOException iOException) {
            try {
                if (socket == null) return -1;
            }
            catch (Throwable throwable) {
                if (socket == null) throw throwable;
                try {
                    socket.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                socket.close();
                return -1;
            }
            catch (IOException iOException3) {}
            return -1;
        }
    }

    /*
     * Exception decompiling
     */
    public static int findFreePort(InetAddress address, int start, int end) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isValidIPv4(String ip) {
        Matcher ipMatcher = IPV4_PATTERN.matcher(ip);
        if (ipMatcher.matches()) {
            String[] segments;
            String[] stringArray = segments = ip.split("\\.");
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                try {
                    int segment = Integer.parseInt(s);
                    if (segment < 0 || segment > 255) {
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public static InetAddress[] getLocalAddresses() {
        ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> e1 = NetworkInterface.getNetworkInterfaces();
            while (e1.hasMoreElements()) {
                NetworkInterface iface = e1.nextElement();
                Enumeration<InetAddress> e2 = iface.getInetAddresses();
                while (e2.hasMoreElements()) {
                    InetAddress inetAddr = e2.nextElement();
                    if (!(inetAddr instanceof Inet4Address) || addrs.contains(inetAddr)) continue;
                    if (!inetAddr.isLoopbackAddress()) {
                        addrs.add(0, inetAddr);
                        continue;
                    }
                    addrs.add(inetAddr);
                }
            }
        }
        catch (SocketException socketException) {}
        return addrs.toArray(new InetAddress[addrs.size()]);
    }

    public static InetAddress[] getNonLoopbackLocalAdresses() {
        ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
        InetAddress[] inetAddressArray = SocketUtil.getLocalAddresses();
        int n = inetAddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            InetAddress inetAddr = inetAddressArray[n2];
            if (!inetAddr.isLoopbackAddress()) {
                if (SocketUtil.isPublic(inetAddr)) {
                    addrs.add(0, inetAddr);
                } else {
                    addrs.add(inetAddr);
                }
            }
            ++n2;
        }
        return addrs.toArray(new InetAddress[addrs.size()]);
    }

    private static boolean isPublic(InetAddress inetAddress) {
        String hostAddress = inetAddress.getHostAddress();
        if (hostAddress.startsWith("10.") || hostAddress.startsWith("192.168.") || hostAddress.startsWith("169.254.") || hostAddress.startsWith("127.")) {
            return false;
        }
        if (hostAddress.startsWith("172.")) {
            return inetAddress.getAddress()[1] < 16 || inetAddress.getAddress()[1] > 31;
        }
        return true;
    }
}

