/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.CorePlugin;
import com.aptana.core.internal.platform.CoreMacOSX;
import com.aptana.core.internal.platform.CoreNatives;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public final class PlatformUtil {
    private static final ProcessItem[] NO_PROCESS_ITEMS;
    private static volatile boolean closing;
    private static boolean IS_WINDOWS_XP;
    public static final PlatformOs platform;
    public static final String DESKTOP_DIRECTORY = "%DesktopDirectory%";
    public static final String LOCAL_APPDATA = "%LOCAL_APPDATA%";
    public static final String COMMON_APPDATA = "%COMMON_APPDATA%";
    public static final String DOCUMENTS_DIRECTORY = "%DocumentsDirectory%";
    public static final String HOME_DIRECTORY;

    static {
        PlatformOs tempPlatform;
        NO_PROCESS_ITEMS = new ProcessItem[0];
        closing = false;
        IS_WINDOWS_XP = false;
        String env = System.getProperty("os.name").toLowerCase();
        if (CorePlugin.getDefault() != null) {
            String os = Platform.getOS();
            tempPlatform = os.equals("win32") ? PlatformOs.WINDOWS : (os.equals("macosx") ? PlatformOs.MAC : PlatformOs.LINUX);
            if ("windows xp".equals(env)) {
                IS_WINDOWS_XP = true;
            }
        } else {
            tempPlatform = env.indexOf("win") != -1 ? PlatformOs.WINDOWS : (env.startsWith("mac os") ? PlatformOs.MAC : PlatformOs.LINUX);
            if ("windows xp".equals(env)) {
                IS_WINDOWS_XP = true;
            }
        }
        platform = tempPlatform;
        HOME_DIRECTORY = PlatformUtil.isWindows() ? "%USERPROFILE%" : "~";
    }

    public static boolean isWindows() {
        return platform == PlatformOs.WINDOWS;
    }

    public static boolean isWindowsXP() {
        return IS_WINDOWS_XP;
    }

    public static boolean isMac() {
        return platform == PlatformOs.MAC;
    }

    public static boolean isLinux() {
        return platform == PlatformOs.LINUX;
    }

    private PlatformUtil() {
    }

    /*
     * Loose catch block
     */
    public static ProcessItem[] getRunningProcesses() {
        block53: {
            if ("win32".equals(Platform.getOS())) {
                try {
                    Object[] namesWithIDs = CoreNatives.GetProcessList();
                    if (namesWithIDs != null) {
                        ArrayList<ProcessItem> list = new ArrayList<ProcessItem>();
                        int i = 0;
                        while (i < namesWithIDs.length - 2) {
                            list.add(new ProcessItem((String)namesWithIDs[i], (Integer)namesWithIDs[i + 1], (Integer)namesWithIDs[i + 2]));
                            i += 3;
                        }
                        return list.toArray(new ProcessItem[list.size()]);
                    }
                }
                catch (UnsatisfiedLinkError e) {
                    IdeLog.logError((Plugin)CorePlugin.getDefault(), Messages.PlatformUtils_CoreLibraryNotFound, e);
                }
            } else {
                if ("linux".equals(Platform.getOS())) {
                    ProcessItem[] processItemArray2;
                    BufferedReader reader3;
                    Process process3;
                    block54: {
                        String line22;
                        process3 = null;
                        reader3 = null;
                        process3 = Runtime.getRuntime().exec("/bin/ps --no-headers xo pid:1,ppid:1,args");
                        InputStream in = process3.getInputStream();
                        reader3 = new LineNumberReader(new InputStreamReader(in, "ISO-8859-1"));
                        ArrayList<ProcessItem> list = new ArrayList<ProcessItem>();
                        while ((line22 = ((LineNumberReader)reader3).readLine()) != null) {
                            int index = line22.indexOf(32);
                            if (index <= 0) continue;
                            int pid2 = Integer.parseInt(line22.substring(0, index));
                            if ((index = (line22 = line22.substring(index + 1).trim()).indexOf(32)) <= 0) continue;
                            int ppid = Integer.parseInt(line22.substring(0, index));
                            if ((index = (line22 = line22.substring(index + 1).trim()).indexOf(32)) > 0) {
                                line22 = line22.substring(0, index);
                            }
                            list.add(new ProcessItem(line22.trim(), pid2, ppid));
                        }
                        processItemArray2 = list.toArray(new ProcessItem[list.size()]);
                        if (reader3 == null) break block54;
                        try {
                            reader3.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (process3 != null) {
                        process3.destroy();
                    }
                    return processItemArray2;
                    catch (IOException iOException) {
                        block55: {
                            try {
                                if (reader3 == null) break block55;
                            }
                            catch (Throwable throwable) {
                                if (reader3 != null) {
                                    try {
                                        reader3.close();
                                    }
                                    catch (IOException iOException2) {}
                                }
                                if (process3 != null) {
                                    process3.destroy();
                                }
                                throw throwable;
                            }
                            try {
                                reader3.close();
                            }
                            catch (IOException iOException3) {}
                        }
                        if (process3 != null) {
                            process3.destroy();
                        }
                        break block53;
                    }
                }
                if ("macosx".equals(Platform.getOS())) {
                    ProcessItem[] processItemArray;
                    BufferedReader reader2;
                    BufferedReader reader;
                    Process process2;
                    Process process;
                    block56: {
                        int pid;
                        String line;
                        process = null;
                        process2 = null;
                        reader = null;
                        reader2 = null;
                        process = Runtime.getRuntime().exec("/usr/bin/perl", new String[]{"VERSIONER_PERL_PREFER_32_BIT=yes"});
                        InputStream in = process.getInputStream();
                        OutputStream out = process.getOutputStream();
                        String command = "use Mac::Processes; while ( ($psn, $psi) = each(%Process) ) { print GetProcessPID($psi->processNumber).\" \".$psi->processAppSpec.\"\\n\"; }";
                        out.write(command.getBytes("ISO-8859-1"));
                        out.close();
                        reader = new LineNumberReader(new InputStreamReader(in, "ISO-8859-1"));
                        process2 = Runtime.getRuntime().exec("/bin/ps xo pid=,ppid=,command=");
                        reader2 = new LineNumberReader(new InputStreamReader(process2.getInputStream(), "ISO-8859-1"));
                        HashMap<Integer, Integer> pid2ppid = new HashMap<Integer, Integer>();
                        HashMap<Integer, String> pid2command = new HashMap<Integer, String>();
                        while ((line = ((LineNumberReader)reader2).readLine()) != null) {
                            int index = (line = line.trim()).indexOf(32);
                            if (index <= 0) continue;
                            pid = Integer.parseInt(line.substring(0, index));
                            line = line.substring(index + 1).trim();
                            index = line.indexOf(32);
                            int ppid = Integer.parseInt(line.substring(0, index));
                            line = line.substring(index + 1).trim();
                            pid2ppid.put(pid, ppid);
                            pid2command.put(pid, line.trim());
                        }
                        ArrayList<ProcessItem> list = new ArrayList<ProcessItem>();
                        while ((line = ((LineNumberReader)reader).readLine()) != null) {
                            int index = line.indexOf(32);
                            if (index <= 0) continue;
                            int pid2 = Integer.parseInt(line.substring(0, index));
                            pid2command.put(pid2, line.substring(index + 1).trim());
                        }
                        Iterator iterator = pid2command.keySet().iterator();
                        while (iterator.hasNext()) {
                            pid = (Integer)iterator.next();
                            Integer ppid = (Integer)pid2ppid.get(pid);
                            list.add(new ProcessItem((String)pid2command.get(pid), pid, ppid != null ? ppid : 0));
                        }
                        processItemArray = list.toArray(new ProcessItem[list.size()]);
                        if (reader == null) break block56;
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (reader2 != null) {
                        try {
                            reader2.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (process != null) {
                        process.destroy();
                    }
                    if (process2 != null) {
                        process2.destroy();
                    }
                    return processItemArray;
                    catch (IOException iOException) {
                        block57: {
                            try {
                                if (reader == null) break block57;
                            }
                            catch (Throwable throwable) {
                                if (reader != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (IOException iOException4) {}
                                }
                                if (reader2 != null) {
                                    try {
                                        reader2.close();
                                    }
                                    catch (IOException iOException5) {}
                                }
                                if (process != null) {
                                    process.destroy();
                                }
                                if (process2 != null) {
                                    process2.destroy();
                                }
                                throw throwable;
                            }
                            try {
                                reader.close();
                            }
                            catch (IOException iOException6) {}
                        }
                        if (reader2 != null) {
                            try {
                                reader2.close();
                            }
                            catch (IOException iOException7) {}
                        }
                        if (process != null) {
                            process.destroy();
                        }
                        if (process2 != null) {
                            process2.destroy();
                        }
                    }
                }
            }
        }
        return NO_PROCESS_ITEMS;
    }

    public static ProcessItem[] getRunningChildProcesses() {
        ProcessItem[] allProcesses;
        int currentPid;
        block28: {
            currentPid = 0;
            allProcesses = PlatformUtil.getRunningProcesses();
            if ("win32".equals(Platform.getOS())) {
                try {
                    currentPid = CoreNatives.GetCurrentProcessId();
                }
                catch (UnsatisfiedLinkError e) {
                    IdeLog.logError((Plugin)CorePlugin.getDefault(), Messages.PlatformUtils_CoreLibraryNotFound, e);
                }
            } else if ("linux".equals(Platform.getOS()) || "macosx".equals(Platform.getOS())) {
                Process process = null;
                BufferedReader reader = null;
                try {
                    try {
                        String line;
                        process = Runtime.getRuntime().exec("/bin/ps xo ppid=,command=");
                        InputStream in = process.getInputStream();
                        reader = new LineNumberReader(new InputStreamReader(in, "ISO-8859-1"));
                        while ((line = ((LineNumberReader)reader).readLine()) != null) {
                            int index = (line = line.trim()).indexOf(32);
                            if (index <= 0) continue;
                            try {
                                int pid = Integer.parseInt(line.substring(0, index));
                                line = line.substring(index + 1).trim();
                                if (!line.startsWith("/bin/ps xo ppid")) continue;
                                currentPid = pid;
                                break;
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    }
                    catch (IOException iOException) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        if (process != null) {
                            process.destroy();
                        }
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (process != null) {
                        process.destroy();
                    }
                    throw throwable;
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (process != null) {
                    process.destroy();
                }
            }
        }
        if (currentPid != 0) {
            ArrayList<ProcessItem> list = new ArrayList<ProcessItem>();
            int i = 0;
            while (i < allProcesses.length) {
                if (allProcesses[i].parentId == currentPid && allProcesses[i].pid != currentPid) {
                    list.add(allProcesses[i]);
                }
                ++i;
            }
            return list.toArray(new ProcessItem[list.size()]);
        }
        return NO_PROCESS_ITEMS;
    }

    public static void killProcess(int pid) {
        PlatformUtil.killProcess(pid, 9);
    }

    public static void killProcess(int pid, int signal) {
        if (pid == 0) {
            return;
        }
        if ("win32".equals(Platform.getOS())) {
            try {
                CoreNatives.KillProcess(pid);
            }
            catch (UnsatisfiedLinkError e) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), Messages.PlatformUtils_CoreLibraryNotFound, e);
            }
        } else if ("linux".equals(Platform.getOS()) || "macosx".equals(Platform.getOS())) {
            try {
                Runtime.getRuntime().exec(MessageFormat.format("/bin/kill -{0} {1}", Integer.toString(signal & 0xF), Long.toString((long)pid & 0xFFFFFFFFFFFFFFFFL)));
            }
            catch (IOException iOException) {}
        }
    }

    public static synchronized String expandEnvironmentStrings(String path) {
        String home;
        if ("win32".equals(Platform.getOS())) {
            String commonAppData;
            String expanded = CoreNatives.ExpandEnvironmentStrings(path);
            if (expanded != null) {
                path = expanded;
            }
            if (path.startsWith(DESKTOP_DIRECTORY)) {
                String desktopDirectory = CoreNatives.GetSpecialFolderPath(16);
                if (desktopDirectory != null) {
                    path = String.valueOf(desktopDirectory) + path.substring(DESKTOP_DIRECTORY.length());
                }
            } else if (path.startsWith(LOCAL_APPDATA)) {
                String localAppData = CoreNatives.GetSpecialFolderPath(28);
                if (localAppData != null) {
                    path = String.valueOf(localAppData) + path.substring(LOCAL_APPDATA.length());
                }
            } else if (path.startsWith(COMMON_APPDATA) && (commonAppData = CoreNatives.GetSpecialFolderPath(35)) != null) {
                path = String.valueOf(commonAppData) + path.substring(COMMON_APPDATA.length());
            }
        } else if ("macosx".equals(Platform.getOS())) {
            String docsDirectory;
            if (path.startsWith(DESKTOP_DIRECTORY)) {
                String desktopDirectory = CoreMacOSX.FileManager_findFolder(true, "desk");
                if (desktopDirectory != null) {
                    path = String.valueOf(desktopDirectory) + path.substring(DESKTOP_DIRECTORY.length());
                }
            } else if (path.startsWith(DOCUMENTS_DIRECTORY) && (docsDirectory = CoreMacOSX.FileManager_findFolder(true, "docs")) != null) {
                path = String.valueOf(docsDirectory) + path.substring(DOCUMENTS_DIRECTORY.length());
            }
        }
        if (path.length() > 0 && path.charAt(0) == '~' && (home = System.getProperty("user.home")) != null) {
            return String.valueOf(home) + path.substring(1);
        }
        return path;
    }

    public static String queryRegestryStringValue(String keyName, String valueName) {
        if ("win32".equals(Platform.getOS())) {
            long hRootKey;
            if (keyName.startsWith("HKCR\\") || keyName.startsWith("HKEY_CLASSES_ROOT\\")) {
                hRootKey = Integer.MIN_VALUE;
            } else if (keyName.startsWith("HKLM\\") || keyName.startsWith("HKEY_LOCAL_MACHINE\\")) {
                hRootKey = -2147483646L;
            } else if (keyName.startsWith("HKCU\\") || keyName.startsWith("HKEY_CURRENT_USER\\")) {
                hRootKey = -2147483647L;
            } else {
                throw new IllegalArgumentException("Invalid regestry key name");
            }
            keyName = keyName.substring(keyName.indexOf(92) + 1);
            long[] hKey = new long[1];
            if (CoreNatives.RegOpenKey(hRootKey, keyName, 131097, hKey)) {
                String[] result = new String[1];
                CoreNatives.RegQueryValue(hKey[0], valueName, result);
                CoreNatives.RegCloseKey(hKey[0]);
                return result[0];
            }
        }
        return null;
    }

    public static boolean setRegestryStringValue(String keyName, String valueName, String value) {
        if ("win32".equals(Platform.getOS())) {
            long hRootKey;
            if (keyName.startsWith("HKCR\\") || keyName.startsWith("HKEY_CLASSES_ROOT\\")) {
                hRootKey = Integer.MIN_VALUE;
            } else if (keyName.startsWith("HKLM\\") || keyName.startsWith("HKEY_LOCAL_MACHINE\\")) {
                hRootKey = -2147483646L;
            } else if (keyName.startsWith("HKCU\\") || keyName.startsWith("HKEY_CURRENT_USER\\")) {
                hRootKey = -2147483647L;
            } else {
                throw new IllegalArgumentException("Invalid regestry key name");
            }
            keyName = keyName.substring(keyName.indexOf(92) + 1);
            long[] hKey = new long[1];
            if (CoreNatives.RegCreateKey(hRootKey, keyName, 131078, hKey)) {
                boolean result = CoreNatives.RegSetValue(hKey[0], valueName, value);
                CoreNatives.RegCloseKey(hKey[0]);
                return result;
            }
        }
        return false;
    }

    public static boolean isUserAdmin() {
        if ("win32".equals(Platform.getOS())) {
            return CoreNatives.IsUserAnAdmin();
        }
        return false;
    }

    public static boolean runAsAdmin(String program, String[] arguments) {
        if ("win32".equals(Platform.getOS())) {
            StringBuffer sb = null;
            if (arguments != null && arguments.length > 0) {
                sb = new StringBuffer();
                int i = 0;
                while (i < arguments.length) {
                    String arg = arguments[i];
                    if (arg.indexOf(32) != -1) {
                        sb.append('\"').append(arg).append('\"');
                    } else {
                        sb.append(arg);
                    }
                    sb.append(' ');
                    ++i;
                }
            }
            return CoreNatives.ShellExecuteEx(program, sb != null ? sb.toString() : null, "runas", null, 1);
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static String getApplicationInfo(String applicationPath, String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static File getApplicationExecutable(String applicationPath) {
        File file = new File(applicationPath);
        if ("macosx".equals(Platform.getOS())) {
            if (!file.isDirectory()) {
                return file;
            }
            String executable = PlatformUtil.getApplicationInfo(applicationPath, "CFBundleExecutable");
            if (executable != null) {
                File file2 = new File(file, "Contents/MacOSX/" + executable);
                if (file2.exists()) {
                    return file2;
                }
                file2 = new File(file, "Contents/MacOS/" + executable);
                if (file2.exists()) {
                    return file2;
                }
            }
        }
        return file;
    }

    public static boolean isOSName(String targetOsName) {
        String osName;
        block33: {
            osName = Platform.getOS();
            if (osName.equals("linux")) {
                try {
                    File f = new File("/etc/lsb-release");
                    if (f.canRead()) {
                        Properties props = new Properties();
                        props.load(new FileInputStream(f));
                        osName = props.getProperty("DISTRIB_ID");
                        break block33;
                    }
                    f = new File("/etc/redhat-release");
                    if (f.canRead()) {
                        BufferedReader in = null;
                        try {
                            try {
                                in = new BufferedReader(new FileReader(f));
                                String line = in.readLine();
                                int index = line.indexOf(" release");
                                if (index >= 0) {
                                    osName = line.substring(0, index);
                                }
                            }
                            catch (Exception exception) {
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block33;
                            }
                        }
                        catch (Throwable throwable) {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block33;
                    }
                    f = new File("/etc/SuSE-release");
                    if (!f.canRead()) break block33;
                    BufferedReader in = null;
                    try {
                        try {
                            in = new BufferedReader(new FileReader(f));
                            osName = in.readLine();
                        }
                        catch (Exception exception) {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block33;
                        }
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (osName != null) {
            return osName.equals(targetOsName);
        }
        return false;
    }

    public static void setClosing(boolean iClosing) {
        closing = iClosing;
    }

    public static boolean isClosing() {
        return closing;
    }

    public static enum PlatformOs {
        WINDOWS,
        MAC,
        LINUX;

    }

    public static class ProcessItem {
        private String executableName;
        private int pid;
        private int parentId;

        private ProcessItem(String executableName, int pid, int parentId) {
            this.executableName = executableName;
            this.pid = pid;
            this.parentId = parentId;
        }

        public String getExecutableName() {
            return this.executableName;
        }

        public int getPid() {
            return this.pid;
        }

        public String toString() {
            return "[" + this.pid + "] " + this.executableName;
        }
    }
}

