/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.IObjectPool;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;

public abstract class KeepAliveObjectPool<T>
implements IObjectPool<T> {
    private final List<T> locked;
    private final Map<T, Long> unlocked;
    private final ConnectionReaper reaper;
    private final int releaseTime;

    public KeepAliveObjectPool(int releaseTime) {
        this.releaseTime = releaseTime;
        this.locked = new ArrayList<T>();
        this.unlocked = new LinkedHashMap<T, Long>();
        this.reaper = new ConnectionReaper();
    }

    protected void start() {
        this.reaper.start();
    }

    @Override
    public synchronized void checkIn(T t) {
        this.locked.remove(t);
        this.unlocked.put(t, System.currentTimeMillis());
    }

    @Override
    public synchronized T checkOut() {
        Object c2;
        for (Object c2 : this.unlocked.keySet()) {
            if (!this.validate(c2)) continue;
            this.unlocked.remove(c2);
            this.locked.add(c2);
            return c2;
        }
        c2 = this.create();
        this.locked.add(c2);
        return c2;
    }

    @Override
    public synchronized void dispose() {
        for (T c : this.unlocked.keySet()) {
            this.expire(c);
        }
        this.unlocked.clear();
        if (this.locked.size() > 0) {
            IdeLog.logWarning((Plugin)CorePlugin.getDefault(), MessageFormat.format("Killed a connection pool that still has {0} locked items", this.locked.size()));
            this.locked.clear();
        }
        this.reaper.exit();
    }

    protected synchronized void reap() {
        long now = System.currentTimeMillis();
        for (T c : this.unlocked.keySet()) {
            if (now - this.unlocked.get(c) > (long)this.timeToRelease()) {
                this.unlocked.remove(c);
                this.expire(c);
                continue;
            }
            if (this.validate(c)) continue;
            this.unlocked.remove(c);
            this.expire(c);
        }
    }

    private int timeToRelease() {
        int divider = this.unlocked.size() + this.locked.size() ^ 2;
        return this.releaseTime / (divider > 0 ? divider : 1);
    }

    private class ConnectionReaper
    extends Thread {
        private static final long INTERVAL = 15000L;
        private boolean isRunning = true;

        @Override
        public void run() {
            while (this.isRunning) {
                try {
                    ConnectionReaper.sleep(15000L);
                }
                catch (InterruptedException interruptedException) {}
                KeepAliveObjectPool.this.reap();
            }
        }

        public void exit() {
            this.isRunning = false;
        }
    }
}

