/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.core.internal.events.BuildManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class BuildUtil {
    private static final String BUILD_METHOD_NAME = "build";
    private static final String BUILD_CONFIGURATION_37_CLASS_NAME = "org.eclipse.core.internal.resources.BuildConfiguration";
    private static Class buildConfigurationClass;

    static {
        try {
            Bundle b = ResourcesPlugin.getPlugin().getBundle();
            buildConfigurationClass = b.loadClass(BUILD_CONFIGURATION_37_CLASS_NAME);
        }
        catch (Throwable throwable) {}
    }

    public static IStatus syncBuild(IProject project, int kind, String builderName, Map args, IProgressMonitor monitor) {
        try {
            if (buildConfigurationClass == null) {
                return BuildUtil.syncBuild36(project, kind, builderName, args, monitor);
            }
            return BuildUtil.syncBuild37(project, kind, builderName, args, monitor);
        }
        catch (Exception e) {
            return new Status(4, "com.aptana.core", "Error while invoking a synchronous builder", (Throwable)e);
        }
    }

    private static IStatus syncBuild36(IProject project, int kind, String builderName, Map args, IProgressMonitor monitor) throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        BuildManager buildManager = ((Workspace)workspace).getBuildManager();
        Method buildMethod = buildManager.getClass().getMethod(BUILD_METHOD_NAME, IProject.class, Integer.TYPE, String.class, Map.class, IProgressMonitor.class);
        return (IStatus)buildMethod.invoke((Object)buildManager, project, kind, builderName, args, monitor);
    }

    private static IStatus syncBuild37(IProject project, int kind, String builderName, Map args, IProgressMonitor monitor) throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        BuildManager buildManager = ((Workspace)workspace).getBuildManager();
        Method buildMethod = buildManager.getClass().getMethod(BUILD_METHOD_NAME, buildConfigurationClass, Integer.TYPE, String.class, Map.class, IProgressMonitor.class);
        Object buildConfigurationInstance = buildConfigurationClass.getConstructor(IProject.class).newInstance(project);
        return (IStatus)buildMethod.invoke((Object)buildManager, buildConfigurationInstance, kind, builderName, args, monitor);
    }

    public static void asyncBuild(IProject project, int kind, String builderName, Map args, IProgressMonitor monitor) throws CoreException {
        project.build(kind, builderName, args, monitor);
    }
}

