/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.internal.resources;

import com.aptana.core.CorePlugin;
import com.aptana.core.internal.resources.MarkerDelta;
import com.aptana.core.internal.resources.MarkerInfo;
import com.aptana.core.internal.resources.MarkerSet;
import com.aptana.core.internal.resources.Messages;
import com.aptana.core.internal.resources.ResourceInfo;
import com.aptana.core.internal.resources.UniformResourceChangeEvent;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.resources.IUniformResource;
import com.aptana.core.resources.IUniformResourceChangeListener;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.resources.IMarkerSetElement;
import org.eclipse.core.internal.resources.MarkerTypeDefinitionCache;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public final class MarkerManager {
    private static final MarkerInfo[] NO_MARKER_INFO = new MarkerInfo[0];
    private static MarkerManager instance;
    private MarkerTypeDefinitionCache cache = new MarkerTypeDefinitionCache();
    private long nextMarkerId = 0L;
    private Map resources = new HashMap();
    private ListenerList listeners = new ListenerList();
    private IMarker rootMarker;
    private Map currentDeltas = null;
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MarkerManager getInstance() {
        if (instance != null) return instance;
        Class<MarkerManager> clazz = MarkerManager.class;
        synchronized (MarkerManager.class) {
            if (instance != null) return instance;
            instance = new MarkerManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private MarkerManager() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                MarkerManager.this.handleResourceChanged();
            }
        }, 8);
    }

    public MarkerInfo findMarkerInfo(IUniformResource resource, long id) {
        ResourceInfo info = this.getResourceInfo(resource);
        if (info == null) {
            return null;
        }
        MarkerSet markers = info.getMarkers(false);
        if (markers == null) {
            return null;
        }
        return (MarkerInfo)markers.get(id);
    }

    public void add(IUniformResource resource, MarkerInfo marker) throws CoreException {
        MarkerSet markers;
        ResourceInfo info = this.getResourceInfo(resource);
        if (info == null) {
            info = this.createResourceInfo(resource);
        }
        if ((markers = info.getMarkers(true)) == null) {
            markers = new MarkerSet(1);
        }
        this.basicAdd(resource, markers, marker);
        if (!markers.isEmpty()) {
            info.setMarkers(markers);
        }
        IMarkerSetElement[] changes = new IMarkerSetElement[]{new MarkerDelta(1, resource, marker)};
        this.changedMarkers(resource, changes);
    }

    public boolean isPersistent(MarkerInfo info) {
        if (!this.cache.isPersistent(info.getType())) {
            return false;
        }
        Object isTransient = info.getAttribute("transient");
        return isTransient == null || !(isTransient instanceof Boolean) || (Boolean)isTransient == false;
    }

    public void removeMarker(IUniformResource resource, long id) throws CoreException {
        MarkerInfo marker = this.findMarkerInfo(resource, id);
        if (marker == null) {
            return;
        }
        ResourceInfo info = this.getResourceInfo(resource);
        MarkerSet markers = info.getMarkers(true);
        if (markers != null) {
            int size = markers.size();
            markers.remove((IMarkerSetElement)marker);
            info.setMarkers(markers.size() == 0 ? null : markers);
            if (markers.size() != size) {
                IMarkerSetElement[] changes = new IMarkerSetElement[]{new MarkerDelta(2, resource, marker)};
                this.changedMarkers(resource, changes);
            }
        } else {
            IdeLog.logInfo(CorePlugin.getDefault(), MessageFormat.format("Could not remove the marker with the id {0}. The resource-info returned a null marker-set.", id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changedMarkers(IUniformResource resource, IMarkerSetElement[] changes) throws CoreException {
        if (changes == null || changes.length == 0) {
            return;
        }
        URI uri = resource.getURI();
        Object object = this.lock;
        synchronized (object) {
            MarkerSet previousChanges;
            MarkerSet result;
            if (this.currentDeltas == null) {
                this.currentDeltas = new HashMap();
            }
            if ((result = MarkerDelta.merge(previousChanges = (MarkerSet)((Object)this.currentDeltas.get(uri)), changes)).size() == 0) {
                this.currentDeltas.remove(uri);
            } else {
                this.currentDeltas.put(uri, result);
            }
        }
        if (this.getRootMarker() != null) {
            this.getRootMarker().setAttribute("updateId", this.getRootMarker().getAttribute("updateId", 0) + 1);
        }
    }

    protected synchronized IMarker getRootMarker() {
        if (this.rootMarker == null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            try {
                this.rootMarker = workspace.getRoot().createMarker("com.aptana.ide.internal.core.resources.ExternalResourcesMarker");
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), e);
            }
        }
        return this.rootMarker;
    }

    public boolean isSubtype(String type, String superType) {
        return this.cache.isSubtype(type, superType);
    }

    public MarkerInfo[] findMarkersInfo(IUniformResource resource, String type, boolean includeSubtypes) {
        ResourceInfo info = this.getResourceInfo(resource);
        if (info == null) {
            return NO_MARKER_INFO;
        }
        MarkerSet markers = info.getMarkers(false);
        if (markers == null) {
            return NO_MARKER_INFO;
        }
        IMarkerSetElement[] elements = markers.elements();
        ArrayList<MarkerInfo> result = new ArrayList<MarkerInfo>(elements.length);
        int i = 0;
        while (i < elements.length) {
            MarkerInfo marker = (MarkerInfo)elements[i];
            if (type == null) {
                result.add(marker);
            } else if (includeSubtypes) {
                if (this.isSubtype(marker.getType(), type)) {
                    result.add(marker);
                }
            } else if (marker.getType().equals(type)) {
                result.add(marker);
            }
            ++i;
        }
        if (result.size() == 0) {
            return NO_MARKER_INFO;
        }
        return result.toArray(new MarkerInfo[result.size()]);
    }

    private ResourceInfo getResourceInfo(IUniformResource resource) {
        return (ResourceInfo)this.resources.get(resource.getURI());
    }

    private ResourceInfo createResourceInfo(IUniformResource resource) {
        ResourceInfo info = new ResourceInfo();
        this.resources.put(resource.getURI(), info);
        return info;
    }

    private void basicAdd(IUniformResource resource, MarkerSet markers, MarkerInfo newMarker) throws CoreException {
        if (newMarker.getId() != -1L) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.core", 0, Messages.MarkerManager_MarkerIDIsDefined, null));
        }
        newMarker.setId(this.nextMarkerId());
        markers.add((IMarkerSetElement)newMarker);
    }

    private long nextMarkerId() {
        return this.nextMarkerId++;
    }

    public void addResourceChangeListener(IUniformResourceChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeResourceChangeListener(IUniformResourceChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResourceChanged() {
        MarkerSet[] markers;
        if (this.currentDeltas == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            markers = this.currentDeltas.values().toArray(new MarkerSet[this.currentDeltas.size()]);
            this.currentDeltas = null;
        }
        Object[] list = this.listeners.getListeners();
        int j = 0;
        while (j < markers.length) {
            Object[] deltas = new IMarkerDelta[markers[j].size()];
            markers[j].copyInto(deltas);
            IUniformResource resource = null;
            if (deltas.length > 0 && deltas[0] instanceof MarkerDelta) {
                resource = ((MarkerDelta)((Object)deltas[0])).getUniformResource();
            }
            UniformResourceChangeEvent event = new UniformResourceChangeEvent(this, resource, (IMarkerDelta[])deltas);
            int i = 0;
            while (i < list.length) {
                try {
                    ((IUniformResourceChangeListener)list[i]).resourceChanged(event);
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)CorePlugin.getDefault(), e);
                }
                ++i;
            }
            ++j;
        }
    }
}

