/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.internal.preferences;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final String MIGRATED_AUTO_REFRESH = "migrated_auto_refresh";

    public void initializeDefaultPreferences() {
        IEclipsePreferences prefs = EclipseUtil.defaultScope().getNode("com.aptana.core");
        prefs.putBoolean("show_system_jobs", false);
        if (Platform.inDebugMode()) {
            prefs.put("pref_debug_level", IdeLog.StatusLevel.INFO.toString());
        } else {
            prefs.put("pref_debug_level", IdeLog.StatusLevel.ERROR.toString());
        }
        prefs.put("web_files", "*.js;*.htm;*.html;*.xhtm;*.xhtml;*.css;*.xml;*.xsl;*.xslt;*.fla;*.gif;*.jpg;*.jpeg;*.php;*.asp;*.jsp;*.png;*.as;*.sdoc;*.swf;*.shtml;*.txt;*.aspx;*.asmx;");
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), e);
        }
        prefs = EclipseUtil.instanceScope().getNode("com.aptana.core");
        boolean migrated = prefs.getBoolean(MIGRATED_AUTO_REFRESH, false);
        if (!migrated) {
            boolean autoRefresh = true;
            String oldValue = prefs.get("auto_refresh_projects", null);
            if (oldValue != null) {
                autoRefresh = Boolean.valueOf(oldValue);
            }
            ResourcesPlugin.getPlugin().getPluginPreferences().setValue("refresh.enabled", autoRefresh);
            ResourcesPlugin.getPlugin().getPluginPreferences().addPropertyChangeListener(new Preferences.IPropertyChangeListener(){

                public void propertyChange(Preferences.PropertyChangeEvent event) {
                    if ("refresh.enabled".equals(event.getProperty())) {
                        IEclipsePreferences ourPrefs = EclipseUtil.instanceScope().getNode("com.aptana.core");
                        ourPrefs.putBoolean(PreferenceInitializer.MIGRATED_AUTO_REFRESH, true);
                        try {
                            ourPrefs.flush();
                        }
                        catch (BackingStoreException e) {
                            IdeLog.logError((Plugin)CorePlugin.getDefault(), "Failed to store boolean to avoid overriding auto-refresh setting", e);
                        }
                        ResourcesPlugin.getPlugin().getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
                    }
                }
            });
        }
    }
}

