/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.build;

import org.eclipse.core.resources.IFile;

public class IndexBuildHelper {
    private static final long TIMEOUT = 300000L;
    public static ThreadLocal<IndexTime> localThread = new ThreadLocal();

    public static void startListening(boolean isSave, IFile file) {
        IndexTime indexTime = new IndexTime();
        indexTime.startTime = System.currentTimeMillis();
        indexTime.isSave = isSave;
        indexTime.indexFile = file;
        localThread.set(indexTime);
    }

    public static boolean isTimeout() {
        long reduceTime;
        IndexTime indexTime = localThread.get();
        return indexTime != null && (reduceTime = indexTime.getCurrentTime() - indexTime.startTime) >= 300000L && indexTime.isSave;
    }

    public static IndexTime getIndexTime() {
        return localThread.get();
    }

    public static class IndexTime {
        public long startTime = 0L;
        public IFile indexFile = null;
        public boolean isSave = false;

        public long getCurrentTime() {
            return System.currentTimeMillis();
        }
    }
}

