/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.build;

import com.aptana.core.Messages;
import java.util.Map;

public interface IProblem {
    public static final String ID = "id";
    public static final String FLAGS = "flags";
    public static final String ARGUMENTS = "arguments";

    public int getOffset();

    public int getLength();

    public int getLineNumber();

    public String getMessage();

    public Severity getSeverity();

    public int getPriority();

    public String getSourcePath();

    public Map<String, Object> createMarkerAttributes();

    public Map<String, Object> getAttributes();

    public void setAttribute(String var1, Object var2);

    public boolean isWarning();

    public boolean isError();

    public boolean isTask();

    public boolean isQuickFixable();

    public static enum Severity {
        IGNORE(-1, Messages.IProblem_Ignore),
        INFO(0, Messages.IProblem_Info),
        WARNING(1, Messages.IProblem_Warning),
        ERROR(2, Messages.IProblem_Error);

        private int num;
        private String label;

        private Severity(int num, String label) {
            this.num = num;
            this.label = label;
        }

        public int intValue() {
            return this.num;
        }

        public static Severity create(int value) {
            Severity[] severityArray = Severity.values();
            int n = severityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Severity s = severityArray[n2];
                if (s.num == value) {
                    return s;
                }
                ++n2;
            }
            return WARNING;
        }

        public static Severity create(String value) {
            Severity[] severityArray = Severity.values();
            int n = severityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Severity s = severityArray[n2];
                if (s.label.equals(value)) {
                    return s;
                }
                ++n2;
            }
            return WARNING;
        }

        public String label() {
            return this.label;
        }
    }
}

