/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.viewer;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.theme.ThemePlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Point;

public class IndentGuidePainter
implements IPainter,
PaintListener {
    protected boolean fIsActive = false;
    protected ITextViewer fTextViewer;
    protected StyledText fTextWidget;
    protected final boolean fIsAdvancedGraphicsPresent;
    protected int lineAlpha;
    protected int lineStyle;
    protected int lineWidth;
    protected int lineShift;
    protected int spaceWidth;
    protected boolean drawLeftEnd;
    protected boolean drawBlankLine;
    protected boolean skipCommentBlock;
    protected boolean initTabs = false;

    public IndentGuidePainter(ITextViewer textViewer) {
        this.fTextViewer = textViewer;
        this.fTextWidget = textViewer.getTextWidget();
        GC gc = new GC((Drawable)this.fTextWidget);
        gc.setAdvanced(true);
        this.fIsAdvancedGraphicsPresent = gc.getAdvanced();
        gc.dispose();
        this.lineAlpha = 65;
        this.lineStyle = 3;
        this.lineWidth = 1;
        this.lineShift = 1;
        this.drawLeftEnd = true;
        this.drawBlankLine = true;
        this.skipCommentBlock = false;
    }

    private void initTab(IDocument document) {
        try {
            if (this.initTabs) {
                return;
            }
            this.initTabs = true;
            int tabs = this.fTextWidget.getTabs();
            int lines = document.getNumberOfLines();
            int i = 0;
            while (i < lines) {
                IRegion region = document.getLineInformation(i);
                String lineContent = document.get(region.getOffset(), region.getLength());
                int count = this.countSpaces(lineContent, tabs);
                if (count > 0) {
                    if (count % tabs != 0 && count % 2 == 0) {
                        this.fTextWidget.setTabs(2);
                    }
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        this.fTextViewer = null;
        this.fTextWidget = null;
    }

    public void paint(int reason) {
        IDocument document = this.fTextViewer.getDocument();
        if (document == null) {
            this.deactivate(false);
            return;
        }
        this.initTab(document);
        if (!this.fIsActive) {
            this.fIsActive = true;
            this.fTextWidget.addPaintListener((PaintListener)this);
            this.redrawAll();
        } else if (reason == 16 || reason == 8) {
            this.redrawAll();
        } else if (reason == 1) {
            try {
                IRegion lineRegion = document.getLineInformationOfOffset(this.getDocumentOffset(this.fTextWidget.getCaretOffset()));
                int widgetOffset = this.getWidgetOffset(lineRegion.getOffset());
                int charCount = this.fTextWidget.getCharCount();
                int redrawLength = Math.min(lineRegion.getLength(), charCount - widgetOffset);
                if (widgetOffset >= 0 && redrawLength > 0) {
                    this.fTextWidget.redrawRange(widgetOffset, redrawLength, true);
                }
            }
            catch (BadLocationException badLocationException) {
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)e.getMessage());
            }
        }
    }

    public void deactivate(boolean redraw) {
        if (this.fIsActive) {
            this.fIsActive = false;
            this.fTextWidget.removePaintListener((PaintListener)this);
            if (redraw) {
                this.redrawAll();
            }
        }
    }

    public void setPositionManager(IPaintPositionManager manager) {
    }

    public void paintControl(PaintEvent event) {
        if (this.fTextWidget != null) {
            this.handleDrawRequest(event.gc, event.x, event.y, event.width, event.height);
        }
    }

    private void handleDrawRequest(GC gc, int x, int y, int w, int h) {
        int endLine;
        int startLine = this.fTextWidget.getLineIndex(y);
        if (startLine <= (endLine = this.fTextWidget.getLineIndex(y + h - 1)) && startLine < this.fTextWidget.getLineCount()) {
            Color fgColor = gc.getForeground();
            LineAttributes lineAttributes = gc.getLineAttributes();
            gc.setForeground(ThemePlugin.getDefault().getThemeManager().getCurrentTheme().getForegroundColor());
            gc.setLineStyle(this.lineStyle);
            gc.setLineWidth(this.lineWidth);
            if (this.fIsAdvancedGraphicsPresent) {
                int alpha = gc.getAlpha();
                gc.setAlpha(this.lineAlpha);
                this.drawLineRange(gc, startLine, endLine, x, w);
                gc.setAlpha(alpha);
            } else {
                this.drawLineRange(gc, startLine, endLine, x, w);
            }
            gc.setForeground(fgColor);
            gc.setLineAttributes(lineAttributes);
        }
    }

    protected void drawLineRange(GC gc, int startLine, int endLine, int x, int w) {
        int tabs = this.fTextWidget.getTabs();
        this.spaceWidth = gc.getAdvanceWidth(' ');
        StyledTextContent content = this.fTextWidget.getContent();
        int line = startLine;
        while (line <= endLine) {
            int widgetOffset = this.fTextWidget.getOffsetAtLine(line);
            if (!this.isFoldedLine(content.getLineAtOffset(widgetOffset))) {
                String text = this.fTextWidget.getLine(line);
                int extend = 0;
                if (this.skipCommentBlock && this.assumeCommentBlock(text, tabs)) {
                    extend -= tabs;
                }
                if (this.drawBlankLine && text.trim().length() == 0) {
                    int prevLine = line;
                    block1: while (--prevLine >= 0) {
                        text = this.fTextWidget.getLine(prevLine);
                        if (text.trim().length() <= 0) continue;
                        int postLine = line;
                        int lineCount = this.fTextWidget.getLineCount();
                        while (++postLine < lineCount) {
                            String tmp = this.fTextWidget.getLine(postLine);
                            if (tmp.trim().length() <= 0) continue;
                            if (this.countSpaces(text, tabs) >= this.countSpaces(tmp, tabs)) break block1;
                            extend += tabs;
                            break block1;
                        }
                        break block1;
                    }
                }
                int count = this.countSpaces(text, tabs) + extend;
                int i = this.drawLeftEnd ? 0 : tabs;
                while (i < count) {
                    this.draw(gc, widgetOffset, i, line);
                    i += tabs;
                }
            }
            ++line;
        }
    }

    protected int countSpaces(String str, int tabs) {
        int count = 0;
        int i = 0;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case ' ': {
                    ++count;
                    break;
                }
                case '\t': {
                    int z = tabs - count % tabs;
                    count += z;
                    break;
                }
                default: {
                    return count;
                }
            }
            ++i;
        }
        return count;
    }

    protected boolean assumeCommentBlock(String text, int tabs) {
        int count = this.countSpaces(text, tabs);
        count = count / tabs * tabs;
        int index = 0;
        int i = 0;
        while (i < count) {
            switch (text.charAt(index)) {
                case ' ': {
                    ++index;
                    break;
                }
                case '\t': {
                    ++index;
                    int z = tabs - i % tabs;
                    i += z;
                    break;
                }
                default: {
                    i = count;
                }
            }
            ++i;
        }
        return (text = text.substring(index)).matches("^ \\*([ \\t].*|/.*|)$");
    }

    protected boolean isFoldedLine(int widgetLine) {
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fTextViewer;
            int modelLine = extension.widgetLine2ModelLine(widgetLine);
            int widgetLine2 = extension.modelLine2WidgetLine(modelLine + 1);
            return widgetLine2 == -1;
        }
        return false;
    }

    private void redrawAll() {
        this.fTextWidget.redraw();
    }

    protected void draw(GC gc, int offset, int column, int line) {
        Point pos = this.fTextWidget.getLocationAtOffset(offset);
        pos.x += column * this.spaceWidth + this.lineShift;
        int lineHeight = this.fTextWidget.getLineHeight(offset);
        if (lineHeight % 2 == 0) {
            gc.drawLine(pos.x, pos.y, pos.x, pos.y + lineHeight - 1);
        } else {
            gc.drawLine(pos.x, pos.y + line % 2, pos.x, pos.y + lineHeight - line % 2);
        }
    }

    private int getWidgetOffset(int documentOffset) {
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fTextViewer;
            return extension.modelOffset2WidgetOffset(documentOffset);
        }
        IRegion visible = this.fTextViewer.getVisibleRegion();
        int widgetOffset = documentOffset - visible.getOffset();
        if (widgetOffset > visible.getLength()) {
            return -1;
        }
        return widgetOffset;
    }

    private int getDocumentOffset(int widgetOffset) {
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fTextViewer;
            return extension.widgetOffset2ModelOffset(widgetOffset);
        }
        IRegion visible = this.fTextViewer.getVisibleRegion();
        if (widgetOffset > visible.getLength()) {
            return -1;
        }
        return widgetOffset + visible.getOffset();
    }
}

