/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.util;

import beaver.Scanner;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.parsing.AbstractFlexTokenScanner;
import com.aptana.editor.common.parsing.CompositeTokenScanner;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.aptana.ui.util.UIUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collections;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.GapTextStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.editors.text.ILocationProviderExtension;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public class EditorUtil {
    protected static final int DEFAULT_SPACE_INDENT_SIZE = 2;

    public static int getSpaceIndentSize() {
        IEditorPart activeEditor = UIUtils.getActiveEditor();
        if (activeEditor != null) {
            return EditorUtil.getSpaceIndentSize(activeEditor.getSite().getId());
        }
        return EditorUtil.getSpaceIndentSize(null);
    }

    public static int getSpaceIndentSize(String preferencesQualifier) {
        int spaceIndentSize = 0;
        if (preferencesQualifier != null) {
            spaceIndentSize = Platform.getPreferencesService().getInt(preferencesQualifier, "tabWidth", 0, null);
        }
        return spaceIndentSize > 0 ? spaceIndentSize : EditorUtil.getDefaultSpaceIndentSize(preferencesQualifier);
    }

    public static int getDefaultSpaceIndentSize(String preferencesQualifier) {
        int spaceIndentSize = 0;
        if (CommonEditorPlugin.getDefault() != null && EditorsPlugin.getDefault() != null) {
            spaceIndentSize = new ChainedPreferenceStore(new IPreferenceStore[]{CommonEditorPlugin.getDefault().getPreferenceStore(), EditorsPlugin.getDefault().getPreferenceStore()}).getInt("tabWidth");
        }
        return spaceIndentSize > 0 ? spaceIndentSize : 2;
    }

    public static String convertIndent(String indent, int indentSize, boolean useTabs) {
        if (indent == null) {
            return "";
        }
        if (useTabs && indent.contains(" ")) {
            String newIndent = "";
            int spacesCount = indent.replaceAll("\t", "").length();
            int i = 0;
            while (i < indent.length() - spacesCount + spacesCount / indentSize) {
                newIndent = String.valueOf(newIndent) + '\t';
                ++i;
            }
            i = 0;
            while (i < spacesCount % indentSize) {
                newIndent = String.valueOf(newIndent) + ' ';
                ++i;
            }
            return newIndent;
        }
        if (!useTabs && indent.contains("\t")) {
            String newIndent = "";
            int tabCount = indent.replaceAll(" ", "").length();
            int i = 0;
            while (i < indent.length() - tabCount + tabCount * indentSize) {
                newIndent = String.valueOf(newIndent) + " ";
                ++i;
            }
            return newIndent;
        }
        return indent;
    }

    public static IEditorDescriptor getEditorDescriptor(URI uri) {
        String uriPath = uri.getPath();
        if (StringUtil.isEmpty((String)uriPath) || uriPath.equals("/")) {
            return null;
        }
        Path path = new Path(uriPath);
        return PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(path.lastSegment());
    }

    public static Index getIndex(AbstractThemeableEditor editor) {
        if (editor != null) {
            IEditorInput editorInput = editor.getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
                IFile file = fileEditorInput.getFile();
                return EditorUtil.getIndexManager().getIndex(file.getProject().getLocationURI());
            }
            if (editorInput instanceof IURIEditorInput) {
                IURIEditorInput uriEditorInput = (IURIEditorInput)editorInput;
                return EditorUtil.getIndexManager().getIndex(uriEditorInput.getURI());
            }
            if (editorInput instanceof IPathEditorInput) {
                IPathEditorInput pathEditorInput = (IPathEditorInput)editorInput;
                return EditorUtil.getIndexManager().getIndex(URIUtil.toURI((IPath)pathEditorInput.getPath()));
            }
        }
        return null;
    }

    public static boolean isJSPartition(AbstractThemeableEditor editor, int offset) {
        ISelection selection;
        if (offset < 0 && (selection = editor.getSelectionProvider().getSelection()) instanceof ITextSelection) {
            ITextSelection txtSelection = (ITextSelection)selection;
            offset = txtSelection.getOffset();
        }
        try {
            if (editor.getDocument().getPartition(offset).getType().startsWith("__js_")) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    protected static IndexManager getIndexManager() {
        return IndexPlugin.getDefault().getIndexManager();
    }

    public static URI getURI(IEditorPart editor) {
        if (editor != null) {
            IEditorInput editorInput = editor.getEditorInput();
            if (editorInput instanceof IURIEditorInput) {
                IURIEditorInput uriEditorInput = (IURIEditorInput)editorInput;
                return uriEditorInput.getURI();
            }
            if (editorInput instanceof IPathEditorInput) {
                IPathEditorInput pathEditorInput = (IPathEditorInput)editorInput;
                return URIUtil.toURI((IPath)pathEditorInput.getPath());
            }
            if (editorInput instanceof IFileEditorInput) {
                IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
                return fileEditorInput.getFile().getLocationURI();
            }
            try {
                IPath path;
                IStorageEditorInput storageEditorInput;
                IStorage storage;
                if (editorInput instanceof IStorageEditorInput && (storage = (storageEditorInput = (IStorageEditorInput)editorInput).getStorage()) != null && (path = storage.getFullPath()) != null) {
                    return URIUtil.toURI((IPath)path);
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            }
            if (editorInput instanceof ILocationProviderExtension) {
                ILocationProviderExtension lpe = (ILocationProviderExtension)editorInput;
                return lpe.getURI(null);
            }
            if (editorInput instanceof ILocationProvider) {
                ILocationProvider lp = (ILocationProvider)editorInput;
                return URIUtil.toURI((IPath)lp.getPath(null));
            }
        }
        return null;
    }

    public static String getFileName(IEditorPart editor) {
        URI uri = EditorUtil.getURI(editor);
        return com.aptana.core.util.URIUtil.getFileName((URI)uri);
    }

    public static IEditorPart hackedJavaScriptEditor(IWorkbenchPage page, URI uri) {
        block10: {
            block9: {
                if (uri != null && page != null) break block9;
                return null;
            }
            try {
                IFileStore fileStore = EFS.getStore((URI)uri);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IFile[] files = root.findFilesForLocationURI(fileStore.toURI());
                if (files == null || files.length <= 0) break block10;
                IFile[] iFileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    block11: {
                        IFile file = iFileArray[n2];
                        if (file.exists()) {
                            try {
                                String editorID = file.getPersistentProperty(IDE.EDITOR_KEY);
                                if (editorID == null) {
                                    IEditorDescriptor desc;
                                    IContentType type = Platform.getContentTypeManager().getContentType("com.aptana.contenttype.js");
                                    if (type != null && type.isAssociatedWith(file.getName()) && (desc = PlatformUI.getWorkbench().getEditorRegistry().findEditor("com.aptana.editor.js")) != null) {
                                        return IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)desc.getId());
                                    }
                                    break block11;
                                }
                                return IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)editorID);
                            }
                            catch (CoreException coreException) {}
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static IEditorPart openInEditor(File file) {
        if (file == null) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)"Error open a file in the editor", (Throwable)new IllegalArgumentException("file is null"));
            return null;
        }
        try {
            URI uri = file.toURI();
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart part = null;
            part = EditorUtil.hackedJavaScriptEditor(page, uri);
            if (part != null) {
                return part;
            }
            IEditorDescriptor desc = EditorUtil.getEditorDescriptor(uri);
            String editorId = desc == null ? "org.eclipse.ui.systemExternalEditor" : desc.getId();
            return IDE.openEditor((IWorkbenchPage)page, (URI)uri, (String)editorId, (boolean)true);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)"Error open a file in the editor", (Throwable)e);
            return null;
        }
    }

    public static IProject getProject(AbstractThemeableEditor editor) {
        IEditorInput editorInput;
        if (editor != null && (editorInput = editor.getEditorInput()) instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return fileEditorInput.getFile().getProject();
        }
        return null;
    }

    public static URI getProjectURI(AbstractThemeableEditor editor) {
        IProject project = EditorUtil.getProject(editor);
        return project == null ? null : project.getLocationURI();
    }

    public static void executeCommand(String commandId) {
        if (StringUtil.isEmpty((String)commandId)) {
            return;
        }
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        Command command = commandService.getCommand(commandId);
        if (command != null) {
            try {
                if (command.isEnabled()) {
                    command.executeWithChecks(new ExecutionEvent(command, Collections.EMPTY_MAP, null, null));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getDocumentTextWithOutNewString(IDocument document, int offset, int length) {
        try {
            if (document instanceof AbstractDocument) {
                Field fStore = AbstractDocument.class.getDeclaredField("fStore");
                fStore.setAccessible(true);
                Object copyOnWriteTextStore = fStore.get(document);
                if (copyOnWriteTextStore != null) {
                    Field fTextStore = copyOnWriteTextStore.getClass().getDeclaredField("fTextStore");
                    fTextStore.setAccessible(true);
                    Object gapTextStore = fTextStore.get(copyOnWriteTextStore);
                    if (gapTextStore != null) {
                        if (gapTextStore instanceof GapTextStore) {
                            Field fContent = gapTextStore.getClass().getDeclaredField("fContent");
                            fContent.setAccessible(true);
                            Object content = fContent.get(gapTextStore);
                            if (content instanceof char[] && ((char[])content).length == length) {
                                return new String((char[])content, offset, length);
                            }
                        } else {
                            Field fContent = gapTextStore.getClass().getDeclaredField("fText");
                            fContent.setAccessible(true);
                            Object content = fContent.get(gapTextStore);
                            if (content instanceof String && ((String)content).length() == length) {
                                return ((String)content).substring(offset, length);
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    public static void flexScannerYYclose(Object scanner) {
        try {
            if (scanner instanceof Scanner) {
                ((Scanner)scanner).yyclose();
            } else if (scanner instanceof AbstractFlexTokenScanner) {
                ((AbstractFlexTokenScanner)scanner).yyclose();
            } else if (scanner instanceof CompositeTokenScanner) {
                EditorUtil.flexScannerYYclose(((CompositeTokenScanner)scanner).getPrimaryTokenScanner());
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }
}

