/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.rules;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.scripting.IDocumentScopeManager;
import com.aptana.theme.IThemeManager;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.swt.graphics.Color;

public class ThemeingDamagerRepairer
extends DefaultDamagerRepairer {
    private final int maxLinesToColor = Platform.getPreferencesService().getInt("com.aptana.editor.common", "studio.maxColoredColumns", 200, new IScopeContext[]{EclipseUtil.instanceScope(), EclipseUtil.defaultScope()});
    private static final Position[] NO_POSITIONS = new Position[0];
    private TextAttribute lastAttribute;
    private String scope = "";
    private TypedPosition fLastPosition;
    private List<Position> newPositions;
    private Position[] oldPositions;
    private int fEndOfLine;
    private int fEndOffset;
    private static final List<String> htmlScope = Arrays.asList("text.html", "entity.other.attribute-name.html", "comment.");
    private static final List<String> cssScope = Arrays.asList("source.css", "support.type.property-name.css", "entity.name.tag.css", "comment.");
    private static final List<String> jsScope = Arrays.asList("source.js", "meta.selector.jquery", "comment.");

    public ThemeingDamagerRepairer(ITokenScanner scanner) {
        super(scanner);
    }

    public void createPresentation(TextPresentation presentation, ITypedRegion region) {
        try {
            try {
                if (IdeLog.isTraceEnabled((Plugin)CommonEditorPlugin.getDefault(), (String)"com.aptana.editor.common/debug/presentation")) {
                    IdeLog.logTrace((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Creating presentation for region at offset {0}, length {1} in document of length {2}", region.getOffset(), region.getLength(), this.fDocument.getLength()), (String)"com.aptana.editor.common/debug/presentation");
                }
                this.fEndOfLine = -1;
                this.fEndOffset = -1;
                this.fLastPosition = null;
                int offset = region.getOffset();
                this.scope = this.getDocumentScopeManager().getScopeAtOffset(this.fDocument, offset);
                if (this.scope == null) {
                    this.scope = "";
                }
                this.oldPositions = this.getExistingScopes(region);
                this.newPositions = new ArrayList<Position>();
            }
            catch (BadLocationException badLocationException) {
                super.createPresentation(presentation, region);
                this.updateScopePositions();
                this.oldPositions = null;
                this.newPositions = null;
                this.scope = "";
                this.fEndOfLine = -1;
                this.fEndOffset = -1;
                this.fLastPosition = null;
            }
        }
        finally {
            super.createPresentation(presentation, region);
            this.updateScopePositions();
            this.oldPositions = null;
            this.newPositions = null;
            this.scope = "";
            this.fEndOfLine = -1;
            this.fEndOffset = -1;
            this.fLastPosition = null;
        }
    }

    private void updateScopePositions() {
        try {
            int oldLength;
            int oldIndex = 0;
            int newIndex = 0;
            int n = oldLength = this.oldPositions == null ? 0 : this.oldPositions.length;
            if (this.newPositions == null) {
                return;
            }
            int newLength = this.newPositions.size();
            while (newIndex < newLength && oldIndex < oldLength) {
                Position oldPosition;
                Position newPosition = this.newPositions.get(newIndex);
                if (newPosition.equals((Object)(oldPosition = this.oldPositions[oldIndex]))) {
                    ++oldIndex;
                    ++newIndex;
                    continue;
                }
                if (newPosition.offset + newPosition.length < oldPosition.offset) {
                    this.fDocument.addPosition("scopes", newPosition);
                    ++newIndex;
                    continue;
                }
                if (oldPosition.offset + oldPosition.length < newPosition.offset) {
                    oldPosition.delete();
                    this.fDocument.removePosition("scopes", oldPosition);
                    ++oldIndex;
                    continue;
                }
                if (((TypedPosition)oldPosition).getType().equals(((TypedPosition)newPosition).getType())) {
                    oldPosition.offset = newPosition.offset;
                    oldPosition.length = newPosition.length;
                } else {
                    oldPosition.delete();
                    this.fDocument.removePosition("scopes", oldPosition);
                    this.fDocument.addPosition("scopes", newPosition);
                }
                ++oldIndex;
                ++newIndex;
            }
            int i = oldIndex;
            while (i < oldLength) {
                this.oldPositions[i].delete();
                this.fDocument.removePosition("scopes", this.oldPositions[i]);
                ++i;
            }
            i = newIndex;
            while (i < newLength) {
                this.fDocument.addPosition("scopes", this.newPositions.get(i));
                ++i;
            }
        }
        catch (BadLocationException e1) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e1);
        }
        catch (BadPositionCategoryException e1) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e1);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private Position[] getExistingScopes(ITypedRegion region) {
        int offset = region.getOffset();
        int end = offset + region.getLength();
        try {
            this.fDocument.addPositionCategory("scopes");
            int index = this.fDocument.computeIndexInCategory("scopes", offset);
            int endIndex = this.fDocument.computeIndexInCategory("scopes", end);
            if (endIndex == index) {
                return NO_POSITIONS;
            }
            if (this.fDocument instanceof AbstractDocument) {
                AbstractDocument abDoc = (AbstractDocument)this.fDocument;
                Position[] positions = abDoc.getPositions("scopes", offset, region.getLength(), false, false);
                return positions;
            }
            Position[] positions = this.fDocument.getPositions("scopes");
            int start = index;
            int stop = endIndex;
            int length = stop - start;
            Position[] sub = new Position[length];
            System.arraycopy(positions, start, sub, 0, length);
            return sub;
        }
        catch (BadPositionCategoryException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)e.getMessage());
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)e.getMessage());
        }
        return NO_POSITIONS;
    }

    protected TextAttribute getTokenTextAttribute(IToken token) {
        Object data = token.getData();
        if (data instanceof String) {
            String last = (String)data;
            this.storeScope(last);
            if (last.length() == 0) {
                last = this.scope;
            } else if (this.scope.length() > 0) {
                last = this.scope.endsWith(last) ? this.scope : String.valueOf(this.scope) + ' ' + last;
            }
            IToken converted = this.getThemeManager().getToken(last);
            this.lastAttribute = super.getTokenTextAttribute(converted);
            return this.lastAttribute;
        }
        if (token.isWhitespace()) {
            return this.lastAttribute;
        }
        this.lastAttribute = super.getTokenTextAttribute(token);
        return this.lastAttribute;
    }

    private String filterScope(String tokenLevelScope) {
        block9: {
            try {
                List<String> scopes = null;
                if (tokenLevelScope.endsWith(".html")) {
                    scopes = htmlScope;
                } else if (tokenLevelScope.endsWith(".css")) {
                    scopes = cssScope;
                } else if (tokenLevelScope.endsWith(".js")) {
                    scopes = jsScope;
                }
                if (scopes == null) break block9;
                for (String scope : scopes) {
                    if (!tokenLevelScope.contains(scope)) continue;
                    return tokenLevelScope;
                }
                return null;
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                return tokenLevelScope;
            }
        }
        return tokenLevelScope;
    }

    private void storeScope(String tokenLevelScope) {
        if (tokenLevelScope == null || tokenLevelScope.length() == 0) {
            this.fLastPosition = null;
            return;
        }
        if ((tokenLevelScope = this.filterScope(tokenLevelScope)) == null || tokenLevelScope.length() == 0) {
            this.fLastPosition = null;
            return;
        }
        int offset = this.fScanner.getTokenOffset();
        int length = this.fScanner.getTokenLength();
        if (offset < 0) {
            offset = 0;
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Scanner {0} returned a token with invalid offset: {1}", this.fScanner.getClass().getName(), offset));
        }
        if (length < 0) {
            length = 0;
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Scanner {0} returned a token with invalid length: {1}", this.fScanner.getClass().getName(), length));
        }
        if (this.fLastPosition != null && this.fLastPosition.getType().equals(tokenLevelScope)) {
            this.fLastPosition.setLength(offset + length - this.fLastPosition.getOffset());
        } else {
            TypedPosition newPosition;
            this.fLastPosition = newPosition = new TypedPosition(offset, length, tokenLevelScope);
            if (this.newPositions == null) {
                this.newPositions = new ArrayList<Position>();
            }
            this.newPositions.add((Position)newPosition);
        }
    }

    protected void addRange(TextPresentation presentation, int offset, int length, TextAttribute attr) {
        block7: {
            try {
                if (this.fEndOffset == -1 && this.fEndOfLine == -1) {
                    this.recordCurrentLineOffsets(offset);
                }
                if (offset <= this.fEndOffset) break block7;
                if (offset > this.fEndOfLine) {
                    this.recordCurrentLineOffsets(offset);
                    break block7;
                }
                return;
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            }
        }
        if (this.matchesDefaults(attr)) {
            attr = new TextAttribute(null);
        } else if (attr.getBackground() != null && attr.getBackground().getRGB().equals((Object)this.getCurrentTheme().getBackground())) {
            attr = new TextAttribute(attr.getForeground(), null, attr.getStyle());
        }
        super.addRange(presentation, offset, length, attr);
    }

    private boolean matchesDefaults(TextAttribute attr) {
        if (attr == null) {
            return false;
        }
        int style = attr.getStyle();
        int fontStyle = style & 3;
        if (fontStyle != 0) {
            return false;
        }
        if ((style & 0x20000000) != 0) {
            return false;
        }
        if ((style & 0x40000000) != 0) {
            return false;
        }
        Color fg = attr.getForeground();
        if (fg != null && !fg.getRGB().equals((Object)this.getCurrentTheme().getForeground())) {
            return false;
        }
        Color bg = attr.getBackground();
        return bg == null || bg.getRGB().equals((Object)this.getCurrentTheme().getBackground());
    }

    private void recordCurrentLineOffsets(int offset) throws BadLocationException {
        IRegion lastLine = this.fDocument.getLineInformationOfOffset(offset);
        this.fEndOfLine = lastLine.getOffset() + lastLine.getLength();
        this.fEndOffset = lastLine.getOffset();
        this.fEndOffset = this.maxLinesToColor < 0 ? (this.fEndOffset += lastLine.getLength()) : (this.fEndOffset += Math.min(this.maxLinesToColor, lastLine.getLength()));
    }

    protected Theme getCurrentTheme() {
        return this.getThemeManager().getCurrentTheme();
    }

    protected IThemeManager getThemeManager() {
        return ThemePlugin.getDefault().getThemeManager();
    }

    protected IDocumentScopeManager getDocumentScopeManager() {
        return CommonEditorPlugin.getDefault().getDocumentScopeManager();
    }
}

