/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.reconciler;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.scripting.IDocumentScopeManager;
import com.aptana.editor.common.text.reconciler.IFoldingComputer;
import com.aptana.editor.common.text.reconciler.Messages;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.scripting.model.BundleManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyRegexpFolder
implements IFoldingComputer {
    private IDocument fDocument;
    private AbstractThemeableEditor fEditor;

    public RubyRegexpFolder(AbstractThemeableEditor editor, IDocument document) {
        this.fDocument = document;
        this.fEditor = editor;
    }

    @Override
    public Map<ProjectionAnnotation, Position> emitFoldingRegions(boolean initialReconcile, IProgressMonitor monitor, IParseRootNode ast) throws BadLocationException {
        int lineCount = this.fDocument.getNumberOfLines();
        if (lineCount <= 1) {
            return Collections.emptyMap();
        }
        HashMap<ProjectionAnnotation, Position> newPositions = new HashMap<ProjectionAnnotation, Position>(lineCount >> 2);
        HashMap<Integer, Integer> starts = new HashMap<Integer, Integer>(3);
        if (monitor != null) {
            monitor.beginTask(Messages.CommonReconcilingStrategy_FoldingTaskName, lineCount);
        }
        int currentLine = 0;
        while (currentLine < lineCount) {
            if (monitor != null && monitor.isCanceled()) {
                return newPositions;
            }
            IRegion lineRegion = this.fDocument.getLineInformation(currentLine);
            int offset = lineRegion.getOffset();
            String line = this.fDocument.get(offset, lineRegion.getLength());
            RubyRegexp startRegexp = this.getStartFoldRegexp(this.getScopeAtOffset(offset));
            if (startRegexp == null) {
                if (monitor != null) {
                    monitor.worked(1);
                }
            } else {
                RubyRegexp endRegexp = this.getEndFoldRegexp(this.getScopeAtOffset(offset + lineRegion.getLength()));
                if (endRegexp == null) {
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                } else {
                    RubyString rLine = startRegexp.getRuntime().newString(line);
                    IRubyObject startMatcher = startRegexp.match_m(startRegexp.getRuntime().getCurrentContext(), (IRubyObject)rLine);
                    if (!startMatcher.isNil()) {
                        starts.put(this.findIndent(line), offset);
                    }
                    if (starts.size() > 0) {
                        int startingOffset;
                        int startLine;
                        IRubyObject endMatcher;
                        int indent = this.findIndent(line);
                        if (line.trim().startsWith("*")) {
                            --indent;
                        }
                        if (starts.containsKey(indent) && !(endMatcher = endRegexp.match_m(endRegexp.getRuntime().getCurrentContext(), (IRubyObject)rLine)).isNil() && (startLine = this.fDocument.getLineOfOffset(startingOffset = ((Integer)starts.remove(indent)).intValue())) != currentLine) {
                            int posLength;
                            int end = lineRegion.getOffset() + lineRegion.getLength() + 1;
                            if (end > this.fDocument.getLength()) {
                                end = this.fDocument.getLength();
                            }
                            if ((posLength = end - startingOffset) > 0) {
                                Position position = new Position(startingOffset, posLength);
                                newPositions.put(new ProjectionAnnotation(), position);
                            }
                        }
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                }
            }
            ++currentLine;
        }
        if (monitor != null) {
            monitor.done();
        }
        return newPositions;
    }

    protected String getScopeAtOffset(int offset) throws BadLocationException {
        ISourceViewer sv;
        if (this.fEditor != null && (sv = this.fEditor.getISourceViewer()) != null) {
            return this.getDocumentScopeManager().getScopeAtOffset((ITextViewer)sv, offset);
        }
        return this.getDocumentScopeManager().getScopeAtOffset(this.fDocument, offset);
    }

    protected IDocumentScopeManager getDocumentScopeManager() {
        return CommonEditorPlugin.getDefault().getDocumentScopeManager();
    }

    private int findIndent(String text) {
        int indent = 0;
        while (indent < text.length()) {
            if (!Character.isWhitespace(text.charAt(indent))) break;
            ++indent;
        }
        return indent;
    }

    protected RubyRegexp getEndFoldRegexp(String scope) {
        return BundleManager.getInstance().getFoldingStopRegexp(scope);
    }

    protected RubyRegexp getStartFoldRegexp(String scope) {
        return BundleManager.getInstance().getFoldingStartRegexp(scope);
    }
}

