/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.reconciler;

import com.aptana.editor.common.text.reconciler.IBatchReconcilingStrategy;
import com.aptana.editor.common.text.reconciler.IDisposableReconcilingStrategy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;

public class CompositeReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
IBatchReconcilingStrategy,
IDisposableReconcilingStrategy {
    private final IReconcilingStrategy[] fStrategies;

    public CompositeReconcilingStrategy(IReconcilingStrategy ... strategies) {
        this.fStrategies = strategies != null ? strategies : new IReconcilingStrategy[]{};
    }

    @Override
    public void dispose() {
        IReconcilingStrategy[] iReconcilingStrategyArray = this.fStrategies;
        int n = this.fStrategies.length;
        int n2 = 0;
        while (n2 < n) {
            IReconcilingStrategy strategy = iReconcilingStrategyArray[n2];
            if (strategy instanceof IDisposableReconcilingStrategy) {
                ((IDisposableReconcilingStrategy)strategy).dispose();
            }
            ++n2;
        }
    }

    public void setDocument(IDocument document) {
        IReconcilingStrategy[] iReconcilingStrategyArray = this.fStrategies;
        int n = this.fStrategies.length;
        int n2 = 0;
        while (n2 < n) {
            IReconcilingStrategy strategy = iReconcilingStrategyArray[n2];
            strategy.setDocument(document);
            ++n2;
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        IReconcilingStrategy[] iReconcilingStrategyArray = this.fStrategies;
        int n = this.fStrategies.length;
        int n2 = 0;
        while (n2 < n) {
            IReconcilingStrategy strategy = iReconcilingStrategyArray[n2];
            strategy.reconcile(dirtyRegion, subRegion);
            ++n2;
        }
    }

    public void reconcile(IRegion partition) {
        IReconcilingStrategy[] iReconcilingStrategyArray = this.fStrategies;
        int n = this.fStrategies.length;
        int n2 = 0;
        while (n2 < n) {
            IReconcilingStrategy strategy = iReconcilingStrategyArray[n2];
            strategy.reconcile(partition);
            ++n2;
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        IReconcilingStrategy[] iReconcilingStrategyArray = this.fStrategies;
        int n = this.fStrategies.length;
        int n2 = 0;
        while (n2 < n) {
            IReconcilingStrategy strategy = iReconcilingStrategyArray[n2];
            if (strategy instanceof IReconcilingStrategyExtension) {
                IReconcilingStrategyExtension extension = (IReconcilingStrategyExtension)strategy;
                extension.setProgressMonitor(monitor);
            }
            ++n2;
        }
    }

    public void initialReconcile() {
        IReconcilingStrategy[] iReconcilingStrategyArray = this.fStrategies;
        int n = this.fStrategies.length;
        int n2 = 0;
        while (n2 < n) {
            IReconcilingStrategy strategy = iReconcilingStrategyArray[n2];
            if (strategy instanceof IReconcilingStrategyExtension) {
                IReconcilingStrategyExtension extension = (IReconcilingStrategyExtension)strategy;
                extension.initialReconcile();
            }
            ++n2;
        }
    }

    @Override
    public void fullReconcile() {
        IReconcilingStrategy[] iReconcilingStrategyArray = this.fStrategies;
        int n = this.fStrategies.length;
        int n2 = 0;
        while (n2 < n) {
            IReconcilingStrategy strategy = iReconcilingStrategyArray[n2];
            if (strategy instanceof IBatchReconcilingStrategy) {
                IBatchReconcilingStrategy extension = (IBatchReconcilingStrategy)strategy;
                extension.fullReconcile();
            }
            ++n2;
        }
    }
}

