/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.reconciler;

import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.core.IFilter;
import com.aptana.core.build.BuilderJob;
import com.aptana.core.build.IBuildParticipant;
import com.aptana.core.build.IBuildParticipantManager;
import com.aptana.core.build.ReconcileContext;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ResourceUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.ICommonAnnotationModel;
import com.aptana.editor.common.text.reconciler.IBatchReconcilingStrategy;
import com.aptana.editor.common.text.reconciler.IDisposableReconcilingStrategy;
import com.aptana.editor.common.text.reconciler.IFoldingComputer;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.ast.IParseError;
import com.aptana.parsing.ast.IParseRootNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class CommonReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
IBatchReconcilingStrategy,
IDisposableReconcilingStrategy {
    private volatile AbstractThemeableEditor fEditor;
    private IDocument fDocument;
    private boolean fInitialReconcileDone;
    private IProgressMonitor fMonitor;
    private IFoldingComputer folder;
    private final Object fPositionsLock = new Object();
    private Map<ProjectionAnnotation, Position> fPositions = new HashMap<ProjectionAnnotation, Position>();
    private IPropertyListener propertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 258) {
                CommonReconcilingStrategy.this.reconcile(false, true);
            }
        }
    };

    public CommonReconcilingStrategy(AbstractThemeableEditor editor) {
        this.fEditor = editor;
        this.fEditor.addPropertyListener(this.propertyListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this.fEditor != null) {
            this.fEditor.removePropertyListener(this.propertyListener);
            this.fEditor = null;
        }
        Object object = this.fPositionsLock;
        synchronized (object) {
            this.fPositions.clear();
        }
    }

    protected AbstractThemeableEditor getEditor() {
        return this.fEditor;
    }

    protected IDocument getDocument() {
        return this.fDocument;
    }

    public void reconcile(IRegion partition) {
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
    }

    public void setDocument(IDocument document) {
        this.folder = this.createFoldingComputer(document);
        this.fDocument = document;
    }

    protected IFoldingComputer createFoldingComputer(IDocument document) {
        return this.fEditor.createFoldingComputer(document);
    }

    public void initialReconcile() {
        if (this.fInitialReconcileDone) {
            return;
        }
        this.reconcile(true);
        this.fInitialReconcileDone = true;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fMonitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculatePositions(boolean initialReconcile, IProgressMonitor monitor, IParseRootNode ast) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        try {
            Map<ProjectionAnnotation, Position> positions = this.folder.emitFoldingRegions(initialReconcile, monitor, ast);
            Object object = this.fPositionsLock;
            synchronized (object) {
                this.fPositions = positions;
            }
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        if (monitor != null && monitor.isCanceled() || !this.shouldUpdatePositions(this.folder)) {
            return;
        }
        this.updatePositions();
    }

    protected boolean shouldUpdatePositions(IFoldingComputer folder) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearPositions(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        Object object = this.fPositionsLock;
        synchronized (object) {
            this.fPositions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePositions() {
        AbstractThemeableEditor editor = this.fEditor;
        if (editor != null) {
            HashMap<ProjectionAnnotation, Position> positions;
            Object object = this.fPositionsLock;
            synchronized (object) {
                positions = new HashMap<ProjectionAnnotation, Position>(this.fPositions);
            }
            editor.updateFoldingStructure(positions);
        }
    }

    private void reconcile(boolean initialReconcile) {
        this.reconcile(initialReconcile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconcile(boolean initialReconcile, boolean force) {
        AbstractThemeableEditor editor = this.fEditor;
        try {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)this.fMonitor, (int)100);
            IParseRootNode ast = null;
            if (editor != null) {
                ast = editor.getAST();
                editor = this.fEditor;
                if (!initialReconcile && editor != null) {
                    editor.refreshOutline(ast);
                }
            }
            monitor.worked(5);
            this.runParticipants(initialReconcile, (IProgressMonitor)monitor.newChild(75));
            if (editor != null && editor.isFoldingEnabled()) {
                this.calculatePositions(initialReconcile, (IProgressMonitor)monitor.newChild(20), ast);
            } else {
                Object object = this.fPositionsLock;
                synchronized (object) {
                    this.fPositions.clear();
                }
                this.updatePositions();
            }
            monitor.setWorkRemaining(75);
            if (monitor.isCanceled()) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ProjectionAnnotation, Position> getPositions() {
        Object object = this.fPositionsLock;
        synchronized (object) {
            return new HashMap<ProjectionAnnotation, Position>(this.fPositions);
        }
    }

    private void runParticipants(final boolean initialReconcile, IProgressMonitor monitor) {
        AbstractThemeableEditor editor = this.fEditor;
        if (editor == null) {
            return;
        }
        IFile file = this.getFile();
        if (file == null) {
            return;
        }
        String relativePath = file.getProjectRelativePath().toString();
        if (relativePath.startsWith("unpackage/")) {
            return;
        }
        if (file != null && ResourceUtil.shouldIgnore((IFile)file)) {
            return;
        }
        List<IBuildParticipant> participants = this.getBuildParticipantManager().getBuildParticipants(editor.getContentType());
        if (CollectionsUtil.isEmpty((Collection)participants)) {
            return;
        }
        if (CollectionsUtil.isEmpty(participants = this.filterToEnabled(participants))) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(participants.size() * 12 + 10));
        final ReconcileContext context = this.createContext();
        context.setInitialReconcile(initialReconcile);
        if (context == null) {
            return;
        }
        final boolean isValitation = CommonReconcilingStrategy.isValitation();
        final List<IBuildParticipant> fParticipants = participants;
        BuilderJob run = new BuilderJob(context.getProject(), false){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                context.setNeedSleep(false);
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    if (!isValitation) {
                        CommonReconcilingStrategy.this.runParticipant(CommonReconcilingStrategy.this.filterToLazy(initialReconcile, fParticipants, false), sub, context);
                    }
                    CommonReconcilingStrategy.this.runParticipant(CommonReconcilingStrategy.this.filterToLazy(initialReconcile, fParticipants, true), sub, context);
                    CommonReconcilingStrategy.this.reportProblems(context, (IProgressMonitor)sub.newChild(10));
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        run.setFile(context.getFile());
        run.cancelSameJobs();
        run.setSystem(true);
        run.schedule();
        sub.done();
    }

    private void runParticipant(List<IBuildParticipant> participants, SubMonitor sub, ReconcileContext context) {
        for (IBuildParticipant participant : participants) {
            participant.buildStarting(context.getProject(), 10, (IProgressMonitor)sub.newChild(1));
        }
        for (IBuildParticipant participant : participants) {
            participant.buildFile((BuildContext)context, (IProgressMonitor)sub.newChild(10));
        }
        for (IBuildParticipant participant : participants) {
            participant.buildEnding((IProgressMonitor)sub.newChild(1));
        }
    }

    protected IBuildParticipantManager getBuildParticipantManager() {
        return BuildPathCorePlugin.getDefault().getBuildParticipantManager();
    }

    protected ReconcileContext createContext() {
        IFile file;
        AbstractThemeableEditor editor = this.fEditor;
        if (editor == null) {
            return null;
        }
        String content = EditorUtil.getDocumentTextWithOutNewString(this.fDocument, 0, this.fDocument.getLength());
        if (content == null) {
            content = this.fDocument.get();
        }
        if ((file = this.getFile()) != null) {
            return new ReconcileContext(editor.getContentType(), file, content){

                public IParseRootNode getAST() throws CoreException {
                    if (CommonReconcilingStrategy.this.fEditor != null) {
                        return CommonReconcilingStrategy.this.fEditor.getAST();
                    }
                    return super.getAST();
                }

                public Collection<IParseError> getParseErrors() {
                    ParseResult pr;
                    if (CommonReconcilingStrategy.this.fEditor != null && (pr = CommonReconcilingStrategy.this.fEditor.getParseResult()) != null) {
                        return pr.getErrors();
                    }
                    return super.getParseErrors();
                }
            };
        }
        return new ReconcileContext(editor.getContentType(), EditorUtil.getURI((IEditorPart)editor), content){

            public IParseRootNode getAST() throws CoreException {
                if (CommonReconcilingStrategy.this.fEditor != null) {
                    return CommonReconcilingStrategy.this.fEditor.getAST();
                }
                return super.getAST();
            }
        };
    }

    private List<IBuildParticipant> filterToEnabled(List<IBuildParticipant> participants) {
        return CollectionsUtil.filter(participants, (IFilter)new IFilter<IBuildParticipant>(){

            public boolean include(IBuildParticipant item) {
                return item != null && item.isEnabled(IBuildParticipant.BuildType.RECONCILE);
            }
        });
    }

    private List<IBuildParticipant> filterToLazy(boolean initialReconcile, List<IBuildParticipant> participants, final boolean isLazy) {
        return CollectionsUtil.filter(participants, (IFilter)new IFilter<IBuildParticipant>(){

            public boolean include(IBuildParticipant item) {
                return item != null && item.isLazy() == isLazy;
            }
        });
    }

    private void reportProblems(ReconcileContext context, IProgressMonitor monitor) {
        AbstractThemeableEditor editor = this.fEditor;
        if (editor == null) {
            return;
        }
        IDocumentProvider docProvider = editor.getDocumentProvider();
        if (docProvider == null) {
            return;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return;
        }
        IAnnotationModel model = docProvider.getAnnotationModel((Object)editorInput);
        if (!(model instanceof ICommonAnnotationModel)) {
            return;
        }
        ICommonAnnotationModel caModel = (ICommonAnnotationModel)model;
        caModel.reportProblems(context.getProblems(), monitor);
    }

    protected IFile getFile() {
        IEditorInput editorInput;
        AbstractThemeableEditor editor = this.fEditor;
        if (editor != null && (editorInput = editor.getEditorInput()) instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return fileEditorInput.getFile();
        }
        return null;
    }

    private static boolean isValitation() {
        Object property;
        boolean isValitation = false;
        if (Job.getJobManager().currentJob() != null && (property = Job.getJobManager().currentJob().getProperty(BuilderJob.BUILDTYPE_VALIDATION)) != null) {
            isValitation = Boolean.parseBoolean(property.toString());
        }
        return isValitation;
    }

    @Override
    public void fullReconcile() {
        this.reconcile(false);
    }
}

