/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonSourceViewerConfiguration;
import com.aptana.editor.common.text.CommonAutoIndentStrategy;
import com.aptana.scripting.model.BundleManager;
import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyRegexpAutoIndentStrategy
extends CommonAutoIndentStrategy {
    private static final String TAB_CHAR = "\t";

    public RubyRegexpAutoIndentStrategy(String contentType, SourceViewerConfiguration configuration, ISourceViewer sourceViewer, IPreferenceStore prefStore) {
        super(contentType, configuration, sourceViewer, prefStore);
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (command.length >= 0 && command.text != null) {
            boolean isLineDelimiter = RubyRegexpAutoIndentStrategy.isLineDelimiter(document, command.text);
            if (isLineDelimiter && !this.autoIndent(document, command)) {
                this.autoIndentAfterNewLine(document, command);
            } else if (!isLineDelimiter) {
                this.autoDedent(document, command);
            }
        }
    }

    private void autoDedent(IDocument d, DocumentCommand c) {
        if (c.offset <= 0 || d.getLength() == 0 || c.text.length() > 1) {
            return;
        }
        try {
            String lineContent;
            IRegion curLineRegion = d.getLineInformationOfOffset(c.offset);
            int endOffset = curLineRegion.getOffset() + curLineRegion.getLength();
            if (c.offset != endOffset) {
                return;
            }
            String scope = this.getScopeAtOffset(d, c.offset);
            RubyRegexp decreaseIndentRegexp = this.getDecreaseIndentRegexp(scope);
            if (this.matchesRegexp(decreaseIndentRegexp, String.valueOf(lineContent = d.get(curLineRegion.getOffset(), c.offset - curLineRegion.getOffset())) + c.text)) {
                int lineNumber = d.getLineOfOffset(c.offset);
                if (lineNumber == 0) {
                    return;
                }
                int endIndex = this.findEndOfWhiteSpace(d, curLineRegion.getOffset(), curLineRegion.getOffset() + curLineRegion.getLength());
                String currentLineIndent = d.get(curLineRegion.getOffset(), endIndex - curLineRegion.getOffset());
                if (currentLineIndent.length() == 0) {
                    return;
                }
                String decreasedIndent = "";
                String matchingIndent = this.findCorrectIndentString(d, lineNumber, currentLineIndent);
                String indentString = this.getIndentString();
                if (currentLineIndent.length() > indentString.length()) {
                    decreasedIndent = currentLineIndent.substring(0, currentLineIndent.length() - indentString.length());
                }
                if (decreasedIndent.equals(currentLineIndent) || decreasedIndent.length() < matchingIndent.length()) {
                    return;
                }
                int i = 0;
                while (i < lineContent.length() && Character.isWhitespace(lineContent.charAt(i))) {
                    ++i;
                }
                String newContent = String.valueOf(decreasedIndent) + lineContent.substring(i);
                d.replace(curLineRegion.getOffset(), lineContent.length(), newContent);
                c.doit = true;
                int diff = currentLineIndent.length() - decreasedIndent.length();
                c.offset -= diff;
                return;
            }
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    protected String getIndentString() {
        if (this.getSourceViewerConfiguration() instanceof CommonSourceViewerConfiguration) {
            return ((CommonSourceViewerConfiguration)this.getSourceViewerConfiguration()).getIndent();
        }
        return TAB_CHAR;
    }

    protected boolean shouldAutoDedent() {
        return true;
    }

    @Override
    protected boolean autoIndent(IDocument d, DocumentCommand c) {
        block11: {
            String previousLineIndent;
            String lineContent;
            IRegion curLineRegion;
            String newline;
            block12: {
                if (c.offset <= 0 || d.getLength() == 0 || !this.shouldAutoIndent()) {
                    return false;
                }
                newline = c.text;
                curLineRegion = d.getLineInformationOfOffset(c.offset);
                String scope = this.getScopeAtOffset(d, c.offset);
                RubyRegexp increaseIndentRegexp = this.getIncreaseIndentRegexp(scope);
                lineContent = d.get(curLineRegion.getOffset(), c.offset - curLineRegion.getOffset());
                if (!this.matchesRegexp(increaseIndentRegexp, lineContent)) break block11;
                previousLineIndent = this.getAutoIndentAfterNewLine(d, c);
                if (previousLineIndent != null) break block12;
                c.text = "";
                return true;
            }
            try {
                IRegion endLineRegion = c.length == 0 ? curLineRegion : d.getLineInformationOfOffset(c.offset + c.length);
                String restOfLine = d.get(c.offset + c.length, endLineRegion.getOffset() + endLineRegion.getLength() - c.offset + c.length);
                String startIndent = null;
                if (this.indentAndPushTrailingContentAfterNewlineAndCursor(lineContent, restOfLine)) {
                    startIndent = String.valueOf(newline) + previousLineIndent + this.getIndentString();
                    c.text = String.valueOf(startIndent) + newline + previousLineIndent;
                } else {
                    startIndent = String.valueOf(newline) + previousLineIndent;
                    if (restOfLine != null && restOfLine.length() >= 1) {
                        char after = restOfLine.charAt(0);
                        if (after != ']' && after != '}' && after != ')' && (after != '<' || restOfLine.length() < 2 || restOfLine.charAt(1) != '/')) {
                            startIndent = String.valueOf(startIndent) + this.getIndentString();
                        }
                    } else {
                        String startIndentTrim = startIndent.trim();
                        if (StringUtil.isNotBlank((String)startIndentTrim)) {
                            String rStartIndent = String.valueOf(this.getIndentString()) + startIndentTrim;
                            startIndent = startIndent.replace(startIndentTrim, rStartIndent);
                        } else {
                            startIndent = String.valueOf(startIndent) + this.getIndentString();
                        }
                    }
                    c.text = startIndent;
                }
                c.shiftsCaret = false;
                c.caretOffset = c.offset + startIndent.length();
                return true;
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            }
        }
        return false;
    }

    protected RubyRegexp getDecreaseIndentRegexp(String scope) {
        return BundleManager.getInstance().getDecreaseIndentRegexp(scope);
    }

    protected RubyRegexp getIncreaseIndentRegexp(String scope) {
        return BundleManager.getInstance().getIncreaseIndentRegexp(scope);
    }

    protected String getScopeAtOffset(IDocument d, int offset) throws BadLocationException {
        return CommonEditorPlugin.getDefault().getDocumentScopeManager().getScopeAtOffset((ITextViewer)this.getSourceViewer(), offset);
    }

    protected boolean matchesRegexp(RubyRegexp regexp, String lineContent) {
        if (regexp == null) {
            return false;
        }
        RubyString string = regexp.getRuntime().newString(lineContent);
        IRubyObject matcher = regexp.match_m(regexp.getRuntime().getCurrentContext(), (IRubyObject)string);
        return !matcher.isNil();
    }

    protected String findCorrectIndentString(IDocument d, int lineNumber, String currentLineIndent) throws BadLocationException {
        int stack = 0;
        int i = lineNumber - 1;
        while (i >= 0) {
            IRegion region = d.getLineInformation(i);
            String scope = CommonEditorPlugin.getDefault().getDocumentScopeManager().getScopeAtOffset((ITextViewer)this.getSourceViewer(), region.getOffset());
            String endScope = CommonEditorPlugin.getDefault().getDocumentScopeManager().getScopeAtOffset((ITextViewer)this.getSourceViewer(), region.getOffset() + region.getLength());
            RubyRegexp increaseIndentRegexp = this.getIncreaseIndentRegexp(scope);
            RubyRegexp decreaseIndentRegexp = this.getDecreaseIndentRegexp(endScope);
            String lineText = d.get(region.getOffset(), region.getLength());
            if (this.matchesRegexp(increaseIndentRegexp, lineText)) {
                if (++stack >= 1) {
                    int endIndex = this.findEndOfWhiteSpace(d, region.getOffset(), region.getOffset() + region.getLength());
                    return d.get(region.getOffset(), endIndex - region.getOffset());
                }
            } else if (this.matchesRegexp(decreaseIndentRegexp, lineText)) {
                --stack;
            }
            --i;
        }
        return this.dedentBasedOnPreviousLine(d, lineNumber, currentLineIndent);
    }

    protected String dedentBasedOnPreviousLine(IDocument d, int lineNumber, String currentLineIndent) throws BadLocationException {
        String previousLineIndent;
        IRegion previousLine = d.getLineInformation(lineNumber - 1);
        int endIndex = this.findEndOfWhiteSpace(d, previousLine.getOffset(), previousLine.getOffset() + previousLine.getLength());
        String decreasedIndent = previousLineIndent = d.get(previousLine.getOffset(), endIndex - previousLine.getOffset());
        if (previousLineIndent.length() >= currentLineIndent.length()) {
            if (previousLineIndent.endsWith(TAB_CHAR)) {
                decreasedIndent = decreasedIndent.substring(0, decreasedIndent.length() - 1);
            } else {
                int tabWidth = this.guessTabWidth(d, lineNumber);
                String toRemove = decreasedIndent.substring(decreasedIndent.length() - tabWidth);
                int lastTabIndex = toRemove.lastIndexOf(TAB_CHAR);
                if (lastTabIndex != -1) {
                    tabWidth -= lastTabIndex + 1;
                }
                decreasedIndent = decreasedIndent.substring(0, decreasedIndent.length() - tabWidth);
            }
        }
        return decreasedIndent;
    }

    private int guessTabWidth(IDocument d, int startLine) {
        try {
            ArrayList<Integer> lengths = new ArrayList<Integer>(3);
            int i = startLine;
            while (i >= 0) {
                IRegion line = d.getLineInformation(i);
                int endofWhitespace = this.findEndOfWhiteSpace(d, line.getOffset(), line.getOffset() + line.getLength());
                int length = endofWhitespace - line.getOffset();
                if (length != 0) {
                    if (lengths.size() < 2 && !lengths.contains(length)) {
                        lengths.add(length);
                    }
                    if (lengths.size() >= 2) break;
                }
                --i;
            }
            int tabWidth = this.gcd((Integer)lengths.get(0), (Integer)lengths.get(1));
            if (tabWidth != 1) {
                return tabWidth;
            }
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        return this.getTabWidth();
    }

    private int gcd(int a, int b) {
        if (b == 0) {
            return a;
        }
        return this.gcd(b, a % b);
    }

    protected boolean indentAndPushTrailingContentAfterNewlineAndCursor(String contentBeforeNewline, String contentAfterNewline) {
        char afterAfter;
        if (contentBeforeNewline == null || contentAfterNewline == null || contentBeforeNewline.trim().length() == 0 || contentAfterNewline.trim().length() == 0) {
            return false;
        }
        char before = contentBeforeNewline.charAt(contentBeforeNewline.length() - 1);
        char after = contentAfterNewline.charAt(0);
        if (before == '[' && after == ']') {
            return true;
        }
        if (before == '{' && after == '}') {
            return true;
        }
        if (before == '(' && after == ')') {
            return true;
        }
        if ((before == '%' && after == '%' || before == '?' && after == '?') && contentAfterNewline.length() >= 2 && contentBeforeNewline.length() >= 2) {
            afterAfter = contentAfterNewline.charAt(1);
            char beforebefore = contentBeforeNewline.charAt(contentBeforeNewline.length() - 2);
            if (afterAfter == '>' && beforebefore == '<') {
                return true;
            }
        }
        if (contentAfterNewline.length() >= 2) {
            afterAfter = contentAfterNewline.charAt(1);
            if (before == '>' && after == '<' && afterAfter == '/') {
                return true;
            }
        }
        return false;
    }
}

