/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.scripting.snippets;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.contentassist.CompletionProposalType;
import com.aptana.editor.common.contentassist.ICommonCompletionProposal;
import com.aptana.editor.common.scripting.IDocumentScopeManager;
import com.aptana.editor.common.scripting.snippets.CommandProposal;
import com.aptana.editor.common.scripting.snippets.CommandTemplate;
import com.aptana.editor.common.scripting.snippets.DocumentSnippetTemplateContext;
import com.aptana.editor.common.scripting.snippets.SnippetTemplate;
import com.aptana.editor.common.scripting.snippets.SnippetTemplateContextType;
import com.aptana.editor.common.scripting.snippets.SnippetTemplateProposal;
import com.aptana.editor.common.scripting.snippets.SnippetsContentAssistant;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.SnippetElement;
import com.aptana.scripting.model.TriggerType;
import com.aptana.scripting.model.filters.AndFilter;
import com.aptana.scripting.model.filters.HasTriggerFilter;
import com.aptana.scripting.model.filters.IModelFilter;
import com.aptana.scripting.model.filters.ScopeFilter;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;

public class SnippetsCompletionProcessor
extends TemplateCompletionProcessor {
    private TextFontStyler textFontStyler;
    private static boolean autoActivated = true;
    private static String tokenScope;
    private String contextTypeId;

    public SnippetsCompletionProcessor() {
    }

    public SnippetsCompletionProcessor(boolean autoActivated_, String _tokenScope) {
        autoActivated = autoActivated_;
        tokenScope = _tokenScope;
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        String contentTypeString = "";
        try {
            String replaced;
            int offset = region.getOffset() + region.getLength();
            contentTypeString = this.getDocumentScopeManager().getScopeAtOffset(viewer, offset, tokenScope);
            if (StringUtil.isNotBlank((String)this.getContextTypeId()) && StringUtil.isNotBlank((String)(replaced = this.getDocumentScopeManager().getPartitionScopeFragmentsAtOffset(viewer.getDocument(), offset)))) {
                contentTypeString = contentTypeString.replace(replaced, this.getContextTypeId());
            }
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        return new SnippetTemplateContextType(contentTypeString);
    }

    protected IDocumentScopeManager getDocumentScopeManager() {
        return CommonEditorPlugin.getDefault().getDocumentScopeManager();
    }

    protected Image getImage(Template template) {
        return CommonEditorPlugin.getDefault().getImageFromImageRegistry("/icons/assistant/snippet.png");
    }

    protected Template[] getTemplates(String contextTypeId) {
        LinkedList<CommandTemplate> templatesList = new LinkedList<CommandTemplate>();
        AndFilter filter = new AndFilter(new IModelFilter[]{new ScopeFilter(contextTypeId), new HasTriggerFilter()});
        List commandsFromScope = BundleManager.getInstance().getExecutableCommands((IModelFilter)filter);
        for (CommandElement commandElement : commandsFromScope) {
            String[] triggers = commandElement.getTriggerTypeValues(TriggerType.PREFIX);
            if (triggers == null) continue;
            String[] stringArray = triggers;
            int n = triggers.length;
            int n2 = 0;
            while (n2 < n) {
                String trigger = stringArray[n2];
                if (commandElement instanceof SnippetElement) {
                    templatesList.add(new SnippetTemplate((SnippetElement)commandElement, trigger, contextTypeId));
                } else {
                    templatesList.add(new CommandTemplate(commandElement, trigger, contextTypeId));
                }
                ++n2;
            }
        }
        Collections.sort(templatesList, new Comparator<Template>(){

            @Override
            public int compare(Template template1, Template template2) {
                return template1.getName().compareTo(template2.getName());
            }
        });
        return templatesList.toArray(new Template[0]);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ICompletionProposal[] completionProposals = super.computeCompletionProposals(viewer, offset);
        int i = 0;
        while (i < completionProposals.length) {
            if (completionProposals[i] instanceof SnippetTemplateProposal) {
                SnippetTemplateProposal snippetTemplateProposal = (SnippetTemplateProposal)completionProposals[i];
                snippetTemplateProposal.setTemplateProposals(completionProposals);
                snippetTemplateProposal.setStyler(this.getStyler());
                snippetTemplateProposal.setCompletionProposalType(CompletionProposalType.CODEBLOCK);
            }
            ++i;
        }
        return completionProposals;
    }

    public void setSelectedProposal(String prefix, ICompletionProposal[] proposals) {
        if (prefix == null || proposals == null) {
            return;
        }
        ICompletionProposal[] iCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            int comparison;
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            String displayString = proposal.getDisplayString();
            if (proposal instanceof SnippetTemplateProposal) {
                displayString = ((SnippetTemplateProposal)proposal).getActivationString();
            }
            if ((comparison = displayString.compareToIgnoreCase(prefix)) >= 0 && displayString.toLowerCase().startsWith(prefix.toLowerCase())) {
                if (displayString.startsWith(prefix)) {
                    ((ICommonCompletionProposal)proposal).setRelevance(90);
                } else {
                    ((ICommonCompletionProposal)proposal).setRelevance(50);
                }
            }
            ++n2;
        }
    }

    protected ICompletionProposal createProposal(Template template, TemplateContext context, IRegion region, int relevance) {
        if (template instanceof SnippetTemplate) {
            return new SnippetTemplateProposal(template, context, region, this.getImage(template), relevance);
        }
        return new CommandProposal(template, context, region, this.getImage(template), relevance);
    }

    protected TemplateContext createContext(ITextViewer viewer, IRegion region) {
        TemplateContextType contextType = this.getContextType(viewer, region);
        if (contextType != null) {
            IDocument document = viewer.getDocument();
            return new DocumentSnippetTemplateContext(contextType, document, region.getOffset(), region.getLength());
        }
        return null;
    }

    protected String extractPrefix(ITextViewer viewer, int offset) {
        return SnippetsCompletionProcessor.extractPrefixFromDocument(viewer.getDocument(), offset);
    }

    static String extractPrefixFromDocument(IDocument document, int offset) {
        char[] chars = SnippetsCompletionProcessor.getChars(document, offset);
        if (offset > document.getLength()) {
            return "";
        }
        int i = offset;
        try {
            while (i > 0) {
                char ch = document.getChar(i - 1);
                if (Character.isWhitespace(ch) || SnippetsCompletionProcessor.checkChar(chars, ch)) break;
                --i;
            }
            return document.get(i, offset - i);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    private static char[] getChars(IDocument document, int offset) {
        char[] chars = new char[]{'(', ')', '{', '}', ';', ':', ',', '>', '=', '\"', '\''};
        return chars;
    }

    public static boolean checkChar(char[] chars, char key) {
        if (chars == null) {
            return false;
        }
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == key) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void insertAsTemplate(ITextViewer textViewer, IRegion region, String templateText, CommandElement commandElement) {
        String key;
        String[] keys = commandElement.getKeyBindings();
        if (keys.length > 0 && StringUtil.isNotBlank((String)(key = keys[0])) && (key.equals("M1+M2+/") || key.toLowerCase().equals("ctrl+shift+/"))) {
            return;
        }
        SnippetsCompletionProcessor snippetsCompletionProcessor = new SnippetsCompletionProcessor();
        SnippetTemplate template = new SnippetTemplate(commandElement, templateText);
        TemplateContext context = snippetsCompletionProcessor.createContext(textViewer, region);
        SnippetTemplateProposal completionProposal = (SnippetTemplateProposal)snippetsCompletionProcessor.createProposal(template, context, region, 0);
        completionProposal.setTemplateProposals(new ICompletionProposal[]{completionProposal});
        completionProposal.apply(textViewer, '0', 0, region.getOffset());
        Point selection = completionProposal.getSelection(textViewer.getDocument());
        if (selection != null) {
            textViewer.setSelectedRange(selection.x, selection.y);
            textViewer.revealRange(selection.x, selection.y);
        }
    }

    private StyledString.Styler getStyler() {
        if (this.textFontStyler == null) {
            this.textFontStyler = new TextFontStyler();
        }
        return this.textFontStyler;
    }

    void possibleCompletionsClosed() {
        if (this.textFontStyler != null) {
            this.textFontStyler.dispose();
            this.textFontStyler = null;
        }
    }

    static String narrowPrefix(String prefix) {
        int i = 0;
        while (i < prefix.length()) {
            char ch = prefix.charAt(i);
            if (!Character.isLetterOrDigit(ch)) {
                return prefix.substring(i + 1);
            }
            ++i;
        }
        return "";
    }

    public void setContextTypeId(String contextTypeId) {
        this.contextTypeId = contextTypeId;
    }

    public String getContextTypeId() {
        return this.contextTypeId;
    }

    private static class TextFontStyler
    extends StyledString.Styler {
        private Font maxHeightTextFont;

        private TextFontStyler() {
            Font textFont = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
            FontData[] textFontData = textFont.getFontData();
            if (textFontData[0].getHeight() > SnippetsContentAssistant.MAX_HEIGHT) {
                this.maxHeightTextFont = new Font(textFont.getDevice(), textFontData[0].getName(), SnippetsContentAssistant.MAX_HEIGHT, textFontData[0].getStyle());
            }
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.font = this.maxHeightTextFont != null ? this.maxHeightTextFont : JFaceResources.getTextFont();
        }

        private void dispose() {
            if (this.maxHeightTextFont != null) {
                if (!this.maxHeightTextFont.isDisposed()) {
                    this.maxHeightTextFont.dispose();
                }
                this.maxHeightTextFont = null;
            }
        }
    }
}

