/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.scripting.snippets;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.scripting.commands.CommandExecutionUtils;
import com.aptana.editor.common.scripting.snippets.CommandTemplate;
import com.aptana.editor.common.scripting.snippets.SnippetTemplateProposal;
import com.aptana.scripting.ScriptingActivator;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.CommandResult;
import com.aptana.scripting.model.InvocationType;
import com.aptana.scripting.model.OutputType;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.UndoEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class CommandProposal
extends SnippetTemplateProposal {
    public CommandProposal(Template template, TemplateContext context, IRegion region, Image image, int relevance) {
        super(template, context, region, image, relevance);
    }

    @Override
    protected void doApply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        UndoEdit edit = null;
        Point selection = null;
        Template template = this.getTemplate();
        if (template instanceof CommandTemplate) {
            CommandResult commandResult;
            IEditorPart part;
            IWorkbenchPage page;
            CommandTemplate commandTemplate = (CommandTemplate)template;
            CommandElement commandElement = commandTemplate.getCommandElement();
            try {
                IDocument document = viewer.getDocument();
                int start = this.getReplaceOffset();
                int end = offset;
                String replacement = "";
                if (end == document.getLength()) {
                    String[] lineDelimeters = document.getLegalLineDelimiters();
                    replacement = lineDelimeters != null && lineDelimeters.length > 0 ? lineDelimeters[0] : "\n";
                }
                ReplaceEdit replaceEdit = new ReplaceEdit(start, end - start, replacement);
                selection = viewer.getSelectedRange();
                edit = replaceEdit.apply(document);
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)e.getMessage(), (Throwable)e);
            }
            ITextEditor textEditor = null;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null && (part = page.getActiveEditor()) instanceof ITextEditor) {
                textEditor = (ITextEditor)part;
            }
            if (!(commandResult = CommandExecutionUtils.executeCommand(commandElement, InvocationType.TRIGGER, viewer, textEditor)).executedSuccessfully() || this.restorePrefix(commandResult.getOutputType())) {
                try {
                    edit.apply(viewer.getDocument());
                    viewer.setSelectedRange(selection.x, selection.y);
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                }
            }
            CommandExecutionUtils.processCommandResult(commandElement, commandResult, viewer);
        }
    }

    private boolean restorePrefix(OutputType outputType) {
        switch (outputType) {
            case INSERT_AS_TEXT: 
            case INSERT_AS_SNIPPET: {
                return false;
            }
        }
        return true;
    }

    @Override
    public Point getSelection(IDocument document) {
        return null;
    }
}

