/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.realtime;

import com.aptana.core.IURIMapper;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.URLEncoder;
import com.aptana.ui.util.RunInBrowserUtil;
import com.aptana.webserver.core.IServerChangeListener;
import com.aptana.webserver.core.ServerChangeEvent;
import com.aptana.webserver.core.WebServerCorePlugin;
import com.pandora.core.log.HBLog;
import com.pandora.realtime.preview.RealTimeActivator;
import com.pandora.realtime.preview.RealTimeHelper;
import java.net.URL;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class WebServerChangeListener {
    public static void addWebServerChangeListener() {
        WebServerChangeListener.addPreferenceChangeListener();
        WebServerChangeListener.addServerChangeListener();
    }

    private static IEclipsePreferences.IPreferenceChangeListener addPreferenceChangeListener() {
        IEclipsePreferences.IPreferenceChangeListener propertyChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if ((event.getNewValue() == null || !event.getNewValue().equals(event.getOldValue())) && RealTimeHelper.getEditorInputFile() != null && event.getKey().startsWith("RUNINBROWSER_SERVER_PREFIX_")) {
                    WebServerChangeListener.resetEditorInputUrl();
                }
            }
        };
        EclipseUtil.instanceScope().getNode("com.aptana.webserver.core").addPreferenceChangeListener(propertyChangeListener);
        return propertyChangeListener;
    }

    private static IServerChangeListener addServerChangeListener() {
        IServerChangeListener serverChangeListener = new IServerChangeListener(){

            public void configurationChanged(ServerChangeEvent event) {
                if (event.getKind() == ServerChangeEvent.Kind.UPDATED && !event.isStateUpdate() && RealTimeHelper.getEditorInputFile() != null && event.getServer() == RunInBrowserUtil.getRunnableServer((String)RealTimeHelper.getEditorInputFile().getName())) {
                    WebServerChangeListener.resetEditorInputUrl();
                }
            }
        };
        WebServerCorePlugin.getDefault().getServerManager().addServerChangeListener(serverChangeListener);
        return serverChangeListener;
    }

    private static void resetEditorInputUrl() {
        if (RealTimeHelper.getEditorInputFile() == null) {
            return;
        }
        IURIMapper urlMapper = RunInBrowserUtil.getRunnableServerMapper((String)RealTimeHelper.getEditorInputFile().getName());
        try {
            URL launch;
            if (urlMapper != null && (launch = urlMapper.resolve(RealTimeHelper.getEditorInputFile()).toURL()) != null && !(launch = new URL(launch, URLEncoder.encode((String)launch.getPath(), (String)launch.getQuery(), (String)launch.getRef()))).toString().equals(RealTimeHelper.getEditorInputUrl())) {
                RealTimeHelper.setEditorInputUrl((String)launch.toString());
                RealTimeHelper.setRealTimeBrowserURL();
            }
        }
        catch (Throwable e) {
            HBLog.logError((Plugin)RealTimeActivator.getDefault(), (Throwable)e);
        }
    }
}

