/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.realtime;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.index.IReferIndexQueryHelper;
import com.pandora.realtime.preview.RealTimeHelper;
import com.pandora.view.browser.views.BrowserComposite;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.progress.UIJob;

public class RealTimeReferenceFileChangeListener
implements IResourceChangeListener {
    private RefreshBrowserJob refreshBrowserJob;

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            ArrayList<IFile> result = new ArrayList<IFile>();
            if (delta.getResource() instanceof IFile) {
                result.add((IFile)delta.getResource());
            } else {
                this.getIFileFromIResourceDelta(result, delta.getAffectedChildren());
            }
            this.refreshBrowser(result);
        }
    }

    private void getIFileFromIResourceDelta(List<IFile> result, IResourceDelta[] deltas) {
        if (deltas != null && deltas.length > 0) {
            IResourceDelta[] iResourceDeltaArray = deltas;
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta delta = iResourceDeltaArray[n2];
                if (delta.getResource() instanceof IFile) {
                    result.add((IFile)delta.getResource());
                } else {
                    this.getIFileFromIResourceDelta(result, delta.getAffectedChildren());
                }
                ++n2;
            }
        }
    }

    protected void refreshBrowser(List<IFile> result) {
        if (!(result == null || result.isEmpty() || this.refreshBrowserJob != null && this.refreshBrowserJob.getState() != 0 && this.refreshBrowserJob.getResultFiles().equals(result))) {
            RefreshBrowserJob job = new RefreshBrowserJob("reference file update and refresh cef", result);
            job.setSystem(true);
            job.schedule();
            this.refreshBrowserJob = job;
        }
    }

    private class RefreshBrowserJob
    extends UIJob {
        private List<IFile> result;

        public RefreshBrowserJob(String name, List<IFile> result) {
            super(name);
            this.result = result;
        }

        public List<IFile> getResultFiles() {
            return this.result;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                if (RealTimeHelper.isWebViewShowed()) {
                    IReferIndexQueryHelper indexQueryHelper = CommonEditorPlugin.getDefault().getReferIndexQueryHelper();
                    for (IFile file : this.result) {
                        IProject project;
                        Set<String> linkHtmls;
                        if (file == null || file.getProject() == null || file.getLocation() == null || (linkHtmls = indexQueryHelper.getFileReference(project = file.getProject(), file.getLocation().makeAbsolute().toFile().getAbsolutePath())) == null) continue;
                        for (String name : linkHtmls) {
                            String path = String.valueOf(project.getName()) + "/" + name;
                            BrowserComposite viewer = RealTimeHelper.getBrowserViewer();
                            if (viewer == null || !RealTimeHelper.iSameWithWebViewUriPath((String)path, (BrowserComposite)viewer)) continue;
                            RealTimeHelper.getRealTimeInterface().startWebServer(name);
                            viewer.refresh();
                            return Status.OK_STATUS;
                        }
                    }
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }
}

