/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.realtime;

import com.aptana.core.IURIMapper;
import com.aptana.core.io.efs.EFSUtils;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.URLEncoder;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.ui.UIPlugin;
import com.aptana.ui.util.RunInBrowserUtil;
import com.aptana.webserver.core.IServer;
import com.pandora.realtime.preview.IRealTimeInterface;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;

public class RealTimeInterface
implements IRealTimeInterface {
    public void beforeActiveEditor(String fileName) {
    }

    public IFileStore convertFile(IFile file) {
        return EFSUtils.getFileStore((IResource)file);
    }

    public URL convertURL(IFileStore file) {
        try {
            IURIMapper urlMapper = RunInBrowserUtil.getRunnableServerMapper((String)file.getName());
            if (urlMapper != null) {
                URL launch = urlMapper.resolve(file).toURL();
                return new URL(launch, URLEncoder.encode((String)launch.getPath(), (String)launch.getQuery(), (String)launch.getRef()));
            }
        }
        catch (MalformedURLException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    public void beforeRealTimeFileNameChange(String filename) {
        RunInBrowserUtil.checkAndAlertCreateServer((String)"\u8fb9\u6539\u8fb9\u770b", (String)filename);
    }

    public boolean isRealTimeFileNameEnable(String fileName) {
        try {
            if (fileName != null) {
                return RunInBrowserUtil.isRunnable((String)fileName);
            }
            return false;
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            return false;
        }
    }

    public void startWebServer(String filename) {
        try {
            IServer server = RunInBrowserUtil.getRunnableServer((String)filename);
            if (server != null && server.getState() != IServer.State.STARTED && server.getState() != IServer.State.STARTING) {
                try {
                    server.start("run", (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
                }
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }
}

