/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.preferences;

import com.aptana.build.ui.BuildUIPlugin;
import com.aptana.build.ui.preferences.IBuildParticipantPreferenceCompositeFactory;
import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.core.IFilter;
import com.aptana.core.IMap;
import com.aptana.core.build.BuilderJob;
import com.aptana.core.build.IBuildParticipant;
import com.aptana.core.build.IBuildParticipantManager;
import com.aptana.core.build.IBuildParticipantWorkingCopy;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonSourceViewerConfiguration;
import com.aptana.editor.common.preferences.Messages;
import com.aptana.ui.util.UIUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class ValidationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String NAME = "name";
    private static final String BUILD = "build";
    private static final String RECONCILE = "reconcile";
    private boolean onlyRemoveMarker;
    private TableViewer validatorsViewer;
    private Control filterComp;
    private List<IBuildParticipantWorkingCopy> participants;
    private Composite sash;

    public ValidationPreferencePage() {
        List participants = this.getBuildParticipantManager().getAllBuildParticipants();
        participants = CollectionsUtil.filter((Collection)participants, (IFilter)new IFilter<IBuildParticipant>(){

            public boolean include(IBuildParticipant item) {
                return !item.isRequired() && !StringUtil.isEmpty((String)item.getName());
            }
        });
        Collections.sort(participants, new Comparator<IBuildParticipant>(){

            @Override
            public int compare(IBuildParticipant o1, IBuildParticipant o2) {
                return StringUtil.compare((String)o1.getName(), (String)o2.getName());
            }
        });
        this.participants = CollectionsUtil.map((Collection)participants, (IMap)new IMap<IBuildParticipant, IBuildParticipantWorkingCopy>(){

            public IBuildParticipantWorkingCopy map(IBuildParticipant item) {
                return item.getWorkingCopy();
            }
        });
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(CommonEditorPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        this.sash = new Composite(parent, 0);
        this.sash.setLayout((Layout)new GridLayout());
        this.sash.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Control validators = this.createValidators(this.sash);
        validators.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.createFiltersComposite();
        return this.sash;
    }

    private void createFiltersComposite() {
        if (this.filterComp != null && !this.filterComp.isDisposed()) {
            this.filterComp.dispose();
        }
        this.filterComp = this.getBuildParticipantPreferenceCompositeFactory().createPreferenceComposite(this.sash, this.getSelectedBuildParticipant());
        this.filterComp.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.sash.layout(true);
    }

    protected IBuildParticipantPreferenceCompositeFactory getBuildParticipantPreferenceCompositeFactory() {
        return BuildUIPlugin.getDefault().getBuildParticipantPreferenceCompositeFactory();
    }

    protected IBuildParticipantManager getBuildParticipantManager() {
        return BuildPathCorePlugin.getDefault().getBuildParticipantManager();
    }

    protected void performDefaults() {
        for (IBuildParticipant iBuildParticipant : this.participants) {
            iBuildParticipant.restoreDefaults();
        }
        this.validatorsViewer.refresh();
        this.updateFilterExpressions();
        super.performDefaults();
    }

    public boolean performOk() {
        boolean rebuild = this.rebuild();
        boolean reReconcile = this.needsReconcile();
        ApplyChangesAndBuildJob buildJob = new ApplyChangesAndBuildJob(Messages.ValidationPreferencePage_RebuildJobTitle, rebuild, reReconcile);
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof IWorkbenchPreferenceContainer) {
            ((IWorkbenchPreferenceContainer)container).registerUpdateJob((Job)buildJob);
        } else {
            buildJob.schedule();
        }
        return true;
    }

    private boolean needsReconcile() {
        for (IBuildParticipantWorkingCopy change : this.participants) {
            if (!change.needsReconcile()) continue;
            return true;
        }
        return false;
    }

    private boolean rebuild() {
        if (this.promptForRebuild()) {
            MessageDialog dialog = new MessageDialog(this.getShell(), Messages.ValidationPreferencePage_RebuildDialogTitle, null, Messages.ValidationPreferencePage_RebuildDialogMessage, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
            return dialog.open() == 0;
        }
        return false;
    }

    private boolean promptForRebuild() {
        this.onlyRemoveMarker = false;
        for (IBuildParticipantWorkingCopy change : this.participants) {
            if (!change.needsRebuild()) continue;
            this.onlyRemoveMarker = this.onlyRemoveMarker || !change.isEnabled(IBuildParticipant.BuildType.BUILD);
            return true;
        }
        return false;
    }

    private Control createValidators(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        Composite labelComp = new Composite(main, 0);
        labelComp.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(5, 0, 0, 0).numColumns(2).spacing(2, -1).create());
        labelComp.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, false).create());
        Label label = new Label(labelComp, 0);
        label.setText(Messages.ValidationPreferencePage_EnablingValidatorWarning);
        Group group = new Group(main, 0);
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(4, 4).create());
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Table table = new Table((Composite)group, 68356);
        table.setLayoutData((Object)GridDataFactory.fillDefaults().hint(300, 150).grab(true, false).create());
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn name = new TableColumn(table, 16384);
        name.setWidth(200);
        name.setText(Messages.ValidationPreferencePage_NameColumn);
        name.setToolTipText(Messages.ValidationPreferencePage_NameColumn);
        TableColumn build = new TableColumn(table, 0x1000000);
        build.setWidth(50);
        build.setText(Messages.ValidationPreferencePage_BuildColumn);
        build.setToolTipText(Messages.ValidationPreferencePage_BuildColumn);
        this.validatorsViewer = new TableViewer(table);
        this.validatorsViewer.setColumnProperties(new String[]{NAME, BUILD});
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = new CheckboxCellEditor((Composite)table);
        this.validatorsViewer.setCellEditors(cellEditorArray);
        this.validatorsViewer.setCellModifier((ICellModifier)new ParticipantCellModifier(this.validatorsViewer));
        this.validatorsViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.validatorsViewer.setLabelProvider((IBaseLabelProvider)new ParticipantLabelProvider());
        this.validatorsViewer.addFilter((ViewerFilter)new RequiredParticipantFilter());
        this.validatorsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ValidationPreferencePage.this.updateFilterExpressions();
            }
        });
        this.validatorsViewer.setInput(this.participants);
        return main;
    }

    private IBuildParticipantWorkingCopy getSelectedBuildParticipant() {
        IStructuredSelection selection = (IStructuredSelection)this.validatorsViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (IBuildParticipantWorkingCopy)selection.getFirstElement();
    }

    private void updateFilterExpressions() {
        this.createFiltersComposite();
    }

    private final class ApplyChangesAndBuildJob
    extends Job {
        private final boolean rebuild;
        private final boolean reReconcile;

        private ApplyChangesAndBuildJob(String name, boolean rebuild, boolean reReconcile) {
            super(name);
            this.rebuild = rebuild;
            this.reReconcile = reReconcile;
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            this.setUser(true);
            this.setProperty(BuilderJob.BUILDTYPE_VALIDATION, ValidationPreferencePage.this.onlyRemoveMarker ? "VALIDATION_ONLY_REMOVE_MARKEER" : "VALIDATION_ALL");
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ValidationPreferencePage_RebuildJobTaskName, (int)100);
            try {
                try {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    if (this.rebuild) {
                        sub.subTask(Messages.ValidationPreferencePage_CleaningProjects);
                        workspace.build(15, (IProgressMonitor)sub.newChild(20));
                        sub.setWorkRemaining(80);
                    }
                    sub.subTask(Messages.ValidationPreferencePage_ApplyingChangesToParticipants);
                    for (IBuildParticipantWorkingCopy change : ValidationPreferencePage.this.participants) {
                        change.doSave();
                    }
                    sub.worked(10);
                    if (this.reReconcile) {
                        UIJob job = new UIJob(Messages.ValidationPreferencePage_ForcingReconcile){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                IEditorReference[] refs = UIUtils.getActivePage().getEditorReferences();
                                monitor.beginTask(Messages.ValidationPreferencePage_ReconcilingOpenEditors, refs.length);
                                IEditorReference[] iEditorReferenceArray = refs;
                                int n = refs.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IEditorReference ref = iEditorReferenceArray[n2];
                                    if (monitor.isCanceled()) {
                                        return Status.CANCEL_STATUS;
                                    }
                                    IEditorPart part = ref.getEditor(false);
                                    if (part instanceof AbstractTextEditor) {
                                        monitor.subTask(part.getTitle());
                                        if (part instanceof AbstractThemeableEditor) {
                                            AbstractThemeableEditor ate = (AbstractThemeableEditor)part;
                                            CommonSourceViewerConfiguration csvc = (CommonSourceViewerConfiguration)ate.getAdapter(SourceViewerConfiguration.class);
                                            csvc.forceReconcile();
                                        } else {
                                            AbstractTextEditor editor = (AbstractTextEditor)part;
                                            IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                                            doc.set(doc.get());
                                        }
                                    }
                                    monitor.worked(1);
                                    ++n2;
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        job.setProperty(BuilderJob.BUILDTYPE_VALIDATION, (Object)true);
                        job.schedule(500L);
                    }
                    if (this.rebuild) {
                        sub.subTask(Messages.ValidationPreferencePage_RebuildingProjects);
                        workspace.build(6, (IProgressMonitor)sub.newChild(70));
                    }
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    sub.done();
                    return iStatus;
                }
                catch (OperationCanceledException operationCanceledException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    sub.done();
                    return iStatus;
                }
            }
            finally {
                sub.done();
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
        }
    }

    private final class ParticipantCellModifier
    implements ICellModifier {
        private TableViewer tableViewer;

        private ParticipantCellModifier(TableViewer tableViewer) {
            this.tableViewer = tableViewer;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof TableItem) {
                element = ((TableItem)element).getData();
            }
            IBuildParticipantWorkingCopy participant = (IBuildParticipantWorkingCopy)element;
            if (ValidationPreferencePage.BUILD.equals(property)) {
                participant.setEnabled(IBuildParticipant.BuildType.BUILD, ((Boolean)value).booleanValue());
            }
            this.tableViewer.refresh((Object)participant);
        }

        public Object getValue(Object element, String property) {
            IBuildParticipant participant = (IBuildParticipant)element;
            if (ValidationPreferencePage.BUILD.equals(property)) {
                return participant.isEnabled(IBuildParticipant.BuildType.BUILD);
            }
            return null;
        }

        public boolean canModify(Object element, String property) {
            return ValidationPreferencePage.BUILD.equals(property);
        }
    }

    private static final class ParticipantLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final String RED_X_ICON = "platform:/plugin/com.aptana.ui/icons/delete.gif";
        private static final String CHECKMARK_ICON = "platform:/plugin/com.aptana.ui/icons/ok.png";

        private ParticipantLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            IBuildParticipant participant = (IBuildParticipant)element;
            if (columnIndex == 0) {
                return participant.getName();
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            IBuildParticipant participant = (IBuildParticipant)element;
            if (columnIndex == 1) {
                if (participant.isEnabled(IBuildParticipant.BuildType.BUILD)) {
                    return UIUtils.getImage((AbstractUIPlugin)CommonEditorPlugin.getDefault(), (String)CHECKMARK_ICON);
                }
                return UIUtils.getImage((AbstractUIPlugin)CommonEditorPlugin.getDefault(), (String)RED_X_ICON);
            }
            return null;
        }
    }

    private static final class RequiredParticipantFilter
    extends ViewerFilter {
        private RequiredParticipantFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IBuildParticipant) {
                IBuildParticipant participant = (IBuildParticipant)element;
                return !participant.isRequired();
            }
            return true;
        }
    }
}

