/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.parsing;

import com.aptana.editor.common.parsing.IScannerSwitchStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;

public class CompositeTokenScanner
implements ITokenScanner {
    private static final int DEFAULT_INDEX = -1;
    private ITokenScanner fPrimaryTokenScanner;
    private IScannerSwitchStrategy[] fSwitchStrategies;
    private int fCurrentIndex;

    public CompositeTokenScanner(ITokenScanner primaryTokenScanner, IScannerSwitchStrategy[] switchStrategies) {
        this.fPrimaryTokenScanner = primaryTokenScanner;
        this.fSwitchStrategies = switchStrategies;
        this.fCurrentIndex = -1;
    }

    public IScannerSwitchStrategy getCurrentSwitchStrategy() {
        if (this.fCurrentIndex == -1) {
            return null;
        }
        return this.fSwitchStrategies[this.fCurrentIndex];
    }

    public ITokenScanner getPrimaryTokenScanner() {
        return this.fPrimaryTokenScanner;
    }

    public int getTokenLength() {
        return this.fPrimaryTokenScanner.getTokenLength();
    }

    public int getTokenOffset() {
        return this.fPrimaryTokenScanner.getTokenOffset();
    }

    public IToken nextToken() {
        IToken token = this.fPrimaryTokenScanner.nextToken();
        Object data = token.getData();
        if (data != null) {
            if (this.fCurrentIndex == -1) {
                this.fCurrentIndex = this.getScannerIndex(data.toString());
            } else if (this.hasExitToken(data.toString())) {
                this.resetIndex();
            }
        }
        return token;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.fPrimaryTokenScanner.setRange(document, offset, length);
    }

    protected IScannerSwitchStrategy[] getSwitchStrategies() {
        return this.fSwitchStrategies;
    }

    protected void setSwitchStrategies(IScannerSwitchStrategy[] strategies) {
        this.fSwitchStrategies = strategies;
    }

    protected void setPrimaryTokenScanner(ITokenScanner scanner) {
        this.fPrimaryTokenScanner = scanner;
    }

    private int getScannerIndex(String data) {
        int i = 0;
        while (i < this.fSwitchStrategies.length) {
            String[] tokens;
            String[] stringArray = tokens = this.fSwitchStrategies[i].getEnterTokens();
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                if (data.equals(token)) {
                    return i;
                }
                ++n2;
            }
            ++i;
        }
        return -1;
    }

    private boolean hasExitToken(String data) {
        String[] tokens;
        String[] stringArray = tokens = this.fSwitchStrategies[this.fCurrentIndex].getExitTokens();
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (data.equals(token)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void resetIndex() {
        this.fCurrentIndex = -1;
    }

    protected void reset() {
        this.resetIndex();
    }
}

