/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.outline;

import com.aptana.parsing.ast.ILanguageNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.lexer.IRange;

public class CommonOutlineItem
implements ILanguageNode,
IRange,
Comparable<IRange> {
    private IRange fSourceRange;
    private IParseNode fReferenceNode;

    public CommonOutlineItem(IRange sourceRange, IParseNode referenceNode) {
        this.fSourceRange = sourceRange;
        this.fReferenceNode = referenceNode;
    }

    public String getLabel() {
        return this.fReferenceNode == null ? "" : this.fReferenceNode.getText();
    }

    @Override
    public int compareTo(IRange o) {
        return this.getStartingOffset() - o.getStartingOffset();
    }

    public boolean contains(int offset) {
        return this.fSourceRange.contains(offset);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CommonOutlineItem) || this.fReferenceNode == null) {
            return false;
        }
        CommonOutlineItem item = (CommonOutlineItem)obj;
        return this.fReferenceNode.equals(item.fReferenceNode) && this.fSourceRange.getStartingOffset() == item.fSourceRange.getStartingOffset() && this.fSourceRange.getEndingOffset() == item.fSourceRange.getEndingOffset();
    }

    public int getEndingOffset() {
        return this.fSourceRange.getEndingOffset();
    }

    public int getLength() {
        if (this.fSourceRange == null) {
            return -1;
        }
        return this.fSourceRange.getLength();
    }

    public IParseNode getReferenceNode() {
        return this.fReferenceNode;
    }

    public IRange getSourceRange() {
        return this.fSourceRange;
    }

    public int getStartingOffset() {
        if (this.fSourceRange == null) {
            return -1;
        }
        return this.fSourceRange.getStartingOffset();
    }

    public String getLanguage() {
        return this.getReferenceNode().getLanguage();
    }

    public int hashCode() {
        if (this.fReferenceNode == null) {
            return -1;
        }
        int hash = this.fReferenceNode.hashCode();
        hash = hash * 31 + this.fSourceRange.getStartingOffset();
        hash = hash * 31 + this.fSourceRange.getEndingOffset();
        return hash;
    }

    public boolean isEmpty() {
        return this.fSourceRange.isEmpty();
    }

    public void setRange(IRange range) {
        this.fSourceRange = range;
    }
}

