/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.outline;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.outline.CommonOutlineItem;
import com.aptana.editor.common.outline.CommonOutlinePageInput;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.ast.ParseNode;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class CommonOutlineContentProvider
implements ITreeContentProvider {
    protected static final Object[] EMPTY = ArrayUtil.NO_OBJECTS;

    public CommonOutlineItem getOutlineItem(IParseNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof ParseNode) {
            return new CommonOutlineItem(((ParseNode)node).getNameRange(), node);
        }
        return new CommonOutlineItem(node.getNameNode().getNameRange(), node);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof CommonOutlinePageInput) {
            parentElement = ((CommonOutlinePageInput)parentElement).ast;
        }
        if (parentElement instanceof IParseRootNode) {
            return this.filter(((IParseNode)parentElement).getChildren());
        }
        if (parentElement instanceof IParseNode) {
            return this.filter(((IParseNode)parentElement).getChildren());
        }
        if (parentElement instanceof CommonOutlineItem) {
            return this.getChildren(((CommonOutlineItem)parentElement).getReferenceNode());
        }
        if (parentElement instanceof AbstractThemeableEditor) {
            IdeLog.logTrace((Plugin)CommonEditorPlugin.getDefault(), (String)"The input of the content provider should be the IParseRootNode, not the editor!");
            IParseRootNode rootNode = ((AbstractThemeableEditor)parentElement).getAST();
            if (rootNode != null) {
                return this.filter(rootNode.getChildren());
            }
        }
        return EMPTY;
    }

    public Object getParent(Object element) {
        if (element instanceof IParseNode) {
            return ((IParseNode)element).getParent();
        }
        if (element instanceof CommonOutlineItem) {
            IParseNode node = ((CommonOutlineItem)element).getReferenceNode();
            if (node == null) {
                return null;
            }
            return this.getOutlineItem(node.getParent());
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    protected Object[] filter(IParseNode[] nodes) {
        return nodes;
    }
}

