/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal.hover;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.scripting.QualifiedContentType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.ITextHover;

public class TextHoverDescriptor {
    private static final String EXTENSION_POINT_ID = "com.aptana.editor.common.textHovers";
    private static final String TAG_CONTENT_TYPE = "contentType";
    private static final String TAG_HOVER = "hover";
    private static final String ATT_CLASS = "class";
    private static final String ATT_TYPE = "type";
    private static List<TextHoverDescriptor> descriptors = null;
    private final IConfigurationElement configurationElement;
    private final Set<String> contentTypes = new HashSet<String>();
    private final Expression enablementExpression;

    private TextHoverDescriptor(IConfigurationElement configurationElement) throws CoreException {
        this.configurationElement = configurationElement;
        IConfigurationElement[] iConfigurationElementArray = configurationElement.getChildren(TAG_CONTENT_TYPE);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            this.readElement(element);
            ++n2;
        }
        IConfigurationElement[] elements = configurationElement.getChildren("enablement");
        this.enablementExpression = elements.length > 0 ? ExpressionConverter.getDefault().perform(elements[0]) : null;
    }

    public static List<TextHoverDescriptor> getContributedHovers() {
        if (descriptors == null) {
            TextHoverDescriptor.readExtensionRegistry();
        }
        return Collections.unmodifiableList(descriptors);
    }

    private static void readExtensionRegistry() {
        IConfigurationElement[] elements;
        descriptors = new ArrayList<TextHoverDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (TAG_HOVER.equals(element.getName())) {
                try {
                    descriptors.add(new TextHoverDescriptor(element));
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                }
            }
            ++n2;
        }
    }

    private void readElement(IConfigurationElement element) {
        if (TAG_CONTENT_TYPE.equals(element.getName())) {
            String type = element.getAttribute(ATT_TYPE);
            if (type == null || type.length() == 0) {
                return;
            }
            this.contentTypes.add(type);
        }
    }

    public boolean isEnabledFor(QualifiedContentType contentType, IEvaluationContext context) {
        if (!this.handlesContentType(contentType)) {
            return false;
        }
        if (this.enablementExpression != null) {
            try {
                return this.enablementExpression.evaluate(context) != EvaluationResult.FALSE;
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public ITextHover createTextHover() {
        try {
            return (ITextHover)this.configurationElement.createExecutableExtension(ATT_CLASS);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    private boolean handlesContentType(QualifiedContentType contentType) {
        for (String type : this.contentTypes) {
            if (!contentType.contains(type)) continue;
            return true;
        }
        return false;
    }
}

