/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.dnd;

import com.aptana.scripting.model.SnippetElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class SnippetTransfer
extends ByteArrayTransfer {
    static SnippetTransfer _instance = new SnippetTransfer();
    static final String ID_NAME = "SNIPPET_TRANSFER";
    static final int[] IDS = new int[]{SnippetTransfer.registerType((String)"SNIPPET_TRANSFER")};

    public static SnippetTransfer getInstance() {
        return _instance;
    }

    protected int[] getTypeIds() {
        return IDS;
    }

    protected String[] getTypeNames() {
        return new String[]{ID_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        if (object instanceof SnippetElement) {
            SnippetElement snippetElement = (SnippetElement)object;
            byte[] bytes = this.getBytes(snippetElement);
            if (bytes != null) {
                super.javaToNative((Object)bytes, transferData);
            }
        } else {
            super.javaToNative(object, transferData);
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        return this.fromBytes(bytes);
    }

    private byte[] getBytes(SnippetElement element) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        byte[] bytes = null;
        try {
            String path = element.getPath();
            out.writeUTF(path != null ? path : "");
            String displayName = element.getDisplayName();
            out.writeUTF(displayName != null ? displayName : "");
            String scope = element.getScope();
            out.writeUTF(scope != null ? scope : "");
            String expansion = element.getExpansion();
            out.writeUTF(expansion != null ? expansion : "");
            out.close();
            bytes = byteOut.toByteArray();
        }
        catch (IOException iOException) {}
        return bytes;
    }

    private SnippetElement fromBytes(byte[] data) {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(data);
        DataInputStream in = new DataInputStream(byteIn);
        SnippetElement element = null;
        try {
            String path = in.readUTF();
            if (path != null) {
                element = new SnippetElement(path);
                element.setDisplayName(in.readUTF());
                element.setScope(in.readUTF());
                element.setExpansion(in.readUTF());
            }
            in.close();
        }
        catch (IOException iOException) {}
        return element;
    }
}

